/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import net.sf.ehcache.management.resource.ElementEntity;
import net.sf.ehcache.management.resource.services.ElementsResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

/**
 * @author brandony
 */
@Path("/agents/cacheManagers/caches/elements")
public final class AggregateElementsResourceService extends AggregateResourceServiceSupport<ElementEntity>
    implements ElementsResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateElementsResourceService.class);

  public AggregateElementsResourceService() {
    super();
  }

  @Override
  public void deleteElements(UriInfo info) {
    LOG.info(
        String.format("Invoking AggregateElementsResourceService.deleteElements: %s", info.getRequestUri()));

    getValidator().validate(info);
    getSvcClientSvc()
        .proxyDelete(ResourceServiceUtils.cleanURI(info).build(), ResourceServiceUtils.buildAgentIds(info)[0]);
  }
}