/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.services.CacheManagersResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import java.util.Collection;

/**
 * <p>
 * An aggregate implementation of {@link CacheManagersResourceService}.
 * </p>
 *
 * @author brandony
 */
@Path("/agents/cacheManagers")
public final class AggregateCacheManagersResourceService extends AggregateResourceServiceSupport<CacheManagerEntity>
    implements CacheManagersResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateCacheManagersResourceService.class);

  public AggregateCacheManagersResourceService() {
    super();
  }

  /**
   * @see net.sf.ehcache.management.resource.services.CacheManagersResourceService#getCacheManagers(javax.ws.rs.core.UriInfo)
   */
  @Override
  public Collection<CacheManagerEntity> getCacheManagers(UriInfo info) {
    LOG.info(String.format("Invoking getCacheManagers: %s", info.getRequestUri()));

    getValidator().validateSafe(info);
    AggregateCollectionCallback<CacheManagerEntity> callback = new AggregateCollectionCallback<CacheManagerEntity>() {/**/
    };

    return doGet(info, callback, CacheManagerEntity.class);
  }

  @Override
  public void updateCacheManager(UriInfo info,
                                 CacheManagerEntity resource) {
    LOG.info(String.format("Invoking updateCacheManager: %s", info.getRequestUri()));
    getValidator().validate(info);

    getSvcClientSvc()
        .proxyPut(ResourceServiceUtils.cleanURI(info).build(), resource, ResourceServiceUtils.buildAgentIds(info)[0]);
  }

}
