function SettingsManager() {
  var that = this;
  this.$window = $("#manageSettingsWindow");
  this.kWindow = this.$window.kendoWindow({
    title: "Manage Settings",
    actions: ["Close"],
    width: "36em",
    height: "auto",
    visible: false,
    resizable: false,
    modal: true
  }).data("kendoWindow");
  var numberInputConfig = {format: "n0"};
  this.kPollIntervalSeconds = this.$window.find("#pollIntervalSeconds").kendoNumericTextBox(numberInputConfig).data("kendoNumericTextBox");
  this.$window.on("click", "button[id='resetToDefaults']", function() {
    that.resetToDefaults();
  });  
  this.$window.on("click", "a[id='resetToDefaults']", function() {
	    that.resetToDefaults();
	  });
  this.$window.on("click", "button[id='cancelButton']", function() {
    that.kWindow.close();
  });
  this.$window.on("click", "button[id='okButton']", function() {
    that.persistSettings();
  });
  
  var keydownHandler = function(e) {
    switch (e.which) {
      case kendo.keys.ESC: {
        that.kWindow.close();
        break;
      }
      case kendo.keys.ENTER: {
        that.$window.find("button[id='okButton']").click();
        break;
      }
    }
  };
  this.kWindow.bind("open", function() {
    $(document).bind("keydown", keydownHandler);
  });
  this.kWindow.bind("close", function() {
    $(document).unbind("keydown", keydownHandler);
  });
}

SettingsManager.prototype = {
  show: function() {
    this.$window.show();
    this.kWindow.center();
    this.kWindow.open();
    this.setup();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  setup: function() {
    if (userProfile != null) {
      this.kPollIntervalSeconds.value(userProfile.statisticsPollingIntervalMillis/1000);
    } else {
      this.resetToDefaults();
    }
  },
  
  resetToDefaults: function() {
    this.kPollIntervalSeconds.value(5);
  },
  
  persistSettings: function() {
    var that = this;
    
    userProfile.statisticsPollingIntervalMillis = (this.kPollIntervalSeconds.value() * 1000);
    updateUserProfile(userProfile).done(function() {
      that.hide();
    });
  }
};
