function NavigatorGroupPage(group) {
  NavigatorPage.call(this, $("#navigator-group .navigator-group").clone());
  var that = this;
  this.group = group;
  this.$liveConnectionsContent = this.$content.find("#liveConnectionsContent");
  this.$unavailableContent = this.$content.find("#unavailableContent");
  this.$tabStrip = this.$content.find("#tabstrip").kendoTabStrip({
    animation: {
      open:  {effects: false},
      close: {effects: false}
    }
  });
  var dataSourceConfig = function() {
    return {
      data: [],
      schema: {
        model: {
          id: "connection",
          fields: {
            connection: {type: "string", editable: false},
            location: {type: "string", editable: false},
            secured: {type: "boolean", editable: false}
          }
        }
      },
      sort: {field: "connection", dir: "asc"},
      pageSize: 5
     };
  };
  this.liveConnectionsGridDS = new kendo.data.DataSource(dataSourceConfig());
  this.liveConnectionsGrid = this.$liveConnectionsContent.find("#grid_l").kendoTGrid({
    dataSource: this.liveConnectionsGridDS,
    columns: [
      {
        title: "Connections to EHCACHE",
        field: "connection"
      },
      {
        title: "Location",
        field: "location", 
        template: "<span class=#=secured ? 'securityOn' : 'securityOff'#>#= location #</span>"
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true
  });
  
  this.unavailableGridDS = new kendo.data.DataSource(dataSourceConfig());
  this.unavailableGrid = this.$unavailableContent.find("#grid_u").kendoTGrid({
    dataSource: this.unavailableGridDS,
    columns: [
      {
        title: "Connection",
        field: "connection",
        template: "<a class='editConnectionLink' href='\\#'>#= connection #</a>"
      },
      {
        title: "Location",
        field: "location",
        template: "<span class=#=secured ? 'securityOn' : 'securityOff'#>#= location #</span>"
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true
  });
  
  resizeHandler(this.$content, function(e) {
    assignRemainingHeight(that.$tabStrip);    
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").filter(":visible").height(pageHeight);    
    that.liveConnectionsGrid.data("kendoTGrid")._setContentHeight();
    that.unavailableGrid.data("kendoTGrid")._setContentHeight();
  });
}

NavigatorGroupPage.prototype = $.extend({}, NavigatorPage.prototype, {
  show: function() {
    var that = this;
    $contentArea.append(this.$content); 
    this.$content.show();
    this.$content.on("click", ".editConnectionLink", function(e) {
      e.preventDefault();
      window.connectionManager.editConnection(that.group, $(this).text());
    });
  },  
 
  hide: function() {
    this.$content = $contentArea.find(".navigator-group").detach();
    this.$content.off('click');
  },

  handleResponse: function(data) {
    var that = this,
      unavailable = {},
      available = {},
      liveGridDS = this.liveConnectionsGridDS,
      unavailableGridDS = this.unavailableGridDS,
      agentConnections = {};
    
    $.each(data, function(i, value) {
      var agentId = value.agentId,
        agentIdComps = agentId.split("_"),
        agentGroup = agentIdComps[0],
        connectionName = agentIdComps[1];
      
      if (agentGroup == that.group) {
        var connection = connections[that.group][connectionName];

        connection.secured = value.secured;
        agentConnections[connectionName] = {
          restAPIVersion: value.restAPIVersion,
          available: value.available,
          connection: connectionName,
          location: connection.agentLocation,
          secured: connection.secured
        };
      }
    });

    $.each(agentConnections, function(connectionName, entry) {
      var $grid,
        ds;
   
      if (entry.available) {
        $grid = that.liveConnectionsGrid;
        ds = liveGridDS;
        available[connectionName] = entry;
      } else {
        $grid = that.unavailableGrid;
        ds = unavailableGridDS;
        unavailable[connectionName] = entry;
      }
      
      if (ds.get(connectionName) == null) {
        var connection = connections[that.group][connectionName];
        connectionManager.updateConnection(connection.getId(), connection)
          .done(function() {
            connectionManager.persistConnections();
          });
      }

      $grid.data("kendoTGrid").updateModel(connectionName, entry);
    });
    
    // Remove orphans
    
    for (var i = 0; i < unavailableGridDS.total(); i++) {
      var item = unavailableGridDS.at(i);
      if (unavailable[item.connection] == null) {
        that.unavailableGrid.data("kendoTGrid").removeModel(item.connection);
      }
    }
    
    for (var i = 0; i < liveGridDS.total(); i++) {
      var item = liveGridDS.at(i);
      if (available[item.connection] == null) {
        that.liveConnectionsGrid.data("kendoTGrid").removeModel(item.connection);
      }
    }

    this._testForEmpty(that.liveConnectionsGrid);
    this._testForEmpty(that.unavailableGrid);
  },
   
  _testForEmpty: function($grid) {
    var isEmpty = ($grid.data("kendoTGrid").dataSource.total() == 0),
      $span = $grid.siblings("span");
    
    if (isEmpty && $grid.is(":visible")) {
      $grid.hide();
      $span.show();
    } else if (!isEmpty && $span.is(":visible")) {
      $span.hide();
      $grid.show();
    }
  },
  
  refresh: function() {
    var that = this;
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI("api/agents/info"),
      success: $.proxy(that.handleResponse, that),
      dataType: "json"
    }).error(function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to load agents";
      handleError(msg, jqXHR, textStatus, errorThrown);
    }).always(function() {
      that.fireEvent("tmc.responseComplete");
    });
  }
});
