function NavigatorCategoryPage(groupId, category) {
  NavigatorPage.call(this, $("#navigator-category .navigator-category").clone());

  var that = this;
  this.groupId = groupId;
  this.category = category;
  //this.$content = $("#navigator-category .navigator-category").clone();
  this.$overviewContent = this.$content.find("#overviewContent");
  this.$tabStrip = this.$content.find("#tabstrip").kendoTabStrip({
    animation: {
      open: {
        effects: false
      }
    }
  });
  this.gridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "connection",
        fields: {
          connection:   {type: "string", editable: false},
          elementCount: {type: "number", editable: false},
          hitRatio:     {type: "number", editable: false},
          onHeapUsage:  {type: "number", editable: false},
          offHeapUsage: {type: "number", editable: false}
        }
      }
    },
    sort: {field: "connection", dir: "asc"},
    pageSize: 5
  });
  this.$grid = this.$overviewContent.find("#grid").kendoTGrid({
    dataSource: this.gridDS,
    columns: [
      {
        title: "Connection",
        field: "connection"
      },
      {
        title: "Elements",
        field: "elementCount",
        template: '#= formatIntRightJustified(elementCount) #'
      },
      {
        title: "Hit Ratio",
        field: "hitRatio",
        template: '#= formatPercentageRightJustified(hitRatio) #'
      },
      {
        title: "OnHeap Usage (MB)",
        field: "onHeapUsage",
        template: '#= formatFloatRightJustified(onHeapUsage) #'
      },
      {
        title: "OffHeap Usage (MB)",
        field: "offHeapUsage",
        template: '#= formatFloatRightJustified(offHeapUsage) #'
      }
    ],
    sortable: true,
    pageable: false,
    selectable: "row",
    scrollable: true,
    resizable: true,
    reorderable: true
  });
  this.connections = {};
  
  resizeHandler(this.$content, function(e) {
    assignRemainingHeight(that.$tabStrip);
    
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").filter(":visible").height(pageHeight);    

    that.$grid.data("kendoTGrid")._setContentHeight();
  });
}

NavigatorCategoryPage.prototype = $.extend({}, NavigatorPage.prototype, {
  show: function() {
    $contentArea.append(this.$content);
    this.$content.show();
  },  
 
  hide: function() {
    this.$content = $contentArea.find(".navigator-category").detach();
  },

  emptyConnectionData: function() {
    var result = {
      size: 0,
      hitCount: 0,
      missCount: 0,
      localHeapSize: 0,
      offHeapSize: 0
    };
    return result;
  },
   
  handleCacheManagersResponse: function(data) {
    var that = this,
      connectionMap = {},
      detailRequests = [];
     
    $.each(data, function(index, value) {
      var agentComps = value.agentId.split("_");
        groupId = agentComps[0],
        connectionName = agentComps[1];
         
      if (that.groupId == groupId) {
        that.connections[connectionName] = connectionMap[connectionName] = that.emptyConnectionData();
      }
    });
     
    $.each(that.connections, function(connectionName, connectionData) {
      if (connectionMap[connectionName] == null) {
        delete that.connections[connectionName];
        that.$grid.data("kendoTGrid").removeModel(connectionName);
      } else {
        var agentId = that.groupId + "_" + connectionName;
        var jqxhr = $.ajax({
          type: "GET",
          url: encodeURI("api/agents;ids=" + agentId + "/cacheManagers/caches"),
          success: function(data) {
            that.handleCachesResponse(connectionName, data);
          },
          dataType: "json"
        });
        detailRequests.push(jqxhr);
      }
    });
    
    $.when.apply($, detailRequests).always(function() {
      that.fireEvent("tmc.responseComplete");
    });
  },
   
  handleCachesResponse: function(connectionName, data) {
    var that = this,
      connectionData = that.connections[connectionName];
    
    $.each(data, function(index, value) {
      var cacheAttrs = value.attributes;
      
      connectionData.size += cacheAttrs.Size;
      connectionData.hitCount += cacheAttrs.CacheHitCount;
      connectionData.missCount += cacheAttrs.CacheMissCount;
      connectionData.localHeapSize += cacheAttrs.LocalHeapSizeInBytes;
      connectionData.offHeapSize += cacheAttrs.LocalOffHeapSizeInBytes;
    });
    
    that.$grid.data("kendoTGrid").updateModel(connectionName, {
      connection: connectionName,
      elementCount: connectionData.size,
      hitRatio: calculateHitRatio(connectionData.hitCount, connectionData.missCount),
      onHeapUsage: toMegabytes(connectionData.localHeapSize),
      offHeapUsage: toMegabytes(connectionData.offHeapSize)
    });
  },

  clearConnectionData: function() {
    var that = this;
    $.each(that.connections, function(connectionName) {
      that.connections[connectionName] = null;
    });
  },
  
  refresh: function() {
    this.clearConnectionData();
    
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI("api/agents/cacheManagers"),
      success: this.handleCacheManagersResponse,
      context: this,
      dataType: "json"
    }).error(function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to load cacheManagers";
      handleError(msg);
    });
  }
});

