function ConnectionManager() {
  this.$window = $("#manageConnectionsWindow");
  this.$connectionPanelTmpl = $("#connectionPanel");
  this.$connectionPanelDisplayTmpl = $("#connectionPanelDisplay");
  this.$deleteConnectionPanelTmpl = $("#deleteConnectionPanel");
  this.$addConnectionGroupPanelTmpl = $("#addConnectionGroupPanel");
  this.$deleteConnectionGroupPanelTmpl = $("#deleteConnectionGroupPanel");
  this.$connectionGroupPanelDisplayTmpl = $("#connectionGroupPanelDisplay");
  this.$editConnectionGroupPanelTmpl = $("#editConnectionGroupPanel");
  this.$confirmChangesWindow = $("#confirmChangesWindow");
  
  this.kWindow = this.$window.kendoWindow({
    title: "Manage Connections",
    actions: ["Help",  "Close"],
    width: "71em",
    height: "auto",
    visible: false,
    resizable: false,
    modal: true
  }).data("kendoWindow");

  setupHelpLink(this.kWindow.wrapper.find(".k-help"), 'tmc-help.html#manage-connections');

  this.gridConfig = function() {
    return {
      schema: {
        model: {
          id: "name",
          fields: {
            name: {type: "string", editable: false}
          }
        }
      },
      sort: {field: "name", dir: "asc"}
    };
  };
  
  this.kConnectionGroupGrid = this.$window.find("#connection-group-grid").kendoTGrid({
    dataSource: this.connectionGroupDS = new kendo.data.DataSource(this.gridConfig()),
    columns: [ {title: "Name", field: "name"} ],
    sortable: true,
    selectable: "row",
    scrollable: true,
    pageable: false,
    change: $.proxy(this.handleConnectionGroupChange, this)
  }).data("kendoTGrid");

  this.kConnectionGrid = this.$window.find("#connection-grid").kendoTGrid({
    dataSource: this.connectionGridDS = new kendo.data.DataSource(this.gridConfig()),
    columns: [ {title: "Name", field: "name"} ],
    selectable: "row",
    sortable: true,
    scrollable: true,
    pageable: false,
    change: $.proxy(this.connectionGridSelectionHandler, this)
  }).data("kendoTGrid");

  this.$window.find("#addConnectionGroupButton").click($.proxy(this.addConnectionGroup, this));
  this.$deleteConnectionGroupButton = this.$window.find("#deleteConnectionGroupButton")
    .click($.proxy(this.deleteConnectionGroup, this));
  
  this.$showConnectionGroupButton = this.$window.find("#showConnectionGroupButton")
    .click($.proxy(this.showConnectionGroup, this));
  
  this.$editConnectionGroupButton = this.$window.find("#editConnectionGroupButton")
  .click($.proxy(this.editConnectionGroup, this));

  this.$addConnectionButton = this.$window.find("#addConnectionButton")
    .click($.proxy(this.addNewConnection, this));
  this.$deleteConnectionButton = this.$window.find("#deleteConnectionButton")
    .click($.proxy(this.deleteSelectedConnection, this));

  this.$window.find("#closeManageConnectionsWindow").click($.proxy(this.testCloseWindow, this));
  
  this.$RHS = this.$window.find("#RHS");
  this.$instructions = this.$RHS.find("#instructions").detach();
}

ConnectionManager.prototype = {
  handleConnectionGroupChange: function(e) {
    var that = this,
      connections = window.connections,
      kGrid = this.kConnectionGrid;
    
    that.clearEditArea();

    kGrid.clear();

    if (Object.keys(connections).length > 0) {
      var selection = that.kConnectionGroupGrid.getSelection();
      if (selection) {
        var selectedGroup = selection.name;
        var groupConnections = connections[selectedGroup];
        if (groupConnections) {
          $.each(groupConnections, function(name, agentConfig) {
            kGrid.updateModel(name, agentConfig);
          });
        }
      }
    }
    if (selection) {
      that.showSelectedConnectionGroup();
      that.updateConnectionControls();
    }
  },
  
  setup: function() {
    var that = this,
      connections = window.connections,
      kGroupGrid = this.kConnectionGroupGrid,
      kGrid = this.kConnectionGrid;

    kGroupGrid.clear();
    kGrid.clear();

    if (Object.keys(connections).length > 0) {
      $.each(connections, function(group, members) {
        kGroupGrid.updateModel(group, {name: group});
      });
    }
    if (kGroupGrid.dataSource.total() > 0) {
      kGroupGrid.selectRow(0);
    }
    
    this.updateConnectionGroupControls();
    this.updateConnectionControls();
  },
  
  show: function() {
    this.$window.show();
    this.$window.find(".k-grid-content").css("height", "10em");
    this.kWindow.center();
    this.kWindow.open();
    this.setup();
    this.clearEditArea();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  checkForChanges: function(e) {
    var $applyButton = this.$RHS.find("#apply");
    var $okButton = this.$RHS.find("#ok");
    
    if ($applyButton.length > 0 && $applyButton.css("display") != "none" ||
        $okButton.length > 0 && $okButton.css("display") != "none") {
      var $cancelButton = this.$RHS.find("#cancel");
      var $window = this.$window;
      var $confirmWindow = this.$confirmChangesWindow;
      var kConfirmWindow = t = this.$confirmChangesWindow.kendoWindow({
        title: "Save Changes",
        width: "28em",
        visible: false,
        resizable: false,
        modal: true
      }).data("kendoWindow");
      
      $confirmWindow.find("#discard").click(function() {
        kConfirmWindow.close();
        kConfirmWindow.destroy();
        $cancelButton.click();
        $(e.target).click();
      });
      $confirmWindow.find("#back").click(function() {
        kConfirmWindow.close();
        kConfirmWindow.destroy();
      });
      
      $confirmWindow.show();
      kConfirmWindow.center();
      kConfirmWindow.open();
      kConfirmWindow.toFront();
      
      e.preventDefault();
      e.stopPropagation();

      return false;
    }
  },
  
  testCloseWindow: function() {
    this.hide();
  },

  cloneConnectionGroupDS: function() {
    var ds = new kendo.data.DataSource(this.gridConfig()),
      connectionGroupDS = this.connectionGroupDS;
    
    for(var i = 0; i < connectionGroupDS.total(); i++) {
      ds.add(connectionGroupDS.at(i));
    }
    
    return ds;
  },
  
  addNewConnection: function() {
    this.$RHS.empty().append(this.$connectionPanelTmpl.clone());
    var $panel = this.$RHS.find("#connectionPanel");
    var $controls = $panel.find("#foo-controls");
    var $revertButton = $controls.find("#revert");
    $revertButton.hide();
    $panel.checkModified = function() {
      if (this.isConnectionPanelModified($panel)) {
        $revertButton.show();
      } else {
        $revertButton.hide();
      }
    };
    $panel.find("input").keyup($.proxy($panel.checkModified, this));
    $panel.find("#groupId").kendoComboBox({
      dataTextField: "name",
      dataValueField: "name",
      dataSource: this.cloneConnectionGroupDS()
    }).change($.proxy($panel.checkModified, this));
    $controls.find("#apply")
      .click($.proxy(this.acceptNewConnection, this))
      .removeClass("hideable");
    $revertButton.click($.proxy(this.revertNewConnection, this));
    $controls.find("#cancel").click($.proxy(this.cancelNewConnection, this));
    $panel.find("legend").text("New Connection Details");
    $panel.show();

    var groupId = this.kConnectionGroupGrid.getSelection().name;
    this.updateConnectionDetails(new AgentConfig({
      name: "MyConnection",
      groupId: groupId,
      agentLocation: "http://localhost:9888",
    }));

    this.hijackClicks();    
  },
  
  acceptNewConnection: function() {
    var $panel = this.$RHS.find("#connectionPanel");
    var name = $panel.find("#name").val();
    var groupId = $panel.find("#groupId").data("kendoComboBox").text();
    var agentLocation = $panel.find("#agentLocation").val();
    var connectionTimeout = parseInt($panel.find("#connectionTimeoutMillis").val());
    var readTimeout = parseInt($panel.find("#readTimeoutMillis").val());
    var agentConfig = registerAgent({name: name,
      groupId: groupId,
      agentLocation: agentLocation,
      connectionTimeoutMillis: connectionTimeout,
      readTimeoutMillis: readTimeout,
      secured:false});
    var success = function(data, textStatus, jqXHR) {
      this.kConnectionGrid.updateModel(agentConfig.name, agentConfig);
      this.clearEditArea();
      this.persistConnections();
      this.updateConnectionControls();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to add connection";
      switch (jqXHR.status) {
        case 400:
          msg += "; " + jqXHR.responseText;
          alert(msg);
          break;
        case 409:
          msg += "; " + "Connection with this name already exits.";
          alert(msg);
          break;
        case 410:
          var confirmSave = confirm('Are you sure you want to save this unavailable connection?');
          if (confirmSave == true) {
            this.kConnectionGrid.updateModel(agentConfig.name, agentConfig);
            this.clearEditArea();
            this.persistConnections();
            this.updateConnectionControls();
          }
          break;
        default:
          msg += "; " + errorThrown;
          alert(msg);
      }
    };
    
    this.addConnection(agentConfig, $.proxy(success, this), $.proxy(error, this));
  },
  
  revertNewConnection: function() {
    this.revertConnectionChanges();
  },
  
  cancelNewConnection: function() {
    this.clearEditArea();
  },
  
  getSelectedConnection: function() {
    return this.kConnectionGrid.getSelection();
  },
  
  deleteSelectedConnection: function() {
    var connection = this.getSelectedConnection();
    this.$RHS.empty().append(this.$deleteConnectionPanelTmpl.clone());
    var $panel = this.$RHS.find("#deleteConnectionPanel");
    $panel.find("#msg").text("Really delete connection '" + connection.name + "?'");
    $panel.find("#ok").click($.proxy(this.acceptDeleteConnection, this));
    $panel.find("#cancel").click($.proxy(this.cancelDeleteConnection, this));
    $panel.data("connection", connection);
    $panel.show();
    this.hijackClicks();    
  },
  
  editConnection: function(group, connectionName) {
    var agentConfig = window.connections[group][connectionName];
    
    this.show();
    this.kConnectionGroupGrid.selectModel(agentConfig.groupId);
    this.handleConnectionGroupChange();
    this.kConnectionGrid.selectModel(agentConfig.name);
    this.editSelectedConnection();
  },

  acceptDeleteConnection: function() {
    var success = function(data, textStatus, jqXHR) {
      this.kConnectionGrid.removeModel(connection.name);
      delete connections[connection.groupId][connection.name];
      this.clearEditArea();
      this.persistConnections();
      this.updateConnectionControls();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to delete connection";
      handleError(msg, jqXHR, textStatus, errorThrown);
    };
    
    var $panel = this.$RHS.find("#deleteConnectionPanel");
    var connection = $panel.data("connection");
    this.deleteConnection(connection.getId(), $.proxy(success, this), $.proxy(error, this));
  },
  
  cancelDeleteConnection: function() {
    this.clearEditArea();
  },

  connectionGridSelectionHandler: function(e) {
    this.showSelectedConnection();
    this.updateConnectionControls();
  },

  // display read only connection group details
  showSelectedConnectionGroup: function() {
    this.$RHS.empty().append(this.$connectionGroupPanelDisplayTmpl.clone());
    var $panel = this.$RHS.find("#connectionGroupPanelDisplay");
    var $controls = $panel.find("#foo-controls");
     
    $controls.find("#edit").click($.proxy(this.editConnectionGroup, this));   
    $controls.find("#delete").click($.proxy(this.deleteConnectionGroup, this));
    $controls.find("#cancel").click($.proxy(this.cancelConnectionGroupChange, this));
    $panel.show();
    
    var agentConfig = this.kConnectionGroupGrid.getSelection();
    
    $panel.find("#group").html(agentConfig.name);
      this.hijackClicks();    
  },  

  // display read only connection details
  showSelectedConnection: function() {
    this.$RHS.empty().append(this.$connectionPanelDisplayTmpl.clone());
    var $panel = this.$RHS.find("#connectionPanelDisplay");
    var $controls = $panel.find("#foo-controls");
     
    $controls.find("#edit").click($.proxy(this.editSelectedConnection, this));   
    $controls.find("#delete").click($.proxy(this.deleteSelectedConnection, this));
    $controls.find("#cancel").click($.proxy(this.cancelConnectionChanges, this));
    $panel.show();
    
    var agentConfig = this.kConnectionGrid.getSelection();
    
    $panel.find("#groupId").html(agentConfig.groupId);
    $panel.find("#name").html(agentConfig.name);
    var $security = $panel.find("#security");
    $security.removeClass("securityOff").removeClass("securityOn").html("Unknown");
    switch (agentConfig.secured) {
      case true:
        $security.addClass("securityOn").html("Yes");
        break;
      case false:
        $security.addClass("securityOff").html("No");
        break;
    }
    $panel.find("#agentLocation").html(agentConfig.agentLocation);
    $panel.find("#connectionTimeoutMillis").html(agentConfig.connectionTimeoutMillis);
    $panel.find("#readTimeoutMillis").html(agentConfig.readTimeoutMillis);
    this.hijackClicks();    
  },
  
  editSelectedConnection: function() {
    this.$RHS.empty().append(this.$connectionPanelTmpl.clone());
    var $panel = this.$RHS.find("#connectionPanel");
    var $controls = $panel.find("#foo-controls");
    var $hideables = $controls.find(".hideable");
    $hideables.hide();
    $panel.checkModified = function() {
      if (this.isConnectionPanelModified($panel)) {
        $hideables.show();
      } else {
        $hideables.hide();
      }
    };
    $panel.find("input").keyup($.proxy($panel.checkModified, this));
    
    $panel.find("#groupId").kendoComboBox({
      dataTextField: "name",
      dataValueField: "name",
      dataSource: this.connectionGroupDS
    }).change($.proxy($panel.checkModified, this));
    
    $controls.find("#apply").click($.proxy(this.acceptConnectionChanges, this));
    $controls.find("#revert").click($.proxy(this.revertConnectionChanges, this));
    $controls.find("#cancel").click($.proxy(this.cancelConnectionChanges, this));
    $panel.show();
    
    var agentConfig = this.kConnectionGrid.getSelection();
    this.updateConnectionDetails(agentConfig);
    
    this.hijackClicks();    
  },
  
  acceptConnectionChanges: function() {
    var $panel = this.$RHS.find("#connectionPanel");
    var origValue = $panel.data("originalValue");
    var groupId = $panel.find("#groupId").data("kendoComboBox").text();
    var name = $panel.find("#name").val();
    var agentLocation = $panel.find("#agentLocation").val();
    var connectionTimeout = parseInt($panel.find("#connectionTimeoutMillis").val());
    var readTimeout = parseInt($panel.find("#readTimeoutMillis").val());

    var newValue = new AgentConfig({
      name: name,
      groupId: groupId,
      agentLocation: agentLocation,
      connectionTimeoutMillis: connectionTimeout,
      readTimeoutMillis: readTimeout
    });

    var kGrid = this.kConnectionGrid;
    var connectionId = kGrid.getSelection().getId();
    
    var success = function(data, textStatus, jqXHR) {
      var that = this;      
    
      delete connections[origValue.groupId][origValue.name];
      connections[groupId][name] = newValue;
  
      if (groupId != origValue.groupId) {
        kGrid.removeModel(origValue.name);
      } else {
        kGrid.updateModel(origValue.name, newValue);
      }
      
      that.clearEditArea();
      that.persistConnections();
    };
    
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to update connection";

      switch (jqXHR.status) {
        case 12029:
          msg += "; a connection to the server could not be created";
          alert(msg); 
          break; 
        case 401:
          msg += "; missing id or agentLocation";
          alert(msg); 
         break;
        case 409:
          msg += "; connection with id already exists";
          alert(msg); 
          break;         
        case 410: {
          var that = this, 
            confirmSave = confirm(' Are you sure you want to save this unavailable connection?');
          
          if (confirmSave == true) {
            delete connections[origValue.groupId][origValue.name];
            connections[groupId][name] = newValue;
            if (groupId != origValue.groupId) {
              kGrid.removeModel(origValue.name);
            } else {
              kGrid.updateModel(origValue.name, newValue);
            }
            that.clearEditArea();
            that.persistConnections();
          } else {
            that.deleteConnection(newValue.getId());
          }
          break;
        }
        default:
          msg += "; " + errorThrown;
          alert(msg);
      }
    };
    this.updateConnection(connectionId, newValue, $.proxy(success, this), $.proxy(error, this));
  },
  
  revertConnectionChanges: function() {
    var $panel = this.$RHS.find("#connectionPanel");
    this.updateConnectionDetails($panel.data("originalValue"));
    $panel.find(".hideable").hide();
  },
  
  cancelConnectionChanges: function() {
    this.clearEditArea();
  },

  updateConnectionDetails: function(agentConfig) {
    var $panel = this.$RHS.find("#connectionPanel");
    $panel.find("#name").val(agentConfig.name);
    $panel.find("#agentLocation").val(agentConfig.agentLocation);
    $panel.find("#connectionTimeoutMillis").val(agentConfig.connectionTimeoutMillis);
    $panel.find("#readTimeoutMillis").val(agentConfig.readTimeoutMillis);
    $panel.find("#groupId").data("kendoComboBox").select(function(dataItem) {
      return dataItem.name === agentConfig.groupId;
    });
    $panel.data("originalValue", agentConfig.clone());
  },
 
  isConnectionPanelModified: function($panel) {
    var origVal = $panel.data("originalValue");
    return $panel.find("#name").val() != origVal.name
      || $panel.find("#groupId").data("kendoComboBox").text() != origVal.groupId
      || $panel.find("#agentLocation").val() != origVal.agentLocation
      || $panel.find("#connectionTimeoutMillis").val() != origVal.connectionTimeoutMillis
      || $panel.find("#readTimeoutMillis").val() != origVal.readTimeoutMillis;
  },
  
  addConnectionGroup: function() {
    this.$RHS.empty().append(this.$addConnectionGroupPanelTmpl.clone());
    var $panel = this.$RHS.find("#addConnectionGroupPanel");
    var $controls = $panel.find("#foo-controls");
    var $revertButton = $controls.find("#revert");
    $revertButton.hide();
    var $group = $panel.find("#group");
    $panel.isModified = function() {
      return $group.val() != $panel.data("originalValue");
    };
    $panel.checkModified = function() {
      if ($panel.isModified()) {
        $revertButton.show();
      } else {
        $revertButton.hide();
      }
    };
    $group.keyup($.proxy($panel.checkModified, this));

    $panel.find("#apply").click($.proxy(this.acceptNewConnectionGroup, this));
    $revertButton.click($.proxy(this.revertNewConnectionGroup, this));
    $panel.find("#cancel").click($.proxy(this.cancelNewConnectionGroup, this));
    $panel.show();

    var defaultGroupName = this.getUniqueDefaultGroupName();
    $group.val(defaultGroupName);
    $panel.data("originalValue", String(defaultGroupName));

    this.hijackClicks();    
  },

  getUniqueDefaultGroupName: function() {
    /* TODO: determine unique suffix */
    return "MyConnectionGroup";
  },
  
  acceptNewConnectionGroup: function() {
    var success = function(data, textStatus, jqXHR) {
      var entry = {name: groupId};
      this.kConnectionGroupGrid.updateModel(groupId, entry);
      this.kConnectionGroupGrid.selectModel(groupId);
      this.handleConnectionGroupChange();
      connections[groupId] = {};
      this.persistConnections();
      this.updateConnectionGroupControls();
      this.updateConnectionControls();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to add connection group";
      handleError(msg, jqXHR, textStatus, errorThrown);
    };
    
    var $panel = this.$RHS.find("#addConnectionGroupPanel");
    var groupId = $panel.find("#group").val();
    this.addGroup(groupId, $.proxy(success, this), $.proxy(error, this));
  },

  revertNewConnectionGroup: function() {
    var $panel = this.$RHS.find("#addConnectionGroupPanel");
    $panel.find("#group").val($panel.data("originalValue"));
    $panel.find("#revert").hide();
  },
      
  cancelNewConnectionGroup: function() {
    this.clearEditArea();
  },

  deleteConnectionGroup: function() {
    this.$RHS.empty().append(this.$deleteConnectionGroupPanelTmpl.clone());
    var $panel = this.$RHS.find("#deleteConnectionGroupPanel");
    var model = this.kConnectionGroupGrid.getSelection();
    $panel.find("#msg").text("Really delete group '" + model.name + "?'");
    $panel.find("#ok").click($.proxy(this.acceptDeleteConnectionGroup, this));
    $panel.find("#cancel").click($.proxy(this.cancelDeleteConnectionGroup, this));
    $panel.show();
    this.hijackClicks();    
  },

  acceptDeleteConnectionGroup: function() {
    var success = function(data, textStatus, jqXHR) {
      delete connections[groupId];

      var that = this,
        kGrid = that.kConnectionGroupGrid,
        selIndex = kGrid.select().index();
      
      kGrid.removeModel(groupId);
      if (selIndex != -1) {
        kGrid.selectRow(selIndex);
        that.handleConnectionGroupChange();
      } else {
        that.clearEditArea();
      }
      
      that.persistConnections();
      that.updateConnectionGroupControls();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to delete connection group";
      handleError(msg, jqXHR, textStatus, errorThrown);
    };
    
    var groupId = this.kConnectionGroupGrid.getSelection().name;
    this.deleteGroup(groupId, $.proxy(success, this), $.proxy(error, this));
  },
  
  cancelDeleteConnectionGroup: function() {
    this.clearEditArea();
  },

  editConnectionGroup: function() {
    this.$RHS.empty().append(this.$editConnectionGroupPanelTmpl.clone());
    var $panel = this.$RHS.find("#editConnectionGroupPanel");
    var $controls = $panel.find("#foo-controls");
    var $hideables = $controls.find(".hideable");
    $hideables.hide();
    var $group = $panel.find("#group");
    $panel.isModified = function() {
      var groupId = $panel.data("originalValue");
      return groupId && (groupId != $group.val());
    };
    $panel.checkModified = function() {
      if ($panel.isModified()) {
        $hideables.show();
      } else {
        $hideables.hide();
      }
    };
    $panel.find("#group").keyup($panel.checkModified);
    
    $panel.find("#apply").click($.proxy(this.acceptConnectionGroupChange, this));
    $panel.find("#revert").click($.proxy(this.revertConnectionGroupChange, this));
    $panel.find("#cancel").click($.proxy(this.cancelConnectionGroupChange, this));
    $panel.show();

    var groupName = this.kConnectionGroupGrid.getSelection().name;
    $panel.find("#group").val(groupName);
    $panel.data("originalValue", String(groupName));

    this.hijackClicks();
  },
  
  acceptConnectionGroupChange: function() {
    var $panel = this.$RHS.find("#editConnectionGroupPanel");
    var oldName = this.kConnectionGroupGrid.getSelection().name;
    var newName = $panel.find("#group").val();
    var success = function(data, textStatus, jqXHR) {
      var ds = this.connectionGroupDS;
      var entry = ds.findRow({keyField: "name", keyValue: oldName});
      if (entry) {
        entry.name = newName;
        entry.id = newName;
        this.kConnectionGroupGrid.selectItem(entry);
      }
      connections[newName] = connections[oldName];
      delete connections[oldName];
      $.each(connections[newName], function(name, agentConfig) {
        agentConfig.groupId = newName;
      });
      this.kConnectionGroupGrid.updateModel(groupId,entry);
      this.kConnectionGroupGrid.selectItem(entry);
      this.persistConnections();
      this.clearEditArea();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to rename connection group";
      handleError(msg, jqXHR, textStatus, errorThrown);
    };
    var groupId = $panel.find("#group").val();
    this.renameGroup(oldName, newName, $.proxy(success, this), $.proxy(error, this));
  },
  
  revertConnectionGroupChange: function() {
    var $panel = this.$RHS.find("#editConnectionGroupPanel");
    $panel.find("#group").val($panel.data("originalValue"));
    $panel.find(".hideable").hide();
  },
  
  cancelConnectionGroupChange: function() {
    this.clearEditArea();
  },

  updateConnectionGroupControls: function() {
    if (this.connectionGroupDS.data().length > 0) {
      this.$deleteConnectionGroupButton.show();
      this.$editConnectionGroupButton.show();
    } else {
      this.$deleteConnectionGroupButton.hide();
      this.$editConnectionGroupButton.hide();
    }
  },
  
  updateConnectionControls: function() {
    if (this.connectionGroupDS.data().length > 0) {
      this.$addConnectionButton.show();
    } else {
      this.$addConnectionButton.hide();
    }
    if (this.connectionGridDS.data().length > 0 &&
        this.kConnectionGrid.select().index() >= 0) {
      this.$deleteConnectionButton.show();
    } else {
      this.$deleteConnectionButton.hide();
    }
  },

  clearEditArea: function() {
    var $cancelButton = this.$RHS.find("#cancel");
    if ($cancelButton.length > 0) {
      this.releaseClicks();
    }
    
    this.$RHS.empty()
    this.$RHS.append(this.$instructions);
  },
  
  hijackClicks: function() {
    var $elems = this.$window.find("#LHS")
      .find("button,tr,select")
      .add(this.$window.find("#controls button"));
    var checker = function(e) {
      this.checkForChanges(e);
    };
    $elems.bind("mousedown.hijacked", $.proxy(checker, this));
  },
  
  releaseClicks: function() {
    this.$window.find("#LHS")
      .find("button,tr,select")
      .add(this.$window.find("#controls button"))
      .unbind("mousedown.hijacked");
  },
  
  /* AJAX calls */
  
  deleteConnection: function(id, success, error) {
    return $.ajax({
      type: "DELETE",
      url: encodeURI("api/config/agents/" + id),
      success: success,
      error: error
    });
  },
  
  addGroup: function(groupId, success, error) {
    return $.ajax({
      type: "PUT",
      url: encodeURI("api/config/groups/" + groupId),
      processData: false,
      dataType: "text",
      success: success,
      error: error
    });
  },

  deleteGroup: function(groupId, success, error) {
    return $.ajax({
      type: "DELETE",
      url: encodeURI("api/config/groups/" + groupId),
      processData: false,
      dataType: "text",
      success: success,
      error: error
    });
  },
 
  renameGroup: function(oldGroupId, newGroupId, success, error) {
    return $.ajax({
      type: "PUT",
      url: encodeURI("api/config/groups/" + oldGroupId + "/" + newGroupId),
      processData: false,
      dataType: "text",
      contentType: "application/json",
      success: success,
      error: success//error
    });
  },
  
  addConnection: function(agentConfig, success, error) {
    return $.ajax({
      type: "POST",
      url: encodeURI("api/config/agents"),
      processData: false,
      data: JSON.stringify(agentConfig, null, 2),
      contentType: "application/json",
      success: success,
      error: error
    });
  },
    
  updateConnection: function(id, agentConfig, success, error) {
    var jqxhr =  $.ajax({
      type: "PUT",
      url: encodeURI("api/config/agents/" + id),
      processData: false,
      data: JSON.stringify(agentConfig, null, 2),
      contentType: "application/json"
    });
    if (success != null) {
      jqxhr.done(success);
    }
    if (error != null) {
      jqxhr.fail(error);      
    }
    return jqxhr;
  },
    
  persistConnections: function() {
    var jqxhr = $.ajax({
      type: "POST",
      url: encodeURI("api/config")
    });
    jqxhr.error(function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to persist connections";
      handleError(msg, jqXHR, textStatus, errorThrown);
    });
    return jqxhr;
  }
  
};