/*
 * TODO: factor a BaseDialog class.
 */
function CacheManagerConfigEditor(managementPage) {
  var that = this;
  
  this.managementPage = managementPage;
  this.$window = $("#editCacheManagerConfigWindow");
  this.kWindow = this.$window.kendoWindow({
    title: "CacheManager Configuration",
    actions: ["Close"],
    width: "36em",
    height: "auto",
    visible: false,
    resizable: false,
    modal: true
  }).data("kendoWindow");
  
  var numberInputConfig = {format: "n0"};
  
  this.$maxBytesLocalDisk = this.$window.find("#MaxBytesLocalDiskAsString");
  this.$maxBytesLocalHeap = this.$window.find("#MaxBytesLocalHeapAsString");

  this.$window.on("click", "button[id='cancelButton']", function() {
    that.kWindow.close();
  });
  this.$window.on("click", "button[id='okButton']", function() {
    that.persistSettings();
    that.kWindow.close();
  });
  
  var keydownHandler = function(e) {
    switch (e.which) {
      case kendo.keys.ESC: {
        that.kWindow.close();
        break;
      }
      case kendo.keys.ENTER: {
        that.$window.find("button[id='okButton']").click();
        break;
      }
    }
  };
  this.kWindow.bind("open", function() {
    $(document).bind("keydown", keydownHandler);
  });
  this.kWindow.bind("close", function() {
    $(document).unbind("keydown", keydownHandler);
  });
}

CacheManagerConfigEditor.prototype = {
  show: function(cacheManagerAttrs) {
    this.setup(cacheManagerAttrs);
    if (!this.hasEditableAttributes(cacheManagerAttrs)) {
      alert("CacheManager has no editable attributes.");
      return;
    }
    this.$window.show();
    this.kWindow.center();
    this.kWindow.open();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  hasEditableAttributes: function(cacheManagerAttrs) {
    if (cacheManagerAttrs != null) {
      return cacheManagerAttrs.MaxBytesLocalHeap != 0 || cacheManagerAttrs.MaxBytesLocalDisk != 0;
    }
    return false;
  },
  
  setup: function(cacheManagerAttrs) {
    this.cacheManagerAttrs = cacheManagerAttrs;
    
    this.kWindow.title("CacheManager Configuration: " + cacheManagerAttrs.Name);
    
    if (cacheManagerAttrs.MaxBytesLocalHeap != 0) {
      this.$maxBytesLocalHeap.val(cacheManagerAttrs.MaxBytesLocalHeapAsString);
      this.$maxBytesLocalHeap.closest("tr").show();      
    } else {
      this.$maxBytesLocalHeap.closest("tr").hide();      
    }

    if (cacheManagerAttrs.MaxBytesLocalDisk != 0) {
      this.$maxBytesLocalDisk.val(cacheManagerAttrs.MaxBytesLocalDiskAsString);
      this.$maxBytesLocalDisk.closest("tr").show();
    } else {
      this.$maxBytesLocalDisk.closest("tr").hide();
    }
  },
  
  gatherAttributes: function() {
    var result = {};
    
    if (this.$maxBytesLocalHeap.closest("tr").is(":visible")) {
      result.MaxBytesLocalHeapAsString = this.$maxBytesLocalHeap.val();
    }

    if (this.$maxBytesLocalDisk.closest("tr").is(":visible")) {
      result.MaxBytesLocalDiskAsString = this.$maxBytesLocalDisk.val();
    }
    
    return result;
  },
  
  persistSettings: function() {
    var cacheManagerAttrs = this.gatherAttributes(),
      cacheManagerName = this.cacheManagerAttrs.Name;
    
    this.managementPage.updateCacheManager(cacheManagerName, cacheManagerAttrs)
      .fail(function(jqXHR, textStatus, errorThrown) {
        alert("Failed to update CacheManager: " + textStatus);
      });
  }
};
