/*
 * TODO: factor a BaseDialog class.
 */
function CacheConfigEditor(managementPage) {
  var that = this;
  
  this.managementPage = managementPage;
  this.$window = $("#editCacheConfigWindow");
  this.kWindow = this.$window.kendoWindow({
    title: "Cache Configuration",
    actions: ["Close"],
    width: "36em",
    height: "auto",
    visible: false,
    resizable: false,
    modal: true
  }).data("kendoWindow");
  
  var numberInputConfig = {format: "n0"};
  this.$maxElementsOnDisk = this.$window.find("#MaxElementsOnDisk").kendoNumericTextBox(numberInputConfig);
  this.kMaxElementsOnDisk = this.$maxElementsOnDisk.data("kendoNumericTextBox");
  
  this.$maxBytesLocalDisk = this.$window.find("#MaxBytesLocalDiskAsString");
  this.$maxBytesLocalHeap = this.$window.find("#MaxBytesLocalHeapAsString");
  
  this.$maxEntriesLocalHeap = this.$window.find("#MaxEntriesLocalHeap").kendoNumericTextBox(numberInputConfig);
  this.kMaxEntriesLocalHeap = this.$maxEntriesLocalHeap.data("kendoNumericTextBox");
  
  this.kTimeToIdleSeconds = this.$window.find("#TimeToIdleSeconds").kendoNumericTextBox(numberInputConfig).data("kendoNumericTextBox");
  this.kTimeToLiveSeconds = this.$window.find("#TimeToLiveSeconds").kendoNumericTextBox(numberInputConfig).data("kendoNumericTextBox");

  this.$window.on("click", "button[id='cancelButton']", function() {
    that.kWindow.close();
  });
  this.$window.on("click", "button[id='okButton']", function() {
    that.persistSettings();
    that.kWindow.close();
  });
  
  var keydownHandler = function(e) {
    switch (e.which) {
      case kendo.keys.ESC: {
        that.kWindow.close();
        break;
      }
      case kendo.keys.ENTER: {
        that.$window.find("button[id='okButton']").click();
        break;
      }
    }
  };
  this.kWindow.bind("open", function() {
    $(document).bind("keydown", keydownHandler);
  });
  this.kWindow.bind("close", function() {
    $(document).unbind("keydown", keydownHandler);
  });
}

CacheConfigEditor.prototype = {
  show: function(cacheManagerAttrs, cacheAttrs) {
    this.setup(cacheManagerAttrs, cacheAttrs);
    this.$window.show();
    this.kWindow.center();
    this.kWindow.open();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  setup: function(cacheManagerAttrs, cacheAttrs) {
    this.cacheManagerAttrs = cacheManagerAttrs;
    this.cacheAttrs = cacheAttrs;
    
    this.kWindow.title("Cache Configuration: " + cacheAttrs.CacheName);
    
    if (cacheAttrs.MaxElementsOnDisk > 0 && cacheManagerAttrs.MaxBytesLocalDisk == 0) {
      this.kMaxElementsOnDisk.value(cacheAttrs.MaxElementsOnDisk);
      this.$maxElementsOnDisk.closest("tr").show();
    } else {
      this.$maxElementsOnDisk.closest("tr").hide();
    }
    if (cacheAttrs.MaxEntriesLocalHeap > 0) {
      this.kMaxEntriesLocalHeap.value(cacheAttrs.MaxEntriesLocalHeap);
      this.$maxEntriesLocalHeap.closest("tr").show();      
      this.$maxBytesLocalDisk.closest("tr").hide();
      this.$maxBytesLocalHeap.closest("tr").hide();      
    }
    if (cacheAttrs.MaxBytesLocalHeap > 0
        || (cacheManagerAttrs.MaxBytesLocalHeap != 0 && cacheAttrs.MaxEntriesLocalHeap == 0)) {
      this.$maxBytesLocalHeap.text(cacheAttrs.MaxBytesLocalHeapAsString);
      this.$maxBytesLocalHeap.closest("tr").show();      
    } else {
      this.$maxBytesLocalHeap.closest("tr").hide();      
    }
    if (cacheAttrs.MaxBytesLocalDisk > 0
        || (cacheManagerAttrs.MaxBytesLocalDisk != 0 && cacheAttrs.MaxElementsOnDisk == 0)) {
      this.$maxBytesLocalDisk.text(cacheAttrs.MaxBytesLocalDiskAsString);
      this.$maxBytesLocalDisk.closest("tr").show();
    } else {
      this.$maxBytesLocalDisk.closest("tr").hide();
    }
    this.kTimeToIdleSeconds.value(cacheAttrs.TimeToIdleSeconds);
    this.kTimeToLiveSeconds.value(cacheAttrs.TimeToLiveSeconds);
  },
  
  gatherAttributes: function() {
    var result = {};
    
    if (this.$maxElementsOnDisk.closest("tr").is(":visible")) {
      result.MaxElementsOnDisk = this.kMaxElementsOnDisk.value();
    }
    if (this.$maxEntriesLocalHeap.closest("tr").is(":visible")) {
      result.MaxEntriesOnDisk = this.kMaxEntriesLocalHeap.value();
    }
    if (this.$maxBytesLocalHeap.closest("tr").is(":visible")) {
      result.MaxBytesLocalHeapAsString = this.$maxBytesLocalHeap.val();
    }
    if (this.$maxBytesLocalDisk.closest("tr").is(":visible")) {
      result.MaxBytesLocalDiskAsString = this.$maxBytesLocalDisk.val();
    }
    result.TimeToIdleSeconds = this.kTimeToIdleSeconds.value();
    result.TimeToLiveSeconds = this.kTimeToLiveSeconds.value();
    
    return result;
  },
  
  persistSettings: function() {
    var cacheAttrs = this.gatherAttributes(),
      cacheManagerName = this.cacheManagerAttrs.Name;
      cacheName = this.cacheAttrs.CacheName;
    
    this.managementPage.updateCache(cacheManagerName, cacheName, cacheAttrs)
      .fail(function(jqXHR, textStatus, errorThrown) {
        alert("Failed to update cache: " + textStatus);
      });
  }
};
