function BaseAgentPage(agentPage, $content) {
  NavigatorPage.call(this, $content);
  
  this.agentPage = agentPage;

  agentPage.bind({
    "ehcache.cachesAdded":         $.proxy(this.handleCachesAdded, this),
    "ehcache.cacheAdded":          $.proxy(this.handleCacheAdded, this),
    "ehcache.cacheRemoved":        $.proxy(this.handleCacheRemoved, this),
    "ehcache.cacheManagerAdded":   $.proxy(this.handleCacheManagerAdded, this),
    "ehcache.cacheManagerRemoved": $.proxy(this.handleCacheManagerRemoved, this),
  });
  
  this.detailBindings = {
    "ehcache.cacheDetails": $.proxy(this.handleCacheDetails, this)
  };
}

BaseAgentPage.prototype = $.extend({}, NavigatorPage.prototype, {
  show: function() {
    this.agentPage.bind(this.detailBindings);
  },
  
  hide: function() {
    this.agentPage.unbind(this.detailBindings);
  },

  /*
   * Should cache details be requested; default: true.
   */
  getCacheDetails: function() {
    return null;
  },
  
  /*
   * If cacheDetails is enabled, details will only be requested for this Cache.
   */
  getCache: function() {
    return null;
  },
  
  getCacheAttributes: function() {
    return null;
  },
  
  /*
   * If cacheDetails is enabled, details will only be requested for this CacheManager.
   */
  getCacheManager: function() {
    return null;
  },
  
  getCacheManagerAttributes: function() {
    return null;
  },
  
  getQueryAttributes: function() {
    var result = {},
      cacheDetails = this.getCacheDetails(),
      cache = this.getCache(),
      cacheAttrs = this.getCacheAttributes(),
      cacheManager = this.getCacheManager(),
      cacheManagerAttrs = this.getCacheManagerAttributes();
    
    if (cacheDetails === false) {
      result.cacheDetails = cacheDetails;
    }
    if (cache) {
      result.cache = cache;
    }
    if (cacheAttrs) {
      result.cacheAttributes = cacheAttrs;
    }
    if (cacheManager) {
      result.cacheManager = cacheManager;
    }
    if (cacheManagerAttrs) {
      result.cacheManagerAttributes = cacheManagerAttrs;
    }
    
    return result;
  },
  
  /* attributes:
   * { cacheAttributes: ["Foo","Bar"],
   *   cache: "Baz",
   *   cacheManagerAttributes: ["Size", "Enabled"],
   *   cacheManager: "Users"
   * }
   * 
   * The absence of an attribute implies a request for all.
   */
  fireQueryAttributesChanged: function() {
    this.fireEvent("ehcache.query.attributes", {queryAttributes: this.getQueryAttributes()}); 
  },
  
  handleCachesAdded: function(e) {},
  
  handleCacheAdded: function(e) {},
 
  handleCacheRemoved: function(e) {},
  
  handleCacheManagerAdded: function(e) {},
  
  handleCacheManagerRemoved: function(e) {},
  
  handleCacheDetails: function(e) {}
});
