function AgentMonitoringPage(agentPage, $content) {
  BaseAgentPage.call(this, agentPage, $content);
  
  var that = this;
  var comboConfig = function() {
    return {
      data: [],
      schema: {
        model: {
          id: "name",
          fields: {name: {type: "string", editable: false}}
        }
      },
      sort: {field: "name", dir: "asc"}
    };
  };
  this.$cacheManagerSelector = $content.find("#cacheManagerSelector").kendoComboBox({
    dataSource: this.cacheManagerDataSource = new kendo.data.DataSource(comboConfig()),
    dataTextField: "name",
    dataValueField: "name",
    change: $.proxy(that.handleCacheManagerSelection, that)
  });
  this.ALL_CACHES = "ALL CACHES";
  this.ALL_CACHES_ENTRY = {name: this.ALL_CACHES};
  this.$cacheSelector = $content.find("#cacheSelector").kendoComboBox({
    dataSource: this.cacheDataSource = new kendo.data.DataSource(comboConfig()),
    dataTextField: "name",
    dataValueField: "name",
    change: $.proxy(that.handleCacheSelection, that)
  });
  this.$charts = $content.find("#charts");
  this.$statistics = $content.find("#statistics");
  this.$charts2 = $content.find("#charts2");
  this.$statistics2 = $content.find("#statistics2");
  $content.find("#statisticsButton").click($.proxy(this.showStatistics, this));
  
  this.TARGET_LABEL_COUNT = 5;
  this.SAMPLE_COUNT_TICKS_THRESHOLD = 30;  
  this.CHART_DEFAULTS = {
    title: {
      font: "14px Arial,Helvetica,sans-serif",
      margin: 0,
      padding: 0
    },
    categoryAxis: {
      field: "time",
      labels: { format: "{0:h:mm:ss}", step: 5 },
      majorGridLines: { visible: false },
      majorTicks: { visible: true }
    },
    valueAxis: { 
      min: 0,
      majorGridLines: { visible: false },
      plotBands: [{ from: 0, to: Number.MAX_VALUE, color: "#c2d5e1"}],
    },
    series:[{
      type: "line",
      field: "value",
      width: 2,
      markers: { visible: false },
      missingValues: "interpolate"
    }],
    chartArea: { background: "" },
    transitions: false,
    legend: { position: "bottom", visible: false },
    axisDefaults : {
      labels : {
        font: "10px Arial,Helvetica,sans-serif",
        format: "{0:n0}" // whole numbers; zero places
      },
    }
  };
  this.ALL_STATISTICS = {
    CacheHitRate: {
      columnConfig: {
        title: "Hit Rate",
        field: "CacheHitRate",
        template: '#= formatIntRightJustified(CacheHitRate) #',
        width: 75
      },
      chartConfig: {
        title: {text: "Hit Rate"},
        tooltip: {visible: true, format: "{0:n1} hits/sec."}
      }
    },
    CacheHitRatio: {
      columnConfig: {
        title: "Hit Ratio",
        field: "CacheHitRatio",
        template: "<div style='text-align:right;'>#= CacheHitRatio #%</div>",
        width: 80
      },
      chartConfig: {
        title: {text: "Hit Ratio"},
        tooltip: {visible: true, format: "{0:n0}%"},
        valueAxis: {
          min: 0,
          max: 100,
          labels : {
            format: "{0:n0}%" // whole numbers; zero places
          }
        }
      }
    },
    CacheOnDiskHitRate: { 
      columnConfig: {
        title: "Local Disk Hit Rate",
        field: "CacheOnDiskHitRate",
        template: '#= formatIntRightJustified(CacheOnDiskHitRate) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Local Disk Hit Rate"},
        tooltip: {visible: true, format: "{0:n1} hits/sec."}
      }
    },
    CacheInMemoryHitRate: {
      columnConfig: {
        title: "Local Heap Hit Rate",
        field: "CacheInMemoryHitRate",
        template: '#= formatIntRightJustified(CacheInMemoryHitRate) #',
        width: 140
      },
      chartConfig: {
        title: {text: "Local Heap Hit Rate"},
        tooltip: {visible: true, format: "{0:n1} hits/sec."}
      }
    },
    CacheOffHeapHitRate: {
      columnConfig: {
        title: "OffHeap Hit Rate",
        field: "CacheOffHeapHitRate",
        template: '#= formatIntRightJustified(CacheOffHeapHitRate) #',
        width: 130
      },
      chartConfig: {
        title: {text: "OffHeap Hit Rate"},
        tooltip: {visible: true, format: "{0:n1} hits/sec."}
      }
    },
    CacheMissRate: {
      columnConfig: {
        title: "Miss Rate",
        field: "CacheMissRate",
        template: '#= formatIntRightJustified(CacheMissRate) #',
        width: 85
      },
      chartConfig: {
        title: {text: "Miss Rate"},
        tooltip: {visible: true, format: "{0:n1} misses/sec."}
      }
    },
    CacheOnDiskMissRate: {
      columnConfig: {
        title: "Local Disk Miss Rate",
        field: "CacheOnDiskMissRate",
        template: '#= formatIntRightJustified(CacheOnDiskMissRate) #',
        width: 150
      },
      chartConfig: {
        title: {text: "Local Disk Miss Rate"},
        tooltip: {visible: true, format: "{0:n1} misses/sec."}
      }
    },
    CacheInMemoryMissRate: {
      columnConfig: {
        title: "Local Heap Miss Rate",
        field: "CacheInMemoryMissRate",
        template: '#= formatIntRightJustified(CacheInMemoryMissRate) #',
        width: 150
      },
      chartConfig: {
        title: {text: "Local Heap Miss Rate"},
        tooltip: {visible: true, format: "{0:n1} misses/sec."}
      }
    },
    CacheOffHeapMissRate: {
      columnConfig: {
        title: "OffHeap Miss Rate",
        field: "CacheOffHeapMissRate",
        template: '#= formatIntRightJustified(CacheOffHeapMissRate) #',
        width: 135
      },
      chartConfig: {
        title: {text: "OffHeap Miss Rate"},
        tooltip: {visible: true, format: "{0:n1} misses/sec."}
      }
    },
    
    Size: {
      columnConfig: {
        title: "Size",
        field: "Size",
        template: '#= formatIntRightJustified(Size) #',
        width: 100
      },
      chartConfig: {
        title: {text: "Size"},
        tooltip: {visible: true, format: "{0} entries"}
      }
    },
    LocalDiskSize: {
      columnConfig: {
        title: "Local Disk Size",
        field: "LocalDiskSize",
        template: '#= formatIntRightJustified(LocalDiskSize) #',
        width: 115
      },
      chartConfig: {
        title: {text: "Local Disk Size"},
        tooltip: {visible: true, format: "{0} entries"}
      }
    },
    LocalHeapSize: {
      columnConfig: {
        title: "Local Heap Size",
        field: "LocalHeapSize",
        template: '#= formatIntRightJustified(LocalHeapSize) #',
        width: 120
      },
      chartConfig: {
        title: {text: "Local Heap Size"},
        tooltip: {visible: true, format: "{0} entries"}
      }
    },
    LocalOffHeapSize: {
      columnConfig: {
        title: "Local OffHeap Size",
        field: "LocalOffHeapSize",
        template: '#= formatIntRightJustified(LocalOffHeapSize) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Local OffHeap Size"},
        tooltip: {visible: true, format: "{0} entries"}
      }
    },
    
    LocalHeapSizeInBytes: {
      columnConfig: {
        title: "Local Heap MB",
        field: "LocalHeapSizeInBytes",
        template: '#= formatFloatRightJustified(toMegabytes(LocalHeapSizeInBytes)) #',
        width: 115
      },
      chartConfig: {
        title: {text: "Local Heap Bytes"},
        tooltip: {
          visible: true,
          format: "{0} bytes",
          template: "#= formatFloat(toMegabytes(value)) # MB"
        },
        valueAxis: {labels : {template: "#= formatFloat(toMegabytes(value)) # MB"}}
      }
    },
    LocalDiskSizeInBytes: {
      columnConfig: {
        title: "Local Disk MB",
        field: "LocalDiskSizeInBytes",
        template: '#= formatFloatRightJustified(toMegabytes(LocalDiskSizeInBytes)) #',
        width: 110
      },
      chartConfig: {
        title: {text: "Local Disk Bytes"},
        tooltip: {
          visible: true,
          format: "{0} bytes",
          template: "#= formatFloat(toMegabytes(value)) # MB"
        },
        valueAxis: {labels : {template: "#= formatFloat(toMegabytes(value)) # MB"}}
      }
    },
    LocalOffHeapSizeInBytes: {
      columnConfig: {
        title: "Local OffHeap MB",
        field: "LocalOffHeapSizeInBytes",
        template: '#= formatFloatRightJustified(toMegabytes(LocalOffHeapSizeInBytes)) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Local OffHeap Bytes"},
        tooltip: {
          visible: true,
          format: "{0} bytes",
          template: "#= formatFloat(toMegabytes(value)) # MB"
        },
        valueAxis: {labels : {template: "#= formatFloat(toMegabytes(value)) # MB"}}
      }
    },

    CacheAverageGetTime: {
      type: "average",
      columnConfig: {
        title: "Avg. Get Millis.",
        field: "CacheAverageGetTime",
        template: '#= formatFloatRightJustified(CacheAverageGetTime/1000000.0, 3) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Avg. Get Millis."},
        tooltip: {visible: true, template: "#= formatFloat(value/1000000.0, 2) # msec."},
        valueAxis: {labels : {template: "#= formatFloat(value/1000000.0, 2) #"}}
      }
    },
    
    CacheAverageSearchTime: {
      type: "average",
      columnConfig: {
        title: "Avg. Search Millis.",
        field: "CacheAverageSearchTime",
        template: '#= formatFloatRightJustified(CacheAverageSearchTime, 2) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Avg. Search Millis."},
        tooltip: {visible: true, format: "{0:n2} ms"},
        valueAxis: {labels : {format: "{0:n2}"}}
      }
    },
    CacheSearchRate: {
      columnConfig: {
        title: "Search Rate",
        field: "CacheSearchRate",
        template: '#= formatIntRightJustified(CacheSearchRate) #',
        width: 95
      },
      chartConfig: {
        title: {text: "Search Rate"},
        tooltip: {visible: true, format: "{0:n1} searches/sec."}
      }
    },
    CacheRemoveRate: {
      columnConfig: {
        title: "Remove Rate",
        field: "CacheRemoveRate",
        template: '#= formatIntRightJustified(CacheRemoveRate) #',
        width: 100
      },
      chartConfig: {
        title: {text: "Remove Rate"},
        tooltip: {visible: true, format: "{0:n1} removes/sec."}
      }
    },
    CachePutRate: {
      columnConfig: {
        title: "Put Rate",
        field: "CachePutRate",
        template: '#= formatIntRightJustified(CachePutRate) #',
        width: 80
      },
      chartConfig: {
        title: {text: "Put Rate"},
        tooltip: {visible: true, format: "{0:n1} puts/sec."}
      }
    },
    CacheUpdateRate: {
      columnConfig: {
        title: "Update Rate",
        field: "CacheUpdateRate",
        template: '#= formatIntRightJustified(CacheUpdateRate) #',
        width: 100
      },
      chartConfig: {
        title: {text: "Update Rate"},
        tooltip: {visible: true, format: "{0:n1} updates/sec."}
      }
    },
    CacheExpirationRate: {
      columnConfig: {
        title: "Expiration Rate",
        field: "CacheExpirationRate",
        template: '#= formatIntRightJustified(CacheExpirationRate) #',
        width: 115
      },
      chartConfig: {
        title: {text: "Expiration Rate"},
        tooltip: {visible: true, format: "{0:n1} expirations/sec."}
      }
    },
    CacheEvictionRate: {
      columnConfig: {
        title: "Eviction Rate",
        field: "CacheEvictionRate",
        template: '#= formatIntRightJustified(CacheEvictionRate) #',
        width: 105
      },
      chartConfig: {
        title: {text: "Eviction Rate"},
        tooltip: {visible: true, format: "{0:n1} evictions/sec."}
      }
    },

    TransactionRollbackRate: {
      columnConfig: {
        title: "Txn. Rollback Rate",
        field: "TransactionRollbackRate",
        template: '#= formatIntRightJustified(TransactionRollbackRate) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Txn. Rollback Rate"},
        tooltip: {visible: true, format: "{0:n1} rollbacks/sec."}
      }
    },
    TransactionCommitRate: {
      columnConfig: {
        title: "Txn. Commit Rate",
        field: "TransactionCommitRate",
        template: '#= formatIntRightJustified(TransactionCommitRate) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Txn. Commit Rate"},
        tooltip: {visible: true, format: "{0:n1} commits/sec."}
      }
    },

    WriterQueueLength: {
      columnConfig: {
        title: "Writer Queue Length",
        field: "WriterQueueLength",
        template: '#= formatIntRightJustified(WriterQueueLength) #',
        width: 135
      },
      chartConfig: {
        title: {text: "Writer Queue Length"},
        tooltip: {visible: true, format: "{0:n1} queue entries"}
      }
    }
  };
  this.kCharts = {};

  $content.find("#chartsButton").click($.proxy(this.showCharts, this));

  this.statisticsGridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "CacheName",
        fields: {
          CacheName:               {type: "string",  editable: false},
          TerracottaClustered:     {type: "boolean", editable: false},
          CacheHitRate:            {type: "number",  editable: false},
          CacheHitRatio:           {type: "number",  editable: false},
          CacheInMemoryHitRate:    {type: "number",  editable: false},
          CacheOffHeapHitRate:     {type: "number",  editable: false},
          CacheOnDiskHitRate:      {type: "number",  editable: false},
          CacheMissRate:           {type: "number",  editable: false},
          CacheOnDiskMissRate:     {type: "number",  editable: false},
          CacheInMemoryMissRate:   {type: "number",  editable: false},
          CacheOffHeapMissRate:    {type: "number",  editable: false},
          Size:                    {type: "number",  editable: false},
          LocalDiskSize:           {type: "number",  editable: false},
          LocalHeapSize:           {type: "number",  editable: false},
          LocalOffHeapSize:        {type: "number",  editable: false},
          LocalHeapSizeInBytes:    {type: "number",  editable: false},
          LocalDiskSizeInBytes:    {type: "number",  editable: false},
          LocalOffHeapSizeInBytes: {type: "number",  editable: false},

          CacheAverageGetTime:     {type: "number",  editable: false},
          CacheAverageSearchTime:  {type: "number",  editable: false},
          CacheSearchRate:         {type: "number",  editable: false},
          CacheRemoveRate:         {type: "number",  editable: false},
          CacheUpdateRate:         {type: "number",  editable: false},
          CacheExpirationRate:     {type: "number",  editable: false},
          CacheEvictionRate:       {type: "number",  editable: false},

          TransactionRollbackRate: {type: "number",  editable: false},
          TransactionCommitRate:   {type: "number",  editable: false},
          
          WriterQueueLength:       {type: "number",  editable: false}
        }
      }
    },
    sort: {field: "CacheName", dir: "asc"}
   });
  
  var $configureWindow = $("#navigator-agent #configureColumnsWindow");
  this.setupConfigureColumnsWindow($configureWindow.clone());
  this.setupConfigureChartsWindow($configureWindow.clone());
  $content.find("#configureColumns").click($.proxy(that.showConfigureColumnsDialog, that));

  this.chartedStatistics = [
    'CacheHitRatio',
    'CacheMissRate',
    'CachePutRate',
    'CacheAverageGetTime'
  ];
  this.currentColumns = [
    'CacheHitRatio',
    'CacheHitRate', 
    'CacheMissRate', 
    'Size', 
    'LocalHeapSize',
    'LocalHeapSizeInBytes', 
    'CacheAverageGetTime'
  ];

  this.STATISTICS_CACHE_ATTRIBUTES = [
    "TerracottaClustered"
  ];
  
  this.CACHE_MANAGER_ATTRIBUTES = [
    "CacheNames"
  ];
  
  this.attr2historyMap = {
    CacheHitRate: "CacheHit",
    CacheHitRatio: "CacheHitRatio",
    CacheOnDiskHitRate: "CacheHitOnDisk",
    CacheInMemoryHitRate: "CacheHitInMemory",
    CacheOffHeapHitRate: "CacheHitOffHeap",
    CacheMissRate: "CacheMiss",
    CacheOnDiskMissRate: "CacheMissOnDisk",
    CacheInMemoryMissRate: "CacheMissInMemory",
    CacheOffHeapMissRate: "CacheMissOffHeap",
    CacheAverageGetTime: "AverageGetTimeNanos",
    CacheAverageSearchTime: "AverageSearchTime",
    CacheSearchRate: "SearchesPerSecond",
    CachePutRate: "CacheElementPut",
    CacheRemoveRate: "CacheElementRemoved",
    CacheUpdateRate: "CacheElementUpdated",
    CacheExpirationRate: "CacheElementExpired",
    CacheEvictionRate: "CacheElementEvicted",
    TransactionRollbackRate: "CacheXaRollbacks",
    TransactionCommitRate: "CacheXaCommits"
  };
  
  resizeHandler($content, function(e) {
    var $target = that.isChartsShowing() ? that.$charts : that.$statistics;
    assignRemainingHeight($target);
  });
  
  resizeHandler(that.$charts, function(e) {
    var w = that.$charts.width()/2,
      h = (that.$charts.height() - 3)/2;
  
    that.$charts.find(".k-content").each(function() {
      var $this = $(this),
        kChart = $this.data("kendoChart");
      
      $this.width(w).height(h);
      if (kChart) {
        kChart.redraw();
      }
    });
  });

  resizeHandler(that.$statistics, function(e) {
    this.stopPropagation();
    if (that.$statisticsGrid) {
      assignRemainingHeight(that.$statisticsGrid);
      that.$statisticsGrid.data("kendoTGrid")._setContentHeight();
    }
  });
}

AgentMonitoringPage.prototype = $.extend({}, BaseAgentPage.prototype, {
  toString: function() {
    return "AgentMonitoringPage";
  },

  show: function() {
    $.xhrPool.suspend();
    this.requestHistory().always(function() {
      $.xhrPool.resume();
    });
    BaseAgentPage.prototype.show.call(this);
  },  
  
  hide: function() {
    this.clearChartData();
    BaseAgentPage.prototype.hide.call(this);
  },  
  
  isChartsShowing: function() {
    return this.$charts2.hasClass("toggleOn");
  },
  
  getCacheAttributes: function() {
    if (this.isChartsShowing()) {
      return this.chartedStatistics;
    } else {
      return this.STATISTICS_CACHE_ATTRIBUTES.concat(this.currentColumns);
    }
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  getCacheManager: function() {
    return this.getSelectedCacheManager();
  },
  
  getCache: function() {
    if (this.isChartsShowing()) {
      var cache = this.getSelectedCache();
      if (cache && cache != this.ALL_CACHES) {
        return cache;
      }
    }
    return null;
  },
  
  setupConfigureColumnsWindow: function($configureWindow) {
    var that = this;
    
    that.$configureColumnsWindow = $configureWindow;
    that.kConfigureColumnsWindow = that.$configureColumnsWindow.kendoWindow({
      title: "Configure Columns",
      modal: true,
      visible: false,
      resizable: false,
      width: "25em",
      height: "auto"
    }).data("kendoWindow");
    $configureWindow.on("click", "#choices tr", function(e) {
      $(this).find("input:checkbox").prop("checked", function(i, checked) { return !checked; });
    });
    $configureWindow.on("click", "#choices input:checkbox", function(e) {
      e.stopPropagation();
    });
    $configureWindow.find("#SelectAllControl").click(function(e) {
      $configureWindow.find("#choices input:checkbox").prop("checked", $(this).prop("checked"));
    });
    $configureWindow.find("#SelectAllArea").show();
    $configureWindow.on("click", "button[id='cancelButton']", function() {
      that.kConfigureColumnsWindow.close();
    });
    $configureWindow.on("click", "button[id='okButton']", function() {
      that.configureColumns();
    });
    
    this._finishSetupConfigureWindow($configureWindow);
  },
  
  setupConfigureChartsWindow: function($configureWindow) {
    var that = this;

    that.$configureChartWindow = $configureWindow;
    that.$configureChartWindow.find("input:checkbox").prop("type", "radio");
    that.$configureChartWindow.find("#msg").text("Select which statistic to monitor in the graph.");
    that.kConfigureChartWindow = this.$configureChartWindow.kendoWindow({
      title: "Configure Chart",
      modal: true,
      visible: false,
      resizable: false,
      width: "25em",
      height: "auto"
    }).data("kendoWindow");
    $configureWindow.on("click", "#choices tr", function(e) {
      var $btn = $(this).find("input:radio");
      $btn.prop("checked", true);
      $configureWindow.find("input:radio[name!='" + $btn.attr("name") + "']").removeAttr("checked"); 
    });
    $configureWindow.on("click", "#choices input:radio", function(e) {
      e.stopPropagation();
      $configureWindow.find("input:radio[name!='" + $(this).attr("name") + "']").removeAttr("checked"); 
    });
    $configureWindow.on("click", "button[id='cancelButton']", function() {
      that.kConfigureChartWindow.close();
    });
    $configureWindow.on("click", "button[id='okButton']", function() {
      that.configureChart();
    });
    
    this._finishSetupConfigureWindow($configureWindow);
  },
  
  _finishSetupConfigureWindow: function($window) {
    var kWindow = $window.data("kendoWindow"),
      keydownHandler = function(e) {
        switch (e.which) {
          case kendo.keys.ESC: {
            kWindow.close();
            break;
          }
          case kendo.keys.ENTER: {
            $window.find("button[id='okButton']").click();
            break;
          }
        }
      };
    
    kWindow.bind("open", function() {
      $(document).bind("keydown", keydownHandler);
    });
    kWindow.bind("close", function() {
      $(document).unbind("keydown", keydownHandler);
    });
  },
  
  showStatistics: function() {
    var that = this;

    $.xhrPool.suspend();
    that.$statistics2.attr('class', 'toggleOn');
    that.$charts2.attr('class', 'toggleOff');
    that.$charts.fadeOut('fast', function() {
      that.clearChartData();
      that.fireQueryAttributesChanged();
      $.xhrPool.resume();
      that.$statistics.fadeIn();
    });
    that._showCacheSelector(false);
  },
  
  showCharts: function() {
    var that = this;

    $.xhrPool.suspend();
    that.requestHistory().always(function() {
      $.xhrPool.resume();
    });
    that.$charts2.attr('class', 'toggleOn');
    that.$statistics2.attr('class', 'toggleOff');    
    that.$statistics.fadeOut('fast', function() {
      that.fireQueryAttributesChanged();
      that.$charts.fadeIn();
    });
    that._showCacheSelector(true);
  },
  
  buildSampleHistoryRequest: function(statName) {
    var that = this,
      cacheManagerName = this.getSelectedCacheManager(),
      cacheName = this.getSelectedCache();
      suffix = "";
      
    if (cacheName != this.ALL_CACHES) {
      suffix = ";names=" + cacheName;
    }
    suffix += "/statistics/samples;names=";
    
    if (statName != null) {
      suffix += that.attr2historyMap[statName];
    } else {
      var sampleNames = [];
      $.each(this.kCharts, function(statName, kChart) {
        var sampleName = that.attr2historyMap[statName];
        if (sampleName != null) {
          sampleNames.push(sampleName);
        }
      });
      suffix += sampleNames.join(",");
    }
    
    return "api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names=" + cacheManagerName + "/caches" + suffix;
  },
  
  normalizeSamples: function(samples) {
    return $.map(samples, function(value, timeStamp) {
      return {timeStamp: new Number(timeStamp), value: value};
    });
  },
  
  handleSampleHistoryResponse: function(data) {
    var that = this,
      sampleInfoMap = {}; // sampleName -> {samples:, cacheMap:}
    
    $.each(data, function(index, value) {
      var sampleName = value.statName,
        sampleInfo = sampleInfoMap[sampleName],
        newSamples = that.normalizeSamples(value.statValueByTimeMillis);
      
      if (sampleInfo == null) {
        sampleInfo = sampleInfoMap[sampleName] = {samples: newSamples, misses: 0};
        sampleInfo.cacheMap = {};
      } else {
        $.each(newSamples, function(index, entry) {
          var existingEntry = sampleInfo.samples[index];
          if (existingEntry == null) {
            sampleInfo.misses++;
          } else {
            existingEntry.value += entry.value;
          }
        });
      }
      sampleInfo.cacheMap[value.name] = value.name;
    });
    
    $.each(this.kCharts, function(statName, kChart) {
      var statConfig = that.ALL_STATISTICS[statName],
        sampleName = that.attr2historyMap[statName];
        
      if (sampleName != null) {
        var sampleInfo = sampleInfoMap[sampleName];
        
        if (sampleInfo != null) {
          var sourceCount = $.map(sampleInfo.cacheMap, function(value, key) { return key; }).length,
            shouldAverage = (sourceCount > 1) && (statConfig.type === "average"),
            data = [];
      
          if (sampleInfo.samples != null) {
            $.each(sampleInfo.samples, function(index, entry) {
              var timeStamp = entry.timeStamp,
                value = entry.value;
              
              if ($.isNumeric(value)) {
                if (shouldAverage) {
                  value = (value == 0) ? 0 : value/sourceCount;
                }
                data.push({time: new Date(timeStamp), value: value});
              }
            });
    
            var diff = data.length - this.sampleHistorySize;
            if (diff > 0) {
              data.splice(0, diff);
            }
            kChart.dataSource.data(data);
          }
        }
      }
    });
  },
  
  /**
   * If statName is null, retrieve samples for all charts.
   */
  requestHistory: function(statName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI(this.buildSampleHistoryRequest(statName)),
      success: function(data) {
        this.handleSampleHistoryResponse(data);
      },
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },
  
  initialize: function() {
    this.sampleHistorySize = this.agentPage.getSampleHistorySize();
    
    if (userProfile) {
      if (!userProfile.ehcacheGridStatistics) {
        userProfile.ehcacheGridStatistics = this.currentColumns;
      } else {
        this.currentColumns = [].concat(userProfile.ehcacheGridStatistics);
      }
      if (!userProfile.ehcacheChartedStatistics) {
        userProfile.ehcacheChartedStatistics = this.chartedStatistics;
      } else {
        this.chartedStatistics = [].concat(userProfile.ehcacheChartedStatistics);
      }
      
      if (this.sampleHistorySize == null) {
        this.sampleHistorySize = userProfile.statisticsPollingIntervalMillis/1000;
      }
    }
    
    var step = this.sampleHistorySize < 10 ? 1 : (this.sampleHistorySize/this.TARGET_LABEL_COUNT),
      ticksVisible = this.sampleHistorySize < this.SAMPLE_COUNT_TICKS_THRESHOLD;

    this.CHART_DEFAULTS.categoryAxis.labels.step = Math.round(step);
    this.CHART_DEFAULTS.categoryAxis.majorTicks.visible = ticksVisible;
    
    this.setColumns(this.currentColumns);
    this.setChartedStatistics(this.chartedStatistics);
    
    this.fireQueryAttributesChanged();
    
    $(document).bind("tmc.userProfileChanged", $.proxy(this.handleUserProfile, this));
  },
  
  handleUserProfile: function(e) {
    var that = this,
      step = this.sampleHistorySize <= 10 ? 1 : (this.sampleHistorySize/this.TARGET_LABEL_COUNT),
      ticksVisible = this.sampleHistorySize < this.SAMPLE_COUNT_TICKS_THRESHOLD;
    
    $.each(this.kCharts, function(statName, kChart) {
      kChart.options.categoryAxis.labels.step = Math.round(step);
      kChart.options.categoryAxis.majorTicks.visible = ticksVisible;      
    });
  },
  
  setChartedStatistics: function(chartedStatistics) {
    var that = this;
    
    that.chartedStatistics = chartedStatistics;
    that.$charts.find("div.k-content").each(function(index, element) {
      var $this = $(this),
        statName = that.chartedStatistics[index],
        statConfig = that.ALL_STATISTICS[statName];
      
      if (statConfig) {
        var chartConfig = $.extend(true, {}, statConfig.chartConfig, that.CHART_DEFAULTS),
          $chart = $this.kendoChart(chartConfig);
        
        $chart.attr("id", statName);
        that.kCharts[statName] = $chart.data("kendoChart");
        $this.on("click", function() {
          that.showConfigureChartWindow($this);
        });
      }
    });
  },
  
  showConfigureChartWindow: function($chart) {
    var that = this;
    var currStatName = $chart.attr("id");
    var $window = that.$configureChartWindow;
    var kWindow = that.kConfigureChartWindow; 

    $window.find("input:radio[name!='" + currStatName + "']").removeAttr("checked disabled");
    $window.find("input:radio[name='" + currStatName + "']")
      .attr("checked", "checked")
      .removeAttr("disabled");
    $.each(this.kCharts, function(statName, kChart) {
      if (statName != currStatName) {
        $window.find("input:radio[name='" + statName + "']")
          .attr("checked", "checked")
          .attr("disabled", "disabled");
      }
    });
    $window.data("$chart", $chart);
    $window.data("oldStatName", currStatName);

    $window.show();
    kWindow.center().open();
  },
  
  configureChart: function() {
    var that = this;
    var newStatName = that.$configureChartWindow.find("input:radio:checked").attr("name");
    
    if (newStatName) {
      var newStat = that.ALL_STATISTICS[newStatName];

      if (newStat) {
        $.xhrPool.suspend();
        
        var $chart = that.$configureChartWindow.data("$chart"),
          oldStatName = that.$configureChartWindow.data("oldStatName");

        $chart.empty();
        delete that.kCharts[oldStatName];
        
        var chartConfig = $.extend(true, {}, newStat.chartConfig, that.CHART_DEFAULTS);
        that.kCharts[newStatName] = $chart.kendoChart(chartConfig).data("kendoChart");
        $chart.attr("id", newStatName);
        var i = that.chartedStatistics.indexOf(oldStatName);
        if (i >= 0) {
          that.chartedStatistics[i] = newStatName;

          this.requestHistory(newStatName).always(function() {
            that.fireQueryAttributesChanged();

            if (!$.compareArrays(userProfile.ehcacheChartedStatistics, that.chartedStatistics)) {
              var newUserProfile = $.extend({}, userProfile);
              newUserProfile.ehcacheChartedStatistics = that.chartedStatistics;
              updateUserProfile(newUserProfile);
            }

            $.xhrPool.resume();
          });
        } else {
          $.xhrPool.resume();
        }
      }
      that.kConfigureChartWindow.close();
    }
  },
  
  _showCacheSelector: function(show) {
    var that = this,
      parentLineItem = that.$cacheSelector.closest("li"),
      labelItem = parentLineItem.prev("li");
    
    if(show) {
      parentLineItem.show();
      labelItem.show();
    } else {
      parentLineItem.hide();
      labelItem.hide();
    }
  },
  
  updateGrid: function(cacheManagerName) {
    var that = this,
      kGrid = that.$statisticsGrid.data("kendoTGrid"),
      ds = kGrid.dataSource,
      cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName];
      caches = cacheManagerAttrs.caches;

      if (ds.total() == 0) {
        var data = [];
        $.each(caches, function(cacheName, cacheAttrs) {
          data.push(cacheAttrs);
        });
        ds.data(data);
      } else {
        $.each(caches, function(cacheName, cacheAttrs) {
          kGrid.updateModel(cacheName, cacheAttrs);        
        });
      }
  },

  handleCacheManagerSelection: function(e) {
    if (e) {
      $.xhrPool.suspend();
    }
    
    this.clearChartData();
    this.clearGridData();
    
    var cacheManagerName = this.$cacheManagerSelector.data("kendoComboBox").text();
    var cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName];
    var cacheDS = this.cacheDataSource;
    
    cacheDS.data().length = 0;
    cacheDS.add(this.ALL_CACHES_ENTRY);
    
    if (cacheManagerAttrs) {
      $.each(cacheManagerAttrs.CacheNames, function(i, cacheName) {
        cacheDS.add({name: cacheName});  
      });
    }
    
    this.selectAllCaches();
    
    this.fireQueryAttributesChanged();
    
    if (e) {
      this.requestHistory().always(function() {
        $.xhrPool.resume();
      });
    }
  },
  
  selectAllCaches: function() {
    this.selectComboItem(this.$cacheSelector.data("kendoComboBox"));
  },
  
  selectComboItem: function(kComboBox, name) {
    if (name == null) {
      var view = kComboBox.dataSource.view();
      if (view.length > 0) {
        name = view[0].name;
      }
    }
    kComboBox.select(function(dataItem) {
      return dataItem.name = name;
    });
  },
  
  handleCacheSelection: function() {
    $.xhrPool.suspend();
    this.clearChartData();
    this.fireQueryAttributesChanged();
    this.requestHistory().always(function() {
      $.xhrPool.resume();
    });
  },

  getSelectedCache: function() {
    return this.$cacheSelector.data("kendoComboBox").text();
  },

  getSelectedCacheManager: function() {
    return this.$cacheManagerSelector.data("kendoComboBox").text()
  },
  
  isSelectedCacheManager: function(cacheManagerName) {
    return cacheManagerName == this.getSelectedCacheManager();
  },
  
  handleCachesAdded: function(e) {
    var that = this;
    
    if (that.isSelectedCacheManager(e.cacheManagerName)) {
      $.each(e.cacheNames, function(index, cacheName) {
        that._handleCacheAdded(cacheName);
      });
    }
  },
  
  handleCacheAdded: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      this._handleCacheAdded(e.cacheName);
    }
  },
 
  _handleCacheAdded: function(cacheName) {
    var cacheDS = this.cacheDataSource;
      
    if (cacheDS.get(this.ALL_CACHES) == -1) {
      cacheDS.add(this.ALL_CACHES_ENTRY);
    }
    if (cacheDS.get(cacheName) == null) {
      cacheDS.add({name: cacheName});
    }
  },
  
  handleCacheRemoved: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      var cacheName = e.cacheName,
        item = cacheDS.get(cacheName),
        selectedCache = this.getSelectedCache(),
        cacheDS = this.cacheDataSource;
        
      if (item) {
        var i = (cacheName == selectedCache) ? cacheDS.indexOf(item) : -1;
        
        cacheDS.remove(item);
        if (i != -1) {
          var length = cacheDS.data().length;
          
          if (i >= length) {
            i = length - 1;
          }
          this.cacheSelector.data("kendoComboBox").select(i);
          this.handleCacheSelection();
        }
      }
      
      this.$statisticsGrid.data("kendoTGrid").removeModel(cacheName);
    }
  },
  
  handleCacheManagerAdded: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheManagerDS = this.cacheManagerDataSource;
    
    if (cacheManagerDS.get(cacheManagerName) == null) {
      cacheManagerDS.add({name: cacheManagerName});
    }

    if (this.getSelectedCacheManager() == "" && cacheManagerDS.data().length > 0) {
      kCacheManagerCombo = this.$cacheManagerSelector.data("kendoComboBox");
      
      this.selectComboItem(kCacheManagerCombo);
      this.handleCacheManagerSelection();
    }
  },
  
  handleCacheManagerRemoved: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheManagerDS = this.cacheManagerDataSource,
      item = cacheManagerDS.get(cacheManagerName);
    
    if (item) {
      var selectedCacheManager = this.getSelectedCacheManager(),
        index = (cacheManagerName == selectedCacheManager) ? cacheManagerDS.indexOf(item) : -1;
      
      cacheManagerDS.remove(item);
      if (index != -1) {
        var length = cacheManagerDS.data().length,
          kCacheManagerCombo = this.$cacheManagerSelector.data("kendoComboBox");
        
        if (index >= length) {
          index = length - 1;
        }
        kCacheManagerCombo.select(index);
        this.handleCacheManagerSelection();
      }
    }
  },
  
  handleCacheDetails: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      this.updateDisplay();
    }
  },
  
  updateDisplay: function() {
    var that = this,
      selectedCacheManager = that.getSelectedCacheManager(),
      cacheManagerAttrs = that.agentPage.cacheManagers[selectedCacheManager],
      caches = cacheManagerAttrs.caches;

    if (caches != null) {
      if (this.isChartsShowing()) {
        var now = new Date();
        
        this.$charts.find("div.k-content").each(function() {
          var $chart = $(this),
            kChart = $chart.data("kendoChart"),
            statName = $chart.attr("id"),
            statConfig = that.ALL_STATISTICS[statName];
            cacheCount = 0, 
            value = 0;
            
          $.each(caches, function(cacheName, cacheAttrs) {
            value += cacheAttrs[statName];
            cacheCount++;
          });
          
          if (cacheCount > 1 && statConfig.type === "average") {
            value = (value == 0) ? 0 : value/cacheCount;
          }
          
          that.updateChart(kChart, now, value);
        });
      } else {
        that.updateGrid(selectedCacheManager);
      }
    }
  },
  
  updateChart: function(chart, time, value) {
    if ($.isNumeric(value)) {
      var ds = chart.dataSource;
      ds.add({time: time, value: value});
  
      var data = ds.data();
      var diff = data.length - this.sampleHistorySize;
      if (diff > 0) {
        data.splice(0, diff);
      }
    }
  },

  clearChartData: function() {
    $.each(this.kCharts, function(i, kChart) {
      kChart.dataSource.data().length = 0;
      kChart.refresh();
    });
  },

  clearGridData: function() {
    this.$statisticsGrid.data("kendoTGrid").clear();
  },
  
  showConfigureColumnsDialog: function() {
    var $window = this.$configureColumnsWindow,
      kWindow = this.kConfigureColumnsWindow;
    
    $window.find("input:checkbox:checked").removeAttr("checked");
    $.each(this.currentColumns, function() {
      $window.find("input:checkbox[name='" + this + "']").attr("checked", "checked"); 
    });
    $window.show();
    kWindow.center().open();
  },

  setColumns: function(columnNames) {
    var that = this,
      columnConfigs = [{
        title: "Cache",
        field: "CacheName",
        template: "# if (TerracottaClustered) { # <span class='clusteredCache'> # } else { # <span class='nonClusteredCache'> # } # #= CacheName # </span>",
        width: "20%"
      }];
    
    that.currentColumns = columnNames || [];
    $.each(that.currentColumns, function() {
      var stat = that.ALL_STATISTICS[this];
      if (stat && stat.columnConfig) {
        columnConfigs.push(stat.columnConfig);
      }
    });
    if (that.$statisticsGrid) {
      var kGrid = that.$statisticsGrid.data("kendoTGrid");

      kGrid.setDataSource(new kendo.data.DataSource());
      that.$statisticsGrid.removeData("kendoTGrid");
      that.$statisticsGrid.empty();
    }
    that.$statisticsGrid = that.$statistics.find("#grid").kendoTGrid({
      dataSource: that.statisticsGridDS,
      columns: columnConfigs,
      sortable: true,
      pageable: false,
      selectable: "row",
      scrollable: { virtual: true },
      resizable: true,
      reorderable: true
    });

    that.$statisticsGrid.find(".k-virtual-scrollable-wrap").bind({
      "scrollstart": function() {
        $.xhrPool.suspend();
      },
      "scrollstop": function() {
        $.xhrPool.resume();
      }
    });
    
    if (!$.compareArrays(userProfile.ehcacheGridStatistics, that.currentColumns)) {
      var newUserProfile = $.extend({}, userProfile);
      newUserProfile.ehcacheGridStatistics = that.currentColumns;
      updateUserProfile(newUserProfile);
    }
    
    that.$statisticsGrid.trigger("resize");
  },
  
  configureColumns: function() {
    $.xhrPool.suspend();
    
    var newColumns = [];
    this.$configureColumnsWindow.find("input:checkbox:checked").each(function() {
      newColumns.push($(this).attr("name"));
    });
    this.$statisticsGrid.data("kendoTGrid").clear();    
    this.setColumns(newColumns)
    this.fireQueryAttributesChanged();
    this.kConfigureColumnsWindow.close();
    
    $.xhrPool.resume();
  },
  
  refresh: function() {}
});
