function AgentDiagnosticsPage(agentPage, $content) {
  BaseAgentPage.call(this, agentPage, $content);

  var that = this;
  var comboConfig = function() {
    return {
      data: [],
      schema: {
        model: {
          id: "name",
          fields: {name: {type: "string", editable: false}}
        }
      },
      sort: {field: "name", dir: "asc"}
    };
  };
  this.$cacheManagerSelector = $content.find("#cacheManagerSelector").kendoComboBox({
    dataSource: this.cacheManagerDataSource = new kendo.data.DataSource(comboConfig()),
    dataTextField: "name",
    dataValueField: "name",
    change: $.proxy(that.handleCacheManagerSelection, that)
  });
  var getSplitterConf = function(orientation) {
    return {
      panes: [
        {collapsible: false, size: "50%", resizable: true, scrollable: false},
        {collapsible: false, size: "50%", resizable: true, scrollable: false}
      ],
      orientation: orientation
    };
  };
  this.$mainSplitter = $content.find("#mainSplitter");
  this.$mainSplitter.kendoSplitter(getSplitterConf("vertical")); 
  this.$mainSplitter.find("#splitter").kendoSplitter(getSplitterConf("horizontal"));
  var getChartDataSource = function(data) {
    return {
      data: data,
      schema: {
        model: {
          id: "tier",
          fields: {
            tier:  {type: "string", editable: false},
            value: {type: "number", editable: false}
          }
        }
      },
      sort: {field: "tier", dir: "asc"}
     };
  };
  var getChartConf = function(data, color) {
    return {
      dataSource: getChartDataSource([data]),
      theme: $(document).data("kendoSkin") || "default",      
      title: { padding: 0, margin: 0, visible: false },
      legend: { visible: false },
      chartArea: { background: "#F0F0F0", border: { width: 1, dashType: "dot" }, margin: 8 },
      transitions: false,
      seriesDefaults: {
        type: "bar",
        labels: { visible: false, format: "{0}" },
        spacing: 0.0
      },
      series: [{ field: "value" }],
      seriesColors: [color],
      categoryAxis: {
        field: "tier",
        labels: { visible: true, mirror: true, color: "gray" }
      },
      valueAxis: {
        labels: {
          format: "{0} MB",
          font: "10px Arial,Helvetica,sans-serif"
        },
        plotBands: [{ from: 0, to: Number.MAX_VALUE, color: "#EDF5FF"}],
      },
      tooltip: {
        visible: true,
        template: "#= formatFloat(value) #MB on #= category #"          
      }
    };
  }
  var seriesColors = ['#EAD399', '#99D9EA', '#EAAB99'];
  
  this.cacheManagerUsageData = [{tier: "Local Heap", value:0}, {tier: "Local OffHeap", value:0}, {tier: "Local Disk", value:0}];
  this.cacheManagerUsageCharts = [];
  var $charts = this.$mainSplitter.find("#topArea #leftArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i));
    var chartConf = getChartConf(this.cacheManagerUsageData[i], seriesColors[i]);
    this.cacheManagerUsageCharts.push($chart.kendoChart(chartConf));
  }
  
  var $topRight = this.$mainSplitter.find("#topArea #rightArea");
  that.cachesDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "name",
        fields: {
          name:                 {type: "string", editable: false},
          sizeInBytes:          {type: "number", editable: false},
          percentOfUsed:        {type: "number", editable: false},
          entries:              {type: "number", editable: false},
          meanEntrySizeInBytes: {type: "number", editable: false}
        }
      }
    },
    sort: {field: "name", dir: "asc"}
   });
  this.cachesGrid = $topRight.find("#grid").kendoTGrid({
    dataSource: that.cachesDS,
    columns: [
      {
        title: "Cache",
        field: "name",
        template: "# if (terracottaClustered) { # <span class='clusteredCache'> # } else { # <span class='nonClusteredCache'> # } # #= name # </span>",
        width: "40%"
      },
      {
        title: "Size (MB)",
        field: "sizeInBytes",
        template: "#= formatFloatRightJustified(toMegabytes(sizeInBytes)) #",
        width: "15%"
      },
      {
        title: "% of Used",
        field: "percentOfUsed",
        template: "#= formatPercentageRightJustified(percentOfUsed) #",
        width: "15%"
      },
      {
        title: "Entries",
        field: "entries",
        template: "#= formatIntRightJustified(entries) #",
        width: "15%"
      },
      {
        title: "Mean Entry Size (bytes)",
        field: "meanEntrySizeInBytes",
        template: "#= formatFloatRightJustified(meanEntrySizeInBytes) #",
        width: "15%"
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: { virtual: true },
    resizable: true,
    reorderable: true,
    change: $.proxy(that.handleCacheGridSelection, that)
  });
  this.cachesGrid.find(".k-virtual-scrollable-wrap").bind({
    "scrollstart": function() {
      $.xhrPool.suspend();
    },
    "scrollstop": function() {
      $.xhrPool.resume();
    }
  });
  
  this.$tierSelector = $topRight.find("#tierSelector").kendoComboBox();

  this.$selectedCacheDescription = this.$mainSplitter.find("#bottomArea #selectedCacheDescription");
  this.cacheSelectorCombo = this.$mainSplitter.find("#cacheSelectorComboBox").kendoComboBox({
    dataSource: that.cachesDS,
    dataTextField: "name",
    dataValueField: "name",
    change: $.proxy(that.handleCacheComboSelection, that)
  });
  
  this.cacheUsageData = [{tier: "Local Heap", value:0}, {tier: "Local OffHeap", value:0}, {tier: "Local Disk", value:0}];
  this.cacheUsageCharts = [];
  $charts = this.$mainSplitter.find("#bottomArea #leftArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i));
    var chartConf = getChartConf(this.cacheUsageData[i], seriesColors[i]);
    this.cacheUsageCharts.push($chart.kendoChart(chartConf));
  }
  
  this.cacheMissesData = [{tier: "Local Heap", value:0}, {tier: "Local OffHeap", value:0}, {tier: "Local Disk", value:0}];
  this.cacheMissesCharts = [];
  $charts = this.$mainSplitter.find("#bottomArea #rightArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i));
    var chartConf = getChartConf(this.cacheMissesData[i], seriesColors[i]);
    var overrides =  {
      valueAxis: {
        labels: { format: "{0}" },
        plotBands: [{ from: 0, to: Number.MAX_VALUE, color: "#EDF5FF"}],
      },
      tooltip: {
        visible: true,
        template: "#= value # misses/s. on #= category #"          
      }
    };

    chartConf = $.extend({}, chartConf, overrides);
    this.cacheMissesCharts.push($chart.kendoChart(chartConf));
  }

  this.$mainSplitter.find("#chart").on("click", function(e) {
    var name = $(this).attr("name");
    if (name) {
      that.selectTier(name);
    }
  });

  this.CACHE_ATTRIBUTES = [
    "LocalHeapSize",
    "LocalHeapSizeInBytes",
    "LocalOffHeapSize",
    "LocalOffHeapSizeInBytes",
    "LocalDiskSize",
    "LocalDiskSizeInBytes",
    "CacheInMemoryMissRate",
    "CacheOffHeapMissRate",
    "CacheOnDiskMissRate",
    "TerracottaClustered"
  ];
  
  this.CACHE_MANAGER_ATTRIBUTES = [
    "MaxBytesLocalHeap",
    "MaxBytesLocalOffHeap",
    "MaxBytesLocalDisk"
  ];
  
  resizeHandler(this.cachesGrid.parent(), function() {
    assignRemainingHeight(that.cachesGrid);
    that.cachesGrid.data("kendoTGrid")._setContentHeight();
  });
  
  resizeHandler($content, function() {
    assignRemainingHeight(that.$mainSplitter);
  }, false);

  this.$mainSplitter.find("#chartHeader").each(function() {
    var $this = $(this),
      $parent = $this.parent(),
      $charts = $parent.find("#chart");
    
    resizeHandler($parent, function() {
      var w = $parent.width(),
        h = ($parent.height() - $this.outerHeight(true))/3;
      
      $charts.each(function() {
        var $chart = $(this);
        
        $chart.width(w).height(h);
        var kChart = $chart.data("kendoChart");
        if (kChart) {
          kChart.redraw();
        }
      });
    });
  });

  var $bottomArea = this.$mainSplitter.find("#bottomArea"),
    $bottomAreaSplitter = $bottomArea.find("#splitter");
  
  resizeHandler($bottomArea, function() {
    assignRemainingHeight($bottomAreaSplitter);
  }, false);
}

AgentDiagnosticsPage.prototype = $.extend({}, BaseAgentPage.prototype, {
  toString: function() {
    return "AgentDiagnosticsPage";
  },

  getCacheAttributes: function() {
    return this.CACHE_ATTRIBUTES;
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  getCacheManager: function() {
    return this.getSelectedCacheManager();
  },
  
  getSelectedTier: function() {
    var kCombo = this.$tierSelector.data("kendoComboBox");
    return kCombo.value();
  },
  
  selectTier: function(tierName) {
    var kCombo = this.$tierSelector.data("kendoComboBox");
    kCombo.value(tierName);
  },
  
  selectComboItem: function(kComboBox, name) {
    if (name == null) {
      var view = kComboBox.dataSource.view();
      if (view.length > 0) {
        name = view[0].name;
      }
    }
    kComboBox.select(function(dataItem) {
      return dataItem.name = name;
    });
  },

  getSelectedCacheManager: function() {
    return this.$cacheManagerSelector.data("kendoComboBox").text();
  },
  
  isSelectedCacheManager: function(cacheManagerName) {
    return cacheManagerName == this.getSelectedCacheManager();
  },
  
  handleCacheManagerSelection: function() {
    $.xhrPool.suspend();
    this.fireQueryAttributesChanged();
    this.cachesDS.clear();
    $.xhrPool.resume();
  },
  
  handleCachesAdded: function(e) {},
  
  handleCacheAdded: function(e) {},
 
  handleCacheRemoved: function(e) {
    var cacheManagerName = e.cacheManagerName;
    
    if (this.isSelectedCacheManager(cacheManagerName)) {
      var kCachesGrid = this.cachesGrid.data("kendoTGrid");
      kCachesGrid.removeModel(e.cacheName);
    }
  },
  
  handleCacheManagerAdded: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheManagerDS = this.cacheManagerDataSource,
      selectedCacheManager = this.getSelectedCacheManager();
    
    if (cacheManagerDS.get(cacheManagerName) == null) {
      cacheManagerDS.add({name: cacheManagerName});
    }
    
    if (selectedCacheManager == "" && cacheManagerDS.data().length > 0) {
      kCacheManagerCombo = this.$cacheManagerSelector.data("kendoComboBox");
      this.selectComboItem(kCacheManagerCombo);
    }
  },
  
  handleCacheManagerRemoved: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheManagerDS = this.cacheManagerDataSource,
      item = cacheManagerDS.get(cacheManagerName);
    
    if (item) {
      var kCacheManagerCombo = this.$cacheManagerSelector.data("kendoComboBox"),
        selectedCacheManager = kCacheManagerCombo.value(),
        index = (cacheManagerName == selectedCacheManager) ? cacheManagerDS.indexOf(item) : -1;
        
      cacheManagerDS.remove(item);
      if (index != -1) {
        var length = cacheManagerDS.data().length;
        if (index >= length) {
          index = length - 1;
        }
        kCacheManagerCombo.select(index);
      }
    }
  },
  
  handleCacheDetails: function(e) {
    var cacheManagerName = e.cacheManagerName,
      kCacheManagerCombo = this.$cacheManagerSelector.data("kendoComboBox"),
      selectedCacheManager = kCacheManagerCombo.value();
    
    if (cacheManagerName == selectedCacheManager) {
      var cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName],
        sizing = cacheManagerAttrs.Sizing = {
          localHeap:    { sizeInBytes:0, size:0 },
          localOffHeap: { sizeInBytes:0, size:0 },
          localDisk:    { sizeInBytes:0, size:0 }
        };      
        
      $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
        sizing.localHeap.size += cacheAttrs.LocalHeapSize;
        sizing.localHeap.sizeInBytes += cacheAttrs.LocalHeapSizeInBytes;
        sizing.localOffHeap.size += cacheAttrs.LocalOffHeapSize;
        sizing.localOffHeap.sizeInBytes += cacheAttrs.LocalOffHeapSizeInBytes;
        sizing.localDisk.size += cacheAttrs.LocalDiskSize;
        sizing.localDisk.sizeInBytes += cacheAttrs.LocalDiskSizeInBytes;
      });
  
      this.updateDisplay();
    }
  },
  
  refreshCharts: function($charts, valueAxisMax) {
    if ($charts) {
      $.each($charts, function() {
        var kChart = $(this).data("kendoChart");

        if (valueAxisMax) {
          kChart.options.valueAxis.max = Math.max(valueAxisMax, 10);
        }
        kChart.dataSource.read(ds.data());
      });
    }
  },
  
  ensureSelectedCache: function() {
    var that = this,
      kCachesGrid = that.cachesGrid.data("kendoTGrid"),
      selectedCache = kCachesGrid.getSelection();

    if (!selectedCache && kCachesGrid.dataSource.total() > 0) {
      kCachesGrid.select(kCachesGrid.tbody.find(">tr:first"));
      selectedCache = kCachesGrid.getSelection();
      that.updateCacheCombo(selectedCache.name);
    }
    
    return selectedCache;
  },
  
  updateDisplay: function() {
    var that = this,
      now = new Date(),
      selectedTier = that.getSelectedTier(),
      selectedCacheManager = that.$cacheManagerSelector.data("kendoComboBox").value(),
      cacheManagerAttrs = that.agentPage.cacheManagers[selectedCacheManager],
      sizing = cacheManagerAttrs.Sizing,
      usageData = that.cacheManagerUsageData,
      caches = cacheManagerAttrs.caches,
      kCachesGrid = that.cachesGrid.data("kendoTGrid"),
      selectedCache = that.ensureSelectedCache();

    if (caches != null) {
      var data = (that.cachesDS.total() == 0) ? [] : null;
      
      $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
        var cacheAttrs = caches[cacheName];
        var entry = { name: cacheName, cacheManagerName: selectedCacheManager, terracottaClustered: cacheAttrs.TerracottaClustered };
        var used = 0;
        var tierIndex;
        
        switch(selectedTier) {
          case "Local Heap":
            entry.sizeInBytes = cacheAttrs.LocalHeapSizeInBytes;
            entry.entries = cacheAttrs.LocalHeapSize;
            used = sizing.localHeap.sizeInBytes;
            tierIndex = 0;
            break;
          case "Local OffHeap":
            entry.sizeInBytes = cacheAttrs.LocalOffHeapSizeInBytes;
            entry.entries = cacheAttrs.LocalOffHeapSize;
            used = sizing.localOffHeap.sizeInBytes;
            tierIndex = 1;
            break;
          case "Local Disk":
            entry.sizeInBytes = cacheAttrs.LocalDiskSizeInBytes;
            entry.entries = cacheAttrs.LocalDiskSize;
            used = sizing.localDisk.sizeInBytes;
            tierIndex = 2;
            break;
        }
        entry.meanEntrySizeInBytes = entry.entries > 0 ? entry.sizeInBytes/entry.entries : 0;
        entry.percentOfUsed = used > 0 ? entry.sizeInBytes/used : 0;
        
        if (data) {
          data.push(entry);
        } else {
          kCachesGrid.updateModel(cacheName, entry);
        }
        
        that.setChartBackgrounds(tierIndex);
      });
      
      if (data) {
        that.cachesDS.data(data);
      }
      
      var axisMax = Math.max(
        usageData[0].value = toMegabytes(sizing.localHeap.sizeInBytes),
        usageData[1].value = toMegabytes(sizing.localOffHeap.sizeInBytes),
        usageData[2].value = toMegabytes(sizing.localDisk.sizeInBytes)
      );
      that.refreshCharts(that.cacheManagerUsageCharts, axisMax + 5);
      
      if (selectedCache = that.ensureSelectedCache()) {
        var cacheUsageData = that.cacheUsageData,
          cacheMissesData = that.cacheMissesData,
          cacheAttrs = caches[selectedCache.name];

        axisMax = Math.max(        
          cacheUsageData[0].value = toMegabytes(cacheAttrs.LocalHeapSizeInBytes),
          cacheUsageData[1].value = toMegabytes(cacheAttrs.LocalOffHeapSizeInBytes),
          cacheUsageData[2].value = toMegabytes(cacheAttrs.LocalDiskSizeInBytes)
        );
        that.refreshCharts(that.cacheUsageCharts, axisMax + 5);
        
        axisMax = Math.max(        
          cacheMissesData[0].value = cacheAttrs.CacheInMemoryMissRate,
          cacheMissesData[1].value = cacheAttrs.CacheOffHeapMissRate,
          cacheMissesData[2].value = cacheAttrs.CacheOnDiskMissRate
        );
        that.refreshCharts(that.cacheMissesCharts, axisMax + 5);
      }
    }
  },
  
  setChartBackgrounds: function(selectedIndex) {
    var _worker = function($charts) {
      $.each($charts, function(index, $chart) {
        var color = index == selectedIndex ? "#EDF5FF" : "#F0F0F0";
        $chart.data("kendoChart").options.valueAxis.plotBands[0].color = color;        
      });
    };
    _worker(this.cacheManagerUsageCharts);
    _worker(this.cacheUsageCharts);
    _worker(this.cacheMissesCharts);
  },
  
  refresh: function() {},

  handleCacheGridSelection: function(e) {
    var model = this.cachesGrid.data("kendoTGrid").getSelection();
    if (model) {
      this.updateCacheCombo(model.name);
    }
  },
  
  handleCacheComboSelection: function() {
    $.xhrPool.suspend();
    var cacheName = this.cacheSelectorCombo.data("kendoComboBox").value();
    this.cachesGrid.data("kendoTGrid").selectModel(cacheName);
    this.updateCacheDescription(cacheName);
    this.fireQueryAttributesChanged();
    $.xhrPool.resume();
  },
  
  updateCacheDescription: function(cacheName) {
    var that = this,
      selectedCacheManager = that.getSelectedCacheManager(),
      cacheManagerAttrs = that.agentPage.cacheManagers[selectedCacheManager],
      description = "";
    
    if (cacheManagerAttrs && cacheManagerAttrs.caches) {
      var cacheAttrs = cacheManagerAttrs.caches[cacheName];
      if (cacheAttrs) {
        var isCacheManagerPooled = cacheManagerAttrs.MaxBytesLocalHeap > 0 ||
          cacheManagerAttrs.MaxBytesLocalOffHeap > 0 ||
          cacheManagerAttrs.MaxBytesLocalDisk > 0;
          
        description = "is entries-based";
        if (isCacheManagerPooled ||
            (cacheAttrs.MaxBytesLocalHeap > 0 ||
             cacheAttrs.MaxBytesLocalOffHeap > 0 ||
             cacheAttrs.MaxBytesLocalDisk > 0)) {
          description = "is ARC-based";
        }
      }
    }
    that.$selectedCacheDescription.text(description);
  },
  
  updateCacheCombo: function(cacheName) {
    this.cacheSelectorCombo.data("kendoComboBox").select(function(dataItem) {
      return dataItem.name === cacheName;
    });
    this.updateCacheDescription(cacheName);
  }
});
