function AgentConfig(agentAttrs) {
  this.agentLocation = agentAttrs.agentLocation;
  this.clientAuthEnabled = agentAttrs.clientAuthEnabled;
  this.connectionTimeoutMillis = agentAttrs.connectionTimeoutMillis != null ? agentAttrs.connectionTimeoutMillis : 5000;
  this.groupId = agentAttrs.groupId;
  this.name = agentAttrs.name;
  this.readTimeoutMillis = agentAttrs.readTimeoutMillis != null ? agentAttrs.readTimeoutMillis : 5000;
  this.sampleHistorySize = agentAttrs.sampleHistorySize;
  this.sampleIntervalSeconds = agentAttrs.sampleIntervalSeconds;
  this.secured = agentAttrs.secured;
}

AgentConfig.prototype = {
  clone: function() {
    return new AgentConfig(this);
  },
  
  getAgentLocation: function() {
    return this.agentLocation;
  },
  
  getConnectionTimeoutMillis: function() {
    return this.connectionTimeoutMillis;
  },
  
  getGroupId: function() {
    return this.groupId;
  },
  
  getId: function() {
    return this.groupId + "_" + this.name;
  },
  
  getName: function() {
    return this.name;
  },
  
  getReadTimeoutMillis: function() {
    return this.readTimeoutMillis;
  },

  /**
   * The following properties are provided and not something the user has any say about.
   */
  
  isClientAuthEnabled: function() {
    return this.clientAuthEnabled;
  },
  
  getSampleHistorySize: function() {
    return this.sampleHistorySize;
  },
  
  getSampleIntervalSeconds: function() {
    return this.sampleIntervalSeconds;
  },
  
  isSecured: function() {
    return this.agentAttrs.secured;
  }
};
