<%@ page import="com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<html>
  <body>
    <div id="confirmChangesWindow" style="display:none">
      <p id="msg">There are unsaved changes. Would you like to save them?</p>
      <div id="controls">
        <button type="button" id="discard" class="k-button">Discard Changes</button>
        <button type="button" id="back" class="k-button">Back</button>
      </div>
    </div>

    <div id="manageConnectionsWindow" class="manageConnectionsForm" style="display:none">
      <div id="content-body-wrapper">
        <div id="content-body">
          <div id="LHS">
            <div id="connection-groups-widget">
              <div class="connectionsHeader">Connection Groups</div>
              <a href="#" class="add" id="addConnectionGroupButton"><div class="icon"></div></a>
    <!-- 		  <a href="#" class="delete" id="deleteConnectionGroupButton"><div class="icon"></div></a> -->
    <!-- 		  <a href="#" class="edit" id="editConnectionGroupButton"><div class="icon"></div></a> -->
              <br style="clear:both;"/>
              <div>
                <div id="connection-group-grid" style="width:100%;"></div>
              </div>
            </div>
            <!-- div class="spacer"></div -->
            <div id="connections-widget">
              <div id="connections-widget-header">
                <div class="connectionsHeader">Connections</div>
                <a href="#" class="add" id="addConnectionButton"><div class="icon"></div></a>
                <br style="clear:both;"/>
              </div>
              <div id="connection-grid"></div>
            </div>
          </div>
          <div id="RHS">
            <div id="instructions">
              <p>This screen is for managing the connections that will be known to The Terracotta Management Console.</p>
              <p>Connections to Terracotta products, such as Ehcache, are divided among the set of connection groups
                 that you define.  Connection groups can be useful for organizing sets of related connections - such
                 as those in the same deployment environment.</p>
              <br>
              <p>Using the Connection Groups widget you can:
                <ul>
                  <li>Add a new connection group</li>
                  <li>Delete a connection group and all of its contained connections</li>
                  <li>Rename an existing connection group</li>
                </ul>
              </p>
              <p>When a connection group is selected, its set of contained connections is presented in the Connections grid.</p>
              <br>
              <p>Using the Connections widget you can:
                <ul>
                  <li>Add a new connection within the selected group</li>
                  <li>Delete the selected connection</li>
                  <li>Edit an existing connection by selecting it in the Connections grid</li>
                </ul>
              </p>
            </div>
          </div>
        </div>
      </div>
      <div id="controls">
        <button type="button" id="closeManageConnectionsWindow" class="k-button">Close</button>
      </div>
    </div>

    <div id="connectionPanel" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Connection Details</legend>
        <label for="connectionGroup">Group
          <span class="small">Change connection group</span>
        </label>
        <select id="groupId" name="groupId">
        </select>

        <label for="id">Name
          <span class="small">Enter a unique name for the connection</span>
        </label>
        <input type="text" name="name" id="name" value="MyConnection"/>

        <label for="agentLocation">Location
          <span class="small">Enter the connection end-point (URL)</span>
        </label>
        <input type="text" name="agentLocation" id="agentLocation" value="http://localhost:9888"/>

        <label for="connectionTimeoutMillis">Connection Timeout
          <span class="small">Enter the connection timeout millis</span>
        </label>
        <input type="text" name="connectionTimeoutMillis" id="connectionTimeoutMillis" value="5000"/>

        <label for="readTimeoutMillis">Read Timeout
          <span class="small">Enter the read timeout millis</span>
        </label>
        <input type="text" name="readTimeoutMillis" id="readTimeoutMillis" value="5000"/>

        <div id="foo-controls">
          <button type="button" id="apply" class="k-button hideable">Apply</button>
         <!-- <button type="button" id="revert" class="k-button hideable">Revert</button> -->
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="connectionGroupPanelDisplay" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Connection Group Details</legend>

        <label for="id">Connection Group Name:</label>
        <span name="group" id="group"></span><br/><br/>

        <div id="foo-controls">
          <button type="button" id="edit" class="k-button">Edit</button>
          <button type="button" id="delete" class="k-button">Delete</button>
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="connectionPanelDisplay" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Connection Details</legend>
        <label for="connectionGroup">Group:</label>
        <span id="groupId" name="groupId"></span><br/><br/>

        <label for="id">Connection name:</label>
        <span name="name" id="name"></span><br/><br/>

        <label for="agentLocation">Connection location (URL):</label>
        <span name="agentLocation" id="agentLocation">url</span><br/><br/>
        
        <label for="security">Security Enabled: </label>
        <span name="security" id="security" class="securityOff">No</span><br/><br/>

        <label for="connectionTimeoutMillis">Connection Timeout:</label>
        <span name="connectionTimeoutMillis" id="connectionTimeoutMillis"> connectionTimeoutMillis</span><br/><br/>

        <label for="readTimeoutMillis">Read Timeout:</label>
        <span name="readTimeoutMillis" id="readTimeoutMillis">readTimeoutMillis</span><br/><br/>

        <div id="foo-controls">
          <button type="button" id="edit" class="k-button">Edit</button>
          <button type="button" id="delete" class="k-button">Delete</button>
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="deleteConnectionPanel" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Delete Connection</legend>
        <p id="msg">Really delete connection</p>
        <div id="foo-controls">
          <button type="button" id="ok" class="k-button">OK</button>
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="addConnectionGroupPanel" class="connectionForm" style="display:none">
      <fieldset>
        <legend>New Connection Group</legend>
        <label for="group">Name
          <span class="small">Enter unique connection group name.</span>
        </label>
        <input type="text" name="group" id="group" value="MyConnectionGroup"/>
        <div id="foo-controls">
          <button type="button" id="apply" class="k-button">Apply</button>
         <!-- <button type="button" id="revert" class="k-button">Revert</button> -->
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="editConnectionGroupPanel" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Rename Connection Group</legend>
        <label for="group">New Name
          <span class="small">Enter unique connection group name</span>
        </label>
        <input type="text" name="group" id="group" value="MyConnectionGroup"/>
        <div id="foo-controls">
          <button type="button" id="apply" class="k-button hideable">Apply</button>
          <!--<button type="button" id="revert" class="k-button hideable">Revert</button>-->
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>

    <div id="deleteConnectionGroupPanel" class="connectionForm" style="display:none">
      <fieldset>
        <legend>Delete Connection Group</legend>
        <p id="msg">Really delete group</p>
        <div id="foo-controls">
          <button type="button" id="ok" class="k-button">OK</button>
          <button type="button" id="cancel" class="k-button">Cancel</button>
        </div>
      </fieldset>
    </div>
  </body>
</html>
