/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import com.terracotta.license.LicenseManager;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.TMSServiceLocator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.terracotta.license.LicenseException;

public final class SetupAwareFilter
implements Filter {
    private static final String TMC_HOME = "/index.jsp";
    private static final String TMC_LOGOUT_URL = "/logout.jsp";
    private SecurityContextManager securityCtxtMgr;

    public SetupAwareFilter() {
        TMSServiceLocator securityCtxtMgrLocator = TMSServiceLocator.locator();
        this.securityCtxtMgr = securityCtxtMgrLocator.locateSecurityContextManager();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (TMSEnvironmentLoaderListener.HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                TMSEnvironmentLoaderListener.HAS_LICENSE = true;
                TMSEnvironmentLoaderListener.LICENSE_IS_TRIAL_LICENSE = LicenseManager.isTrialLicense();
            }
            catch (LicenseException e) {
                TMSEnvironmentLoaderListener.HAS_LICENSE = false;
            }
        }
        if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue()) {
            boolean ctxtValid = this.securityCtxtMgr.hasValidSecurityContext();
            if (!ctxtValid && req.getRequestURI().startsWith(req.getContextPath() + "/login.jsp")) {
                RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher("/setup/accountSetup.jsp");
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            } else if (ctxtValid && req.getRequestURI().startsWith(req.getContextPath() + "/setup")) {
                resp.sendRedirect(req.getContextPath() + "/login.jsp");
            } else {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        } else if (req.getRequestURI().equals(req.getContextPath() + "/login.jsp") || req.getRequestURI().equals(req.getContextPath() + "/setup/accountSetup.jsp") || req.getRequestURI().equals(req.getContextPath() + TMC_LOGOUT_URL)) {
            resp.sendRedirect(req.getContextPath() + TMC_HOME);
        } else {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public void destroy() {
    }
}

