/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AdServlet.class);
    private static final String AD_LIST_LOCATION_PARAM_NAME = "adListUrl";
    private static final String AD_LIST_LOCATION = "http://www.terracotta.org/tmc/tmcadlist-1.0.0_tp2.txt";
    private static final String DEFAULT_AD = "/tcinfo.html";
    private static final long AD_CHECK_INTERVAL = 3600000L;
    private String adListLocation;
    private long lastAdCheck = -1L;
    private int adOn = 0;
    private List<String> adURLs;
    private List<String> theAds;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.adListLocation = config.getInitParameter(AD_LIST_LOCATION_PARAM_NAME);
        if (this.adListLocation == null) {
            this.adListLocation = AD_LIST_LOCATION;
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.theAds == null || System.currentTimeMillis() - this.lastAdCheck > 3600000L) {
            this.lastAdCheck = System.currentTimeMillis();
            this.loadAds();
        }
        if (this.theAds != null && !this.theAds.isEmpty()) {
            int adToServe = this.adOn++ % this.theAds.size();
            LOG.info("Serving ad #" + (adToServe + 1));
            response.getWriter().print((String)this.theAds.get(adToServe));
            response.getWriter().flush();
            response.flushBuffer();
        } else {
            LOG.info("Serving default ad");
            this.getServletContext().getRequestDispatcher(DEFAULT_AD).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doHead(request, response);
    }

    protected long getLastModified(HttpServletRequest req) {
        return System.currentTimeMillis();
    }

    protected boolean loadAdList() {
        LOG.debug("Checking for available ads...");
        String rawAdList = this.getURLContentAsString(this.adListLocation);
        if (rawAdList != null) {
            String[] adList = rawAdList.split("\n");
            LinkedList<String> newAdList = new LinkedList<String>();
            for (String adUrl : adList) {
                if ((adUrl = adUrl.trim()).length() > 0 && adUrl.startsWith("#") || (adUrl.length() <= 8 || !adUrl.startsWith("http://")) && !adUrl.startsWith("https://")) continue;
                newAdList.add(adUrl);
                LOG.debug("Found ad location: " + adUrl);
            }
            if (!newAdList.isEmpty()) {
                this.adURLs = newAdList;
                LOG.info("Found " + this.adURLs.size() + " ad URLs");
                return true;
            }
        } else {
            LOG.debug("List of ads not available.");
            this.adURLs = Collections.emptyList();
            this.theAds = Collections.emptyList();
        }
        return false;
    }

    protected void loadAds() {
        if (this.loadAdList()) {
            this.theAds = new LinkedList();
            for (String adUrl : this.adURLs) {
                String ad = this.getURLContentAsString(adUrl);
                if (ad != null && (ad = ad.trim()).length() > 0) {
                    this.theAds.add(ad);
                    LOG.info("Loaded ad from location: " + adUrl);
                    continue;
                }
                LOG.info("No content found at ad location: " + adUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getURLContentAsString(String url) {
        HttpURLConnection connection = null;
        BufferedReader rd = null;
        StringBuilder sb = null;
        String line = null;
        try {
            URL adAddress = new URL(url);
            connection = (HttpURLConnection)adAddress.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(10000);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                sb = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                LOG.info("Fetched url: " + url);
                String string = sb.toString();
                return string;
            }
            LOG.info("Could not fetch ad from " + this.adListLocation + " -- got HTTP response code: " + connection.getResponseCode());
            String string = null;
            return string;
        }
        catch (Exception e) {
            LOG.info("Error fetching url: " + url, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                connection.disconnect();
            }
            catch (Exception ignore) {}
            rd = null;
            sb = null;
            connection = null;
        }
    }
}

