/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.terracotta.management.config.Agent;
import com.terracotta.management.config.Config;
import com.terracotta.management.services.ConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observer;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;

public final class FileConfigService
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigService.class);
    private static final File DFLT_CONFIG_FILE = new File(System.getProperty("user.home") + "/.tc/mgmt/config.xml");
    private final File configFile;
    private final Config config;

    public FileConfigService() {
        String configProp = System.getProperty("com.tc.management.config");
        this.configFile = configProp == null ? DFLT_CONFIG_FILE : new File(configProp);
        String templateConfigFileName = System.getProperty("com.tc.management.config.tmplt", "templateConfig.xml");
        this.createConfigFromTemplateIfNotExists(templateConfigFileName, this.configFile);
        Config lConfig = null;
        try {
            lConfig = this.loadConfigFromFile(this.configFile);
        }
        catch (IOException e) {
            LOG.warn("Config file not found.  Creating empty one.");
        }
        this.config = lConfig == null ? new Config() : lConfig;
    }

    void createConfigFromTemplateIfNotExists(String tmpltConfigFileName, File cfgFile) {
        if (!cfgFile.exists()) {
            LOG.info("Config file does not exists.  Creating one from template: " + tmpltConfigFileName);
            try {
                this.copyConfigFileFromClassPathResource(tmpltConfigFileName, cfgFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to copy template config.", (Throwable)e);
            }
        }
    }

    public Agent getAgent(String agentId) {
        return this.config.getAgent(agentId);
    }

    public Collection<Agent> getAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Set groups = this.config.getGroups();
        for (String group : groups) {
            Collection agentsByGroup = this.getAgentsByGroup(group);
            agents.addAll(agentsByGroup);
        }
        return agents;
    }

    public Collection<Agent> getAgentsByGroup(String groupId) {
        return this.config.getAgentsByGroup(groupId);
    }

    public Collection<String> getGroups() {
        return this.config.getGroups();
    }

    public boolean addGroup(String groupId) {
        return this.config.addGroup(groupId);
    }

    public boolean deleteGroup(String groupId) {
        return this.config.deleteGroup(groupId);
    }

    public boolean renameGroup(String oldGroupId, String newGroupId) {
        return this.config.renameGroup(oldGroupId, newGroupId);
    }

    public void deleteAgent(String agentId) {
        this.config.deleteAgent(agentId);
    }

    public boolean addAgent(Agent agent) {
        return this.config.addAgent(agent);
    }

    public boolean updateAgent(String agentId, Agent agent) {
        return this.config.updateAgent(agentId, agent);
    }

    public boolean saveConfig() throws ServiceExecutionException {
        boolean success = false;
        try {
            this.storeConfigInFile(this.config, this.configFile);
        }
        catch (IOException e) {
            throw new ServiceExecutionException("Failed to save config file.", (Throwable)e);
        }
        catch (JAXBException e) {
            throw new ServiceExecutionException("Failed to serialize config.", (Throwable)e);
        }
        return success;
    }

    public void registerObserver(Observer observer) {
        this.config.addObserver(observer);
    }

    void storeConfigInFile(Config cfg, File cfgFile) throws IOException, JAXBException {
        boolean existingConfig = cfgFile.exists();
        File backFile = new File(cfgFile.getAbsolutePath() + "_tmp" + System.currentTimeMillis());
        if (existingConfig) {
            LOG.debug("Backing up config to: '" + backFile.getAbsolutePath() + "'");
            this.copyConfigFile(cfgFile, backFile);
            if (!cfgFile.delete()) {
                throw new IOException("Unable to delete existing configFile '" + cfgFile + "'");
            }
        } else if (!cfgFile.getParentFile().exists() && !cfgFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create path '" + cfgFile.getParentFile() + "'");
        }
        LOG.info("Writing config to: '" + cfgFile.getAbsolutePath() + "'");
        Config.write((Config)cfg, (File)cfgFile);
        if (existingConfig) {
            LOG.debug("Removing back up config: '" + backFile.getAbsolutePath() + "'");
            if (!backFile.delete()) {
                throw new IOException("Unable to delete backup file '" + backFile + "'");
            }
        }
    }

    Config loadConfigFromFile(File src) throws IOException {
        if (src.exists()) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(src);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failure loading configuration file: " + src.getAbsolutePath(), e);
            }
            return this.loadConfigFromInputStream((InputStream)fis);
        }
        return null;
    }

    Config loadConfigFromInputStream(InputStream src) throws IOException {
        try {
            Config config = Config.load((InputStream)src);
            return config;
        }
        catch (JAXBException e) {
            throw new IOException("Failure loading configuration input stream.", e);
        }
        finally {
            try {
                src.close();
            }
            catch (IOException e1) {
                LOG.warn("Failed to close config file input stream.", (Throwable)e1);
            }
        }
    }

    private void copyConfigFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.exists()) {
            throw new IOException("Source file for copy " + sourceFile.getAbsolutePath() + " does not exist.");
        }
        try {
            Config tmpltConfig = this.loadConfigFromFile(sourceFile);
            this.storeConfigInFile(tmpltConfig, destFile);
        }
        catch (JAXBException e) {
            throw new IOException("Error serializing template config", e);
        }
    }

    private void copyConfigFileFromClassPathResource(String resourceName, File destFile) throws IOException {
        InputStream src = FileConfigService.class.getClassLoader().getResourceAsStream(resourceName);
        try {
            Config tmpltConfig = this.loadConfigFromInputStream(src);
            this.storeConfigInFile(tmpltConfig, destFile);
        }
        catch (JAXBException e) {
            throw new IOException("Error serializing template config", e);
        }
    }
}

