/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.shiro;

import com.sun.jersey.api.client.filter.ClientFilter;
import com.terracotta.license.LicenseManager;
import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.resource.services.validator.impl.AggregateEhcacheRequestValidator;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.impl.DfltRequestTicketMonitor;
import com.terracotta.management.security.impl.DfltSSLContextFactory;
import com.terracotta.management.security.impl.NoSecurityContextAuthorizer;
import com.terracotta.management.security.impl.ObfuscatedSecretFileStoreKeyChainAccessor;
import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.security.services.impl.IniFileSetupService;
import com.terracotta.management.security.shiro.ShiroAuthorizer;
import com.terracotta.management.security.shiro.ShiroSecurityContextManager;
import com.terracotta.management.security.shiro.realm.TCIniRealm;
import com.terracotta.management.security.web.impl.LicensedIdentityAsserter;
import com.terracotta.management.security.web.impl.NoOpIdentityAsserter;
import com.terracotta.management.security.web.jersey.TMSRequestClientFilter;
import com.terracotta.management.security.web.jersey.TMSRequestSecurityClientFilter;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.JerseyClientFactory;
import com.terracotta.management.services.ResourceServiceClientService;
import com.terracotta.management.services.TMSServiceLocator;
import com.terracotta.management.services.impl.DfltJerseyClientFactory;
import com.terracotta.management.services.impl.FileConfigService;
import com.terracotta.management.services.impl.JerseyResourceServiceClientService;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.dao.impl.IniFileUserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfoFactory;
import com.terracotta.management.user.services.UserService;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.dao.impl.XMLFileUserProfileDao;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletContextEvent;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.LicenseException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.validator.RequestValidator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class TMSEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    public static Boolean HAS_LICENSE;
    public static Boolean LICENSE_IS_TRIAL_LICENSE;
    private static final Logger LOG;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        XMLFileUserProfileDao usrProfileDao;
        this.checkLicense();
        FileConfigService configSvc = new FileConfigService();
        DfltUserInfoFactory usrInfoFactory = new DfltUserInfoFactory();
        try {
            usrProfileDao = new XMLFileUserProfileDao();
        }
        catch (IOException e) {
            throw new RuntimeException("Failure instantiating TMS context because user profile datasource could not be found or initialized.", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failure instantiating TMS context due to invalid user profile data format.", e);
        }
        if (HAS_LICENSE.booleanValue()) {
            this.initEnvironment(servletContextEvent.getServletContext());
            this.loadLicensedCtxt((ConfigService)configSvc, (UserInfoFactory)usrInfoFactory, (UserProfileDao)usrProfileDao, servletContextEvent);
        } else {
            this.loadUnlicensedCtxt((ConfigService)configSvc, (UserInfoFactory)usrInfoFactory, (UserProfileDao)usrProfileDao);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (HAS_LICENSE.booleanValue()) {
            this.destroyEnvironment(servletContextEvent.getServletContext());
        }
    }

    private void checkLicense() {
        if (HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                HAS_LICENSE = true;
                LICENSE_IS_TRIAL_LICENSE = LicenseManager.isTrialLicense();
            }
            catch (LicenseException e) {
                HAS_LICENSE = false;
            }
        }
    }

    private void loadLicensedCtxt(ConfigService configSvc, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao, ServletContextEvent sce) {
        ShiroSecurityContextManager secCtxtMgr;
        ObfuscatedSecretFileStoreKeyChainAccessor keyChainAccessor;
        ShiroAuthorizer authorizer = new ShiroAuthorizer();
        DfltRequestTicketMonitor monitor = new DfltRequestTicketMonitor();
        try {
            keyChainAccessor = new ObfuscatedSecretFileStoreKeyChainAccessor();
        }
        catch (KeychainInitializationException e) {
            throw new RuntimeException("Failure instantiating a licensed TMS (security enabled) due to invalid keychain configuration.", e);
        }
        DfltSSLContextFactory sslCtxtFactory = null;
        if (this.isSSLEnabledForIA()) {
            LOG.info("IdentityAssertion will use SSL");
            sslCtxtFactory = new DfltSSLContextFactory((KeyChainAccessor)keyChainAccessor, System.getProperty("user.home") + "/.tc/mgmt/tms-keystore", System.getProperty("user.home") + "/.tc/mgmt/tms-truststore");
        }
        TMSRequestSecurityClientFilter clientFilter = new TMSRequestSecurityClientFilter((RequestTicketMonitor)monitor, (KeyChainAccessor)keyChainAccessor);
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)clientFilter, sslCtxtFactory);
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService(configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        try {
            secCtxtMgr = new ShiroSecurityContextManager(new IniFileUserInfoDao(), this.getInitializedTCIniRealm(sce));
        }
        catch (DataAccessException e) {
            throw new RuntimeException("Failure instantiating TMS context because user info datasource could not be found or initialized.", e);
        }
        IniFileSetupService secCtxtSetupSvc = new IniFileSetupService((UserService)secCtxtMgr, usrInfoFactory);
        LicensedIdentityAsserter idAsserter = new LicensedIdentityAsserter((Authorizer)authorizer, (RequestTicketMonitor)monitor, (UserService)secCtxtMgr, (KeyChainAccessor)keyChainAccessor);
        ServiceLocator.load((ServiceLocator)new TMSServiceLocator((RequestValidator)new AggregateEhcacheRequestValidator((Authorizer)authorizer), configSvc, (ResourceServiceClientService)rsrcSvcClientSvc, usrProfileDao, (Authorizer)authorizer, (RequestIdentityAsserter)idAsserter, (SecurityContextManager)secCtxtMgr, (SecurityContextSetupService)secCtxtSetupSvc));
    }

    private void loadUnlicensedCtxt(ConfigService configSvc, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao) {
        NoSecurityContextAuthorizer authorizer = new NoSecurityContextAuthorizer();
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)new TMSRequestClientFilter(), null);
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService(configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        NoOpIdentityAsserter idAsserter = new NoOpIdentityAsserter(usrInfoFactory);
        ServiceLocator.load((ServiceLocator)new TMSServiceLocator((RequestValidator)new AggregateEhcacheRequestValidator((Authorizer)authorizer), configSvc, (ResourceServiceClientService)rsrcSvcClientSvc, usrProfileDao, (Authorizer)authorizer, (RequestIdentityAsserter)idAsserter, null, null));
    }

    private TCIniRealm getInitializedTCIniRealm(ServletContextEvent sce) {
        TCIniRealm tcIniRealm = null;
        WebEnvironment env = (WebEnvironment)sce.getServletContext().getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        Collection realms = ((RealmSecurityManager)env.getWebSecurityManager()).getRealms();
        for (Realm r : realms) {
            if (!(r instanceof TCIniRealm)) continue;
            tcIniRealm = (TCIniRealm)r;
            break;
        }
        if (tcIniRealm == null) {
            throw new RuntimeException("Failure instantiating TMS context. Failure to find expected security realm.");
        }
        return tcIniRealm;
    }

    public boolean isSSLEnabledForIA() {
        String property = System.getProperty("tms.ia.useSSL");
        if (property != null) {
            return "true".equals(property);
        }
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse("etc/jetty.xml");
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/Configure/Call[contains(@name,'addConnector')]/Arg/New[contains(@class,'org.eclipse.jetty.server.ssl.SslSelectChannelConnector')]/Arg/New/Set[contains(@name,'needClientAuth')]");
            Object needClientAuthTags = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)needClientAuthTags;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!"true".equals(nodes.item(i).getTextContent())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Could not find out whether the Identity Assertion is using SSL or not, not using SSL then. " + e.getMessage());
        }
        return false;
    }

    static {
        LOG = LoggerFactory.getLogger(TMSEnvironmentLoaderListener.class);
    }
}

