/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.resource.services;

import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.services.TMSServiceLocator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/assertIdentity")
public final class IdentityAssertionResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityAssertionResourceService.class);
    private final RequestIdentityAsserter idAsserter;

    public IdentityAssertionResourceService() {
        TMSServiceLocator reqIdAsserterLocator = TMSServiceLocator.locator();
        this.idAsserter = reqIdAsserterLocator.locateRequestIdentityAsserter();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIdentity(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        try {
            return Response.ok((Object)this.idAsserter.assertIdentity(request, response)).build();
        }
        catch (Exception e) {
            LOG.error("Identity assertion failure!", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }
}

