/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.license;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseManager.class);
    public static final String EXIT_MESSAGE = "TERRACOTTA IS EXITING. Contact your Terracotta sales representative to learn how to enable licensed usage of this feature. For more information, visit Terracotta support at http://www.terracotta.org.";
    public static final String EXPIRY_WARNING = "Your license key is valid until %s. You have %s remaining until the expiration date. When the expiration date is reached TERRACOTTA WILL CEASE FUNCTIONING.";
    public static final String EXPIRED_ERROR = "Your product key expired on %s. TERRACOTTA IS EXITING. Contact your Terracotta sales representative to learn how to enable licensed usage of this feature. For more information, visit Terracotta support at http://www.terracotta.org.";
    private static volatile boolean initialized;
    private static License license;
    private static final AbstractLicenseResolverFactory factory;
    private static boolean warnedAboutMissingLicense;

    private static synchronized void init() {
        license = factory.resolveLicense();
        initialized = true;
        if (license != null) {
            LOG.info("Terracotta license loaded from " + factory.getLicenseLocation() + "\n" + license.toString());
        }
    }

    public static synchronized License getLicense() {
        if (!initialized) {
            LicenseManager.init();
        }
        return license;
    }

    public static void assertValidLicense() {
        boolean expiredOrMissing = false;
        if (LicenseManager.getLicense() == null) {
            if (!warnedAboutMissingLicense) {
                LOG.info("Terracotta license key is required for Enterprise capabilities. Please place terracotta-license.key in the Terracotta installation directory or in the resource path. You can also specify it as a system property with -Dcom.tc.productkey.path=/path/to/key");
                warnedAboutMissingLicense = true;
            }
            expiredOrMissing = true;
        } else {
            Date expirationDate = LicenseManager.getLicense().expirationDate();
            if (expirationDate != null && expirationDate.before(new Date())) {
                LOG.error("Your Terracotta license has expired on " + expirationDate);
                expiredOrMissing = true;
            }
        }
        if (expiredOrMissing) {
            throw new LicenseException();
        }
    }

    private static void verifyCapability(String capability) {
        LicenseManager.assertValidLicense();
        if (!LicenseManager.getLicense().isCapabilityEnabled(capability)) {
            throw new LicenseException("Your license key doesn't allow usage of '" + capability + "' capability");
        }
    }

    public static boolean isTrialLicense() {
        LicenseManager.assertValidLicense();
        return LicenseManager.getLicense().type().equals("Trial");
    }

    public static void verifyTMCCapability() {
        LicenseManager.verifyCapability((String)"TMC");
    }

    static {
        factory = AbstractLicenseResolverFactory.getFactory();
        warnedAboutMissingLicense = false;
    }
}

