/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.services;

import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.validator.RequestValidator;

/**
 * @author brandony
 */
public final class TMSServiceLocator extends ServiceLocator
    implements ConfigService.Locator, ResourceServiceClientService.Locator, Authorizer.Locator,
    RequestIdentityAsserter.Locator, UserProfileDao.Locator,
    SecurityContextManager.Locator, SecurityContextSetupService.Locator {

  private final ConfigService configSvc;

  private final ResourceServiceClientService rsrcSvcClientSvc;

  private final Authorizer authorizer;

  private final RequestIdentityAsserter reqIdAsserter;

  private final UserProfileDao usrProfileDao;

  private final SecurityContextSetupService secCtxtSetupSvc;

  private final SecurityContextManager secCtxtMgr;

  public static TMSServiceLocator locator() {
    return (TMSServiceLocator) ServiceLocator.locator();
  }

  public TMSServiceLocator(RequestValidator requestValidator,
                           ConfigService configSvc,
                           ResourceServiceClientService rsrcSvcClientSvc,
                           UserProfileDao usrProfileDao,
                           Authorizer authorizer,
                           RequestIdentityAsserter reqIdAsserter,
                           SecurityContextManager secCtxtMgr,
                           SecurityContextSetupService secCtxtSetupSvc) {
    super(requestValidator);
    this.configSvc = configSvc;
    this.rsrcSvcClientSvc = rsrcSvcClientSvc;
    this.usrProfileDao = usrProfileDao;
    this.authorizer = authorizer;
    this.reqIdAsserter = reqIdAsserter;
    this.secCtxtMgr = secCtxtMgr;
    this.secCtxtSetupSvc = secCtxtSetupSvc;
  }

  @Override
  public ConfigService locateConfigService() {
    return configSvc;
  }

  @Override
  public Authorizer locateAuthorizer() {
    return authorizer;
  }

  @Override
  public ResourceServiceClientService locateResourceServiceClientService() {
    return rsrcSvcClientSvc;
  }

  @Override
  public RequestIdentityAsserter locateRequestIdentityAsserter() {
    return reqIdAsserter;
  }

  @Override
  public UserProfileDao locateUserProfileDao() {
    return usrProfileDao;
  }

  @Override
  public SecurityContextSetupService locateSecurityContextSetupService() {
    return secCtxtSetupSvc;
  }

  @Override
  public SecurityContextManager locateSecurityContextManager() {
    return secCtxtMgr;
  }
}
