/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.services.AgentsResourceService;

import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;

/**
 * <p>
 * An aggregate implementation of {@link AgentsResourceService}.
 * </p>
 *
 * @author brandony
 */
@Path("/agents")
public final class AggregateAgentsResourceService extends AggregateResourceServiceSupport<AgentEntity>
    implements AgentsResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateAgentsResourceService.class);

  public AggregateAgentsResourceService() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Collection<AgentEntity> getAgents(UriInfo info) {
    LOG.info(String.format("Executing AggregateAgentsResourceService.getAgents: %s", info.getRequestUri()));
    getValidator().validateSafe(info);
    AggregateCollectionCallback<AgentEntity> callback = new AggregateCollectionCallback<AgentEntity>() {/**/
    };

    return doGet(info, callback, AgentEntity.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Collection<AgentMetadataEntity> getAgentsMetadata(UriInfo info) {
    LOG.info(String.format("Invoking AggregateAgentsResourceService.getAgentsMetadata: %s", info.getRequestUri()));
    getValidator().validateSafe(info);
    String agentIds = info.getPathSegments().get(0).getMatrixParameters().getFirst(ResourceServiceUtils.AGENT_IDS_KEY);
    if (agentIds != null) throw new WebApplicationException(
        Response.status(Response.Status.BAD_REQUEST).entity("Cannot use ids matrix parameter on /agents/info").build());

    String path = info.getPath();

    AgentMetadataEntityCollectionCallback callback = new AgentMetadataEntityCollectionCallback(
        getSvcClientSvc().getKnownAgentIds());

    try {
      getSvcClientSvc().proxyGet(callback, new URI(path), null, AgentMetadataEntity.class);
    } catch (URISyntaxException e) {
      throw new RuntimeException("Bug Alert! Bad path URI from jersey.", e);
    }

    return callback.calculateResult();
  }
}
