/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.config.jaxb.adapters;

import com.terracotta.management.config.Agent;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Ludovic Orban
 */
public final class AgentMapAdapter extends XmlAdapter<AdaptedAgentsMap, Map<String, Collection<Agent>>> {

  @Override
  public Map<String, Collection<Agent>> unmarshal(AdaptedAgentsMap v) throws Exception {
    Map<String, Collection<Agent>> result = new HashMap<String, Collection<Agent>>();

    List<AdaptedGroup> entries = v.getGroups();
    for (AdaptedGroup entry : entries) {
      result.put(entry.getId(), entry.getAgents() == null ? new ArrayList<Agent>() : entry.getAgents());
    }

    return result;
  }

  @Override
  public AdaptedAgentsMap marshal(Map<String, Collection<Agent>> v) throws Exception {
    AdaptedAgentsMap result = new AdaptedAgentsMap();

    Set<Map.Entry<String, Collection<Agent>>> entries = v.entrySet();
    for (Map.Entry<String, Collection<Agent>> entry : entries) {
      result.addGroup(entry.getKey(), entry.getValue());
    }

    return result;
  }
}
