/*
 * Decompiled with CFR 0.152.
 */
package com.bigmemory.samples.search;

import com.bigmemory.commons.model.Person;
import com.bigmemory.commons.util.ReadUtil;
import java.io.IOException;
import java.io.Serializable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Direction;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.aggregator.Aggregator;
import net.sf.ehcache.search.aggregator.Aggregators;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.AttributeExtractorException;

public class BigMemorySearch {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Configuration managerConfig = new Configuration().cache(new CacheConfiguration().name("bm-sample").eternal(true).maxBytesLocalHeap(128L, MemoryUnit.MEGABYTES).maxBytesLocalOffHeap(1L, MemoryUnit.GIGABYTES).searchable(new Searchable().searchAttribute(new SearchAttribute().name("age")).searchAttribute(new SearchAttribute().name("gender").expression("value.getGender()")).searchAttribute(new SearchAttribute().name("state").expression("value.getAddress().getState()")).searchAttribute(new SearchAttribute().name("name").className(NameAttributeExtractor.class.getName()))));
        CacheManager manager = CacheManager.create((Configuration)managerConfig);
        Ehcache bm = manager.getEhcache("bm-sample");
        try {
            BigMemorySearch.loadCache(bm);
            Attribute age = bm.getSearchAttribute("age");
            Attribute gender = bm.getSearchAttribute("gender");
            Attribute name = bm.getSearchAttribute("name");
            Attribute state = bm.getSearchAttribute("state");
            Query query = bm.createQuery();
            query.includeKeys();
            query.includeValues();
            query.addCriteria(name.ilike("Jul*").and(gender.eq((Object)Person.Gender.FEMALE))).addOrderBy(age, Direction.ASCENDING).maxResults(10);
            System.out.println("**** Searching for all Person's who's name start with Jul and are Female: ****");
            Results results = query.execute();
            System.out.println(" Size: " + results.size());
            System.out.println("----Results-----\n");
            for (Result result : results.all()) {
                System.out.println("Got: Key[" + result.getKey() + "] Value class [" + result.getValue().getClass() + "] Value [" + result.getValue() + "]");
            }
            ReadUtil.waitForInput();
            System.out.println("**** Adding another female Julie ****");
            bm.put(new Element((Serializable)Integer.valueOf(1), (Serializable)new Person("Julie Smith", 36, Person.Gender.FEMALE, "eck street", "San Mateo", "CA")));
            System.out.println("**** Again Searching for all Person's who's name start with Jul and are Female: ****");
            results = query.execute();
            System.out.println(" Size: " + results.size());
            ReadUtil.waitForInput();
            System.out.println("**** Find the average age of all the entries ****");
            Query averageAgeQuery = bm.createQuery();
            averageAgeQuery.includeAggregator(new Aggregator[]{Aggregators.average((Attribute)age)});
            System.out.println("Average age: " + ((Result)averageAgeQuery.execute().all().iterator().next()).getAggregatorResults());
            ReadUtil.waitForInput();
            System.out.println("**** Find the average age of all people between 30 and 40 ****");
            Query agesBetween = bm.createQuery();
            agesBetween.addCriteria(age.between((Object)30, (Object)40));
            agesBetween.includeAggregator(new Aggregator[]{Aggregators.average((Attribute)age)});
            System.out.println("Average age between 30 and 40: " + ((Result)agesBetween.execute().all().iterator().next()).getAggregatorResults());
            ReadUtil.waitForInput();
            System.out.println("**** Find the count of people from NJ ****");
            Query newJerseyCountQuery = bm.createQuery().addCriteria(state.eq((Object)"NJ"));
            newJerseyCountQuery.includeAggregator(new Aggregator[]{Aggregators.count()});
            System.out.println("Count of people from NJ: " + ((Result)newJerseyCountQuery.execute().all().iterator().next()).getAggregatorResults());
        }
        finally {
            if (manager != null) {
                manager.shutdown();
            }
        }
    }

    private static void loadCache(Ehcache bm) {
        bm.put(new Element((Serializable)Integer.valueOf(1), (Serializable)new Person("Jane Doe", 35, Person.Gender.FEMALE, "eck street", "San Mateo", "CA")));
        bm.put(new Element((Serializable)Integer.valueOf(2), (Serializable)new Person("Marie Antoinette", 23, Person.Gender.FEMALE, "berry st", "Parsippany", "LA")));
        bm.put(new Element((Serializable)Integer.valueOf(3), (Serializable)new Person("John Smith", 25, Person.Gender.MALE, "big wig", "Beverly Hills", "NJ")));
        bm.put(new Element((Serializable)Integer.valueOf(4), (Serializable)new Person("Paul Dupont", 45, Person.Gender.MALE, "cool agent", "Madison", "WI")));
        bm.put(new Element((Serializable)Integer.valueOf(5), (Serializable)new Person("Juliet Capulet", 30, Person.Gender.FEMALE, "dah man", "Bangladesh", "MN")));
        for (int i = 6; i < 1000; ++i) {
            bm.put(new Element((Serializable)Integer.valueOf(i), (Serializable)new Person("Juliet Capulet" + i, 30, Person.Gender.MALE, "dah man", "Bangladesh", "NJ")));
        }
    }

    public static class NameAttributeExtractor
    implements AttributeExtractor {
        public Object attributeFor(Element element) {
            return ((Person)element.getObjectValue()).getName();
        }

        public Object attributeFor(Element element, String arg1) throws AttributeExtractorException {
            return this.attributeFor(element);
        }
    }
}

