/*
 * Decompiled with CFR 0.152.
 */
package com.bigmemory.samples.cache;

import com.bigmemory.commons.model.Person;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;

public class BigMemoryAsACacheConfiguration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Configuration managerConfiguration = new Configuration();
        managerConfiguration.updateCheck(true).monitoring(Configuration.Monitoring.AUTODETECT).name("cacheManagerCompleteExample").addCache(new CacheConfiguration().name("sample-cache").maxBytesLocalHeap(128L, MemoryUnit.MEGABYTES).maxBytesLocalOffHeap(1L, MemoryUnit.GIGABYTES).timeToLiveSeconds(4L).timeToIdleSeconds(2L));
        CacheManager manager = CacheManager.create((Configuration)managerConfiguration);
        try {
            System.out.println("**** BigMemory as a cache - configuration ****");
            Cache testCache = manager.getCache("sample-cache");
            System.out.println("**** Add value for key 1 to pamelaJones ****");
            Person pamelaJones = new Person("Pamela Jones", 23, Person.Gender.FEMALE, "berry st", "Parsippany", "LA");
            Element element = new Element((Serializable)((Object)"1"), (Serializable)pamelaJones);
            testCache.put(element);
            System.out.println("**** Waiting for element to reach the time to live ****");
            BigMemoryAsACacheConfiguration.waitForElementToBeExpired(testCache, element);
            System.out.println("**** The element has expired ****");
            System.out.println("**** Successfully configured as a cache **** ");
        }
        finally {
            if (manager != null) {
                manager.shutdown();
            }
        }
    }

    private static void waitForElementToBeExpired(Cache testCache, Element element) {
        while (!testCache.isExpired(element)) {
        }
    }
}

