package com.bigmemory.samples.crud;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;

import com.bigmemory.commons.model.Person;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import static com.bigmemory.commons.util.ReadUtil.waitForInput;

/**
 * <p>Sample app briefly showing some of the api's one can use to create, read, update and delete in
 * BigMemory.
 * <p/>
 * <p>
 * Released to the public domain, as explained at  http://creativecommons.org/publicdomain/zero/1.0/
 * </p>
 *
 * @author Mathilde Lemee
 */
public class BigMemoryCrud {

  public static void main(String[] args) throws IOException {
    /** Setting up the bm configuration **/

    Configuration managerConfiguration = new Configuration();
    managerConfiguration.updateCheck(true)
        .monitoring(Configuration.Monitoring.AUTODETECT)
        .name("config")
        .cache(new CacheConfiguration()
            .name("bm-crud")
            .maxBytesLocalHeap(128, MemoryUnit.MEGABYTES)
            .maxBytesLocalOffHeap(1, MemoryUnit.GIGABYTES)
        );

    CacheManager manager = CacheManager.create(managerConfiguration);
    Cache bm = manager.getCache("bm-crud");

    try {
      //put value
      System.out.println("**** Put key 1 / value timDoe. ****");
      final Person timDoe = new Person("Tim Doe", 35, Person.Gender.MALE,
          "eck street", "San Mateo", "CA");
      bm.put(new Element("1", timDoe));
      waitForInput();

      //get value
      System.out.println("**** Retrieve key 1. ****");
      final Element element = bm.get("1");
      System.out.println("The value for key 1 is  " + element.getObjectValue());
      waitForInput();

      //update value
      System.out.println("**** Update value for key 1 to pamelaJones ****");
      final Person pamelaJones = new Person("Pamela Jones", 23, Person.Gender.FEMALE,
          "berry st", "Parsippany", "LA");
      bm.put(new Element("1", pamelaJones));
      final Element updated = bm.get("1");
      System.out.println("The value for key 1 is now " + updated.getObjectValue() + ". key 1 has been updated.");
      waitForInput();

      //delete value
      System.out.println("**** Delete key 1. ****");
      bm.remove("1");
      System.out.println("Retrieve key 1.");
      final Element removed = bm.get("1");
      System.out.println("Value for key 1 is " + removed + ". Key 1 has been deleted.");
      waitForInput();

      System.out.println("Number of element : " + bm.getSize());
      waitForInput();

      //put all
      System.out.println("**** Put 5 keys/values.  ****");
      bm.putAll(getFiveElements());
      System.out.println("Number of element : " + bm.getSize());
      waitForInput();

      //get all
      System.out.println("**** Get elements of keys 1,2 and 3.  ****");
      final Map<Object, Element> elementsMap = bm.getAll(Arrays.asList("1", "2", "3"));
      for (Element currentElement : elementsMap.values()) {
        System.out.println(currentElement);
      }

      waitForInput();

      //remove all
      System.out.println("**** Remove the element with keys 1,2,3. ****");
      bm.removeAll(Arrays.asList("1", "2", "3"));
      System.out.println("Number of element : " + bm.getSize());

      //removing all elements
      System.out.println("**** Remove all elements. ****");
      bm.removeAll();
      waitForInput();
      System.out.println("Number of element : " + bm.getSize());

    } finally {
      if (manager != null) manager.shutdown();
    }
  }


  private static Collection<Element> getFiveElements() {
    Collection<Element> elements = new ArrayList<Element>();
    elements.add(new Element("1", new Person("Jane Doe", 35, Person.Gender.FEMALE,
        "eck street", "San Mateo", "CA")));
    elements.add(new Element("2", new Person("Marie Antoinette", 23, Person.Gender.FEMALE,
        "berry st", "Parsippany", "LA")));
    elements.add(new Element("3", new Person("John Smith", 25, Person.Gender.MALE,
        "big wig", "Beverly Hills", "NJ")));
    elements.add(new Element("4", new Person("Paul Dupont", 25, Person.Gender.MALE,
        "big wig", "Beverly Hills", "NJ")));
    elements.add(new Element("5", new Person("Juliet Capulet", 25, Person.Gender.FEMALE,
        "big wig", "Beverly Hills", "NJ")));

    return elements;
  }


}
