package com.bigmemory.samples.configprogrammatic;


import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;

import java.io.IOException;

/**
 * <p>Size-based config using a programmatic configuration
 * <p/>
 * <p>Released to the public domain, as explained at  http://creativecommons.org/licenses/publicdomain
 * </p>
 * <p> Link to doc http://ehcache.org/documentation/configuration/bigmemory </p>
 *
 * @author Mathilde Lemee
 */
public class ProgrammaticBasedBigMemoryConfiguration {

  /**
   * Run a test with BigMemory using a programmatic configuration
   *
   * @throws IOException
   */
  public static void main(String[] args) throws IOException {

    System.out.println("**** Programatically configure an instance ****");

    Configuration managerConfiguration = new Configuration()
        .name("bigmemory-config")
        .cache(new CacheConfiguration()
            .name("bm")
            .maxBytesLocalHeap(128, MemoryUnit.MEGABYTES)
            .maxBytesLocalOffHeap(1, MemoryUnit.GIGABYTES)
            .copyOnRead(true)
            .statistics(true)
            .eternal(true)
        );  //restartable

    CacheManager manager = CacheManager.create(managerConfiguration);
    try {
      Cache bm = manager.getCache("bm");
      //bm is now ready.

      System.out.println("**** Successfully created - Programmatic based **** ");


    } finally {
      if (manager != null) manager.shutdown();
    }
  }
}
