package com.bigmemory.samples.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;

import com.bigmemory.commons.model.Person;

/**
 * <p>Using BigMemory as a cache and dynamically adding
 * a cache instance
 * <p/>
 * <p>Released to the public domain, as explained at  http://creativecommons.org/publicdomain/zero/1.0/
 * </p>
 *
 * @author Mathilde Lemee
 */
public class BigMemoryAsACacheConfiguration {


  public static void main(String[] args) throws InterruptedException {
    Configuration managerConfiguration = new Configuration();
    managerConfiguration.updateCheck(true)
        .monitoring(Configuration.Monitoring.AUTODETECT)
        .name("cacheManagerCompleteExample")
        .addCache(
            new CacheConfiguration()
                .name("sample-cache")
                .maxBytesLocalHeap(128, MemoryUnit.MEGABYTES)
                .maxBytesLocalOffHeap(1, MemoryUnit.GIGABYTES)
                .timeToLiveSeconds(4)
                .timeToIdleSeconds(2)

        );

    CacheManager manager = CacheManager.create(managerConfiguration);
    try {
      System.out.println("**** BigMemory as a cache - configuration ****");
      Cache testCache = manager.getCache("sample-cache");

      /** the cache is now ready **/
      System.out.println("**** Add value for key 1 to pamelaJones ****");
      final Person pamelaJones = new Person("Pamela Jones", 23, Person.Gender.FEMALE,
          "berry st", "Parsippany", "LA");
      Element element = new Element("1", pamelaJones);
      testCache.put(element);

      System.out.println("**** Waiting for element to reach the time to live ****");
      waitForElementToBeExpired(testCache, element);

      System.out.println("**** The element has expired ****");
      System.out.println("**** Successfully configured as a cache **** ");
    } finally {
      if (manager != null) manager.shutdown();
    }
  }

  private static void waitForElementToBeExpired(final Cache testCache, final Element element) {
    while (!testCache.isExpired(element)) {

    }
  }


}
