package com.bigmemory.samples.arc;


import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;

import java.io.IOException;

/**
 * <p>BigMemory configuration - size based config using Automatic Resource Control and dynamically adding one instance
 * so they share the memory allocated by Automatic Resource Control
 * <p/>
 * <p>Automatic Resource Control (ARC) is an intelligent approach to caching with fine-grained controls for tuning cache performance. ARC offers a wealth of benefits, including:
 * <ul>
 * <li>Sizing limitations on in-memory caches to avoid OutOfMemory errors</li>
 * <li>Pooled (CacheManager-level) sizing – no requirement to size caches individually</li>
 * <li>Differentiated tier-based sizing for flexibility</li>
 * <li>Sizing by bytes, entries, or percentages for more flexibility</li>
 * <li>Keeping hot or eternal data where it can substantially boost performance</li>
 * </ul>
 * </p>
 * <p>The two instances share 128 MB of local heap memory and 1GB of off-heap memory
 * <p/>
 * <p>Link to doc : http://ehcache.org/documentation/arc/index </p>
 * <p/>
 * Released to the public domain, as explained at  http://creativecommons.org/publicdomain/zero/1.0/
 *
 * @author Mathilde Lemee
 */
public class ArcConfiguration {


  public static void main(String[] args) throws IOException {
    CacheManager manager = CacheManager.newInstance(ArcConfiguration.class.getResource("/arc/ehcache.xml"));
    try {
      System.out.println("**** Retrieve bm1 from xml ****");
      Cache bm1 = manager.getCache("bm1");

      System.out.println("**** Dynamically add bm2 ****");
      manager.addCache("bm2");
      Cache bm2 = manager.getCache("bm2");

      System.out.println("**** bm1 and bm2 share ****" + manager.getConfiguration()
          .getMaxBytesLocalHeap() + "b heap and " + manager.getConfiguration()
          .getMaxBytesLocalOffHeap() + "b off-heap");

      System.out.println("**** Successfully configured with ARC **** ");


    } finally {
      if (manager != null) manager.shutdown();
    }
  }

}
