/*
 * Decompiled with CFR 0.152.
 */
package com.bigmemory.samples.crud;

import com.bigmemory.commons.model.Person;
import com.bigmemory.commons.util.ReadUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.MemoryUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigMemoryCrud {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Configuration managerConfiguration = new Configuration();
        managerConfiguration.updateCheck(true).monitoring(Configuration.Monitoring.AUTODETECT).name("config").cache(new CacheConfiguration().name("bm-crud").maxBytesLocalHeap(128L, MemoryUnit.MEGABYTES).maxBytesLocalOffHeap(1L, MemoryUnit.GIGABYTES));
        CacheManager manager = CacheManager.create((Configuration)managerConfiguration);
        Cache bm = manager.getCache("bm-crud");
        try {
            System.out.println("**** Put key 1 / value timDoe. ****");
            Person timDoe = new Person("Tim Doe", 35, Person.Gender.MALE, "eck street", "San Mateo", "CA");
            bm.put(new Element((Serializable)((Object)"1"), (Serializable)timDoe));
            ReadUtil.waitForInput();
            System.out.println("**** Retrieve key 1. ****");
            Element element = bm.get((Serializable)((Object)"1"));
            System.out.println("The value for key 1 is  " + element.getObjectValue());
            ReadUtil.waitForInput();
            System.out.println("**** Update value for key 1 to pamelaJones ****");
            Person pamelaJones = new Person("Pamela Jones", 23, Person.Gender.FEMALE, "berry st", "Parsippany", "LA");
            bm.put(new Element((Serializable)((Object)"1"), (Serializable)pamelaJones));
            Element updated = bm.get((Serializable)((Object)"1"));
            System.out.println("The value for key 1 is now " + updated.getObjectValue() + ". key 1 has been updated.");
            ReadUtil.waitForInput();
            System.out.println("**** Delete key 1. ****");
            bm.remove((Serializable)((Object)"1"));
            System.out.println("Retrieve key 1.");
            Element removed = bm.get((Serializable)((Object)"1"));
            System.out.println("Value for key 1 is " + removed + ". Key 1 has been deleted.");
            ReadUtil.waitForInput();
            System.out.println("Number of element : " + bm.getSize());
            ReadUtil.waitForInput();
            System.out.println("**** Put 5 keys/values.  ****");
            bm.putAll(BigMemoryCrud.getFiveElements());
            System.out.println("Number of element : " + bm.getSize());
            ReadUtil.waitForInput();
            System.out.println("**** Get elements of keys 1,2 and 3.  ****");
            Map elementsMap = bm.getAll(Arrays.asList("1", "2", "3"));
            for (Element currentElement : elementsMap.values()) {
                System.out.println(currentElement);
            }
            ReadUtil.waitForInput();
            System.out.println("**** Remove the element with keys 1,2,3. ****");
            bm.removeAll(Arrays.asList("1", "2", "3"));
            System.out.println("Number of element : " + bm.getSize());
            System.out.println("**** Remove all elements. ****");
            bm.removeAll();
            ReadUtil.waitForInput();
            System.out.println("Number of element : " + bm.getSize());
        }
        finally {
            if (manager != null) {
                manager.shutdown();
            }
        }
    }

    private static Collection<Element> getFiveElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add(new Element((Serializable)((Object)"1"), (Serializable)new Person("Jane Doe", 35, Person.Gender.FEMALE, "eck street", "San Mateo", "CA")));
        elements.add(new Element((Serializable)((Object)"2"), (Serializable)new Person("Marie Antoinette", 23, Person.Gender.FEMALE, "berry st", "Parsippany", "LA")));
        elements.add(new Element((Serializable)((Object)"3"), (Serializable)new Person("John Smith", 25, Person.Gender.MALE, "big wig", "Beverly Hills", "NJ")));
        elements.add(new Element((Serializable)((Object)"4"), (Serializable)new Person("Paul Dupont", 25, Person.Gender.MALE, "big wig", "Beverly Hills", "NJ")));
        elements.add(new Element((Serializable)((Object)"5"), (Serializable)new Person("Juliet Capulet", 25, Person.Gender.FEMALE, "big wig", "Beverly Hills", "NJ")));
        return elements;
    }
}

