/*
 * Decompiled with CFR 0.152.
 */
package util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import extension.CoreKtxKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001d\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J/\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lutil/SignMd5Util;", "", "()V", "HEX_DIGITS", "", "bytes2HexString", "", "bytes", "", "getAppSignature", "", "Landroid/content/pm/Signature;", "packageName", "(Ljava/lang/String;)[Landroid/content/pm/Signature;", "getAppSignatureMD5", "getSignMD5FromApk", "file", "Ljava/io/File;", "hashTemplate", "data", "algorithm", "loadCertificates", "Ljava/security/cert/Certificate;", "jarFile", "Ljava/util/jar/JarFile;", "je", "Ljava/util/jar/JarEntry;", "readBuffer", "(Ljava/util/jar/JarFile;Ljava/util/jar/JarEntry;[B)[Ljava/security/cert/Certificate;", "updateapputils_release"})
public final class SignMd5Util {
    private static final char[] HEX_DIGITS;
    public static final SignMd5Util INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getAppSignatureMD5() {
        Object object = CoreKtxKt.globalContext();
        if (object == null || (object = object.getPackageName()) == null) {
            object = "";
        }
        Object object2 = object;
        CharSequence charSequence = (CharSequence)object2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        boolean bl2 = false;
        if (bl2) {
            return "";
        }
        Signature[] signature = this.getAppSignature((String)object2);
        if (signature == null) return "";
        Signature[] signatureArray = signature;
        boolean bl3 = false;
        if (signatureArray.length == 0) {
            return "";
        }
        boolean bl4 = false;
        if (bl4) {
            return "";
        }
        CharSequence charSequence2 = this.bytes2HexString(this.hashTemplate(signature[0].toByteArray(), "MD5"));
        String string2 = "(?<=[0-9A-F]{2})[0-9A-F]{2}";
        boolean bl5 = false;
        string2 = new Regex(string2);
        String string3 = ":$0";
        boolean bl6 = false;
        String string4 = string2.replace(charSequence2, string3);
        return string4;
    }

    @NotNull
    public final String getSignMD5FromApk(@NotNull File file) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ArrayList<String> signatures = new ArrayList<String>();
        JarFile jarFile = new JarFile(file);
        try {
            JarEntry je = jarFile.getJarEntry("AndroidManifest.xml");
            byte[] readBuffer = new byte[8192];
            Certificate[] certs = this.loadCertificates(jarFile, je, readBuffer);
            if (certs != null) {
                for (Certificate c : certs) {
                    CharSequence charSequence = this.bytes2HexString(this.hashTemplate(c.getEncoded(), "MD5"));
                    String string3 = "(?<=[0-9A-F]{2})[0-9A-F]{2}";
                    boolean bl = false;
                    string3 = new Regex(string3);
                    String string4 = ":$0";
                    boolean bl2 = false;
                    String sig = string3.replace(charSequence, string4);
                    signatures.add(sig);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((string2 = (String)CollectionsKt.getOrNull((List)signatures, (int)0)) == null) {
            string2 = "";
        }
        return string2;
    }

    private final Signature[] getAppSignature(String packageName) {
        Signature[] signatureArray = (Signature[])packageName;
        boolean bl = false;
        if (signatureArray.length() == 0) {
            return null;
        }
        try {
            PackageInfo pi;
            PackageManager pm;
            Context context2 = CoreKtxKt.globalContext();
            PackageManager packageManager = pm = context2 != null ? context2.getPackageManager() : null;
            PackageInfo packageInfo = pi = packageManager != null ? packageManager.getPackageInfo(packageName, 64) : null;
            signatureArray = packageInfo != null ? packageInfo.signatures : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            signatureArray = null;
        }
        return signatureArray;
    }

    private final byte[] hashTemplate(byte[] data, String algorithm) {
        byte[] byArray;
        block5: {
            block4: {
                if (data == null) break block4;
                byArray = data;
                boolean bl = false;
                if (!(byArray.length == 0)) break block5;
            }
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            byArray = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    private final String bytes2HexString(byte[] bytes) {
        byte by;
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >> 4 & 0xF];
            int n = j++;
            by = bytes[i];
            int n2 = 15;
            char[] cArray = HEX_DIGITS;
            int n3 = n;
            char[] cArray2 = ret;
            boolean bl = false;
            byte by2 = (byte)(by & n2);
            cArray2[n3] = cArray[by2];
        }
        by = 0;
        return new String(ret);
    }

    private final Certificate[] loadCertificates(JarFile jarFile, JarEntry je, byte[] readBuffer) {
        try {
            InputStream inputStream = jarFile.getInputStream(je);
            while (inputStream.read(readBuffer, 0, readBuffer.length) != -1) {
            }
            inputStream.close();
            JarEntry jarEntry = je;
            return jarEntry != null ? jarEntry.getCertificates() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private SignMd5Util() {
    }

    static {
        SignMd5Util signMd5Util;
        INSTANCE = signMd5Util = new SignMd5Util();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

