/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.design.R;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.util.FontUtil;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class BottomDialog {
    private static final int maxCnt = 6;
    private OnBottomListener bottomListener;
    private final Activity activity;
    private BottomSheetDialog bottomSheetDialog;
    private int peekHeight;
    private int maxRecyclerHeight;
    private BottomAdapter adapter;

    public BottomDialog(Activity activity) {
        this.activity = activity;
    }

    public void setBottomListener(OnBottomListener bottomListener) {
        this.bottomListener = bottomListener;
        this.peekHeight = Utils.getDeviceHeight(this.activity) * 3 / 5 - Utils.dpToPx(89);
        this.maxRecyclerHeight = Utils.dpToPx(52) * 6;
    }

    public void showBottomDialog(SelectBoxRequest selectBoxRequest) {
        try {
            View view;
            if (selectBoxRequest == null) {
                return;
            }
            if (this.bottomSheetDialog == null) {
                this.bottomSheetDialog = new BottomSheetDialog((Context)this.activity);
                this.bottomSheetDialog.getWindow().setSoftInputMode(32);
            }
            if (!this.isShowing() && (view = this.activity.getLayoutInflater().inflate(R.layout.bottom_sheet_view, null)) != null) {
                FontUtil.setAllTextView(view);
                TextView titleTextView = (TextView)view.findViewById(R.id.title);
                FontUtil.setFont((Context)this.activity, titleTextView, "NotoSans-Regular.otf");
                titleTextView.setText((CharSequence)selectBoxRequest.getTitle());
                view.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        BottomDialog.this.dismiss();
                    }
                });
                view.findViewById(R.id.enter).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BottomDialog.this.bottomListener != null) {
                            BottomDialog.this.bottomListener.onItemSelected(BottomDialog.this.adapter.getItem());
                        }
                        BottomDialog.this.dismiss();
                    }
                });
                RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
                if (selectBoxRequest.getData().size() > 6) {
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                    params.height = this.maxRecyclerHeight;
                    recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
                LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.activity);
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
                recyclerView.setHasFixedSize(true);
                this.adapter = new BottomAdapter(selectBoxRequest);
                recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
                this.bottomSheetDialog.setContentView(view);
                this.bottomSheetDialog.show();
                this.bottomSheetDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialog) {
                        BottomSheetDialog d = (BottomSheetDialog)dialog;
                        FrameLayout bottomSheet = (FrameLayout)d.findViewById(R.id.design_bottom_sheet);
                        BottomSheetBehavior.from((View)bottomSheet).setState(3);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.bottomSheetDialog.dismiss();
        }
    }

    private boolean isShowing() {
        return this.bottomSheetDialog != null && this.bottomSheetDialog.isShowing();
    }

    static class BottomViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout container;
        TextView nameTextView;
        ImageView imageView;

        BottomViewHolder(View convertView, final OnClickListener onClickListener) {
            super(convertView);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (onClickListener != null && BottomViewHolder.this.getAdapterPosition() != -1) {
                        onClickListener.onClick(BottomViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.container = (RelativeLayout)convertView.findViewById(R.id.container);
            this.nameTextView = (TextView)convertView.findViewById(R.id.name);
            this.imageView = (ImageView)convertView.findViewById(R.id.done);
        }

        void onBind(SelectBoxInfo selectBoxInfo) {
            if (selectBoxInfo.isSelected()) {
                this.imageView.setVisibility(selectBoxInfo.isSelected() ? 0 : 8);
                this.nameTextView.setTextColor(ContextCompat.getColor((Context)this.nameTextView.getContext(), (int)R.color.colorSheet));
            } else {
                this.imageView.setVisibility(selectBoxInfo.isSelected() ? 0 : 8);
                this.nameTextView.setTextColor(ContextCompat.getColor((Context)this.nameTextView.getContext(), (int)17170444));
            }
            this.nameTextView.setText((CharSequence)selectBoxInfo.getName());
        }
    }

    public static class BottomAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder>
    implements OnClickListener {
        private final ArrayList<SelectBoxInfo> selectBoxInfos;
        private int selectedPos = -1;

        BottomAdapter(SelectBoxRequest selectBoxRequests) {
            this.selectBoxInfos = selectBoxRequests.getData();
            this.setSelectedPos();
        }

        private void setSelectedPos() {
            int size = this.selectBoxInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!this.selectBoxInfos.get(i).isSelected()) continue;
                this.selectedPos = i;
                return;
            }
        }

        public SelectBoxInfo getItem() {
            try {
                return this.selectBoxInfos.get(this.selectedPos);
            }
            catch (Exception e) {
                return null;
            }
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ViewGroup view = (ViewGroup)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.adapter_select_box, parent, false);
            FontUtil.setAllTextView((View)view);
            return new BottomViewHolder((View)view, this);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            try {
                SelectBoxInfo selectBoxInfo = this.selectBoxInfos.get(position);
                selectBoxInfo.setSelected(this.selectedPos == position);
                BottomViewHolder bHolder = (BottomViewHolder)holder;
                bHolder.onBind(selectBoxInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getItemCount() {
            return this.selectBoxInfos == null ? 0 : this.selectBoxInfos.size();
        }

        @Override
        public void onClick(int position) {
            this.selectedPos = position;
            this.notifyDataSetChanged();
        }
    }

    static interface OnClickListener {
        public void onClick(int var1);
    }

    public static interface OnBottomListener {
        public void onItemSelected(SelectBoxInfo var1);
    }
}

