package com.tenqube.visual_scraper.thirdparty.mart;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;

import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimple;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimpleLoginTestResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimpleScrapResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSvrType;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.utils.AppExecutors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import timber.log.Timber;

public class MartScrapperImpl implements MartScrapper {

    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;
    SDKAssistSimple sdkInstance = null;
    public static MartScrapper getInstance(Context ctx) {

        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
        }
        return mInstance;
    }

    private MartScrapperImpl(Context context) {
        this.context = context;
    }

    @Override
    public void init(ScrapService.Callback<String> callback) {

        if(isInit) {
            callback.onDataLoaded("");
        } else {
            appExecutors.diskIO().execute(() -> {
                String msg = "";

                File root_file = context.getFilesDir();

                String root_path = root_file.getAbsolutePath();
                String appName = "visual";

                try {
                    sdkInstance = new SDKAssistSimple(root_path, appName, SDKAssistSvrType.e_SvrType.TenqubeProd);
                    isInit = true;
                } catch (IOException e) {
                    e.printStackTrace();
                    msg = e.toString();
                } finally {
                    String finalMsg = msg;
                    appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
                }
            });
        }

    }


    @Override
    public void requestMobileAuthCode(String phoneNumber, String birth, String name, ScrapService.Callback<Boolean> onResult) throws Exception {

        appExecutors.diskIO().execute(() -> {

            try {

                sdkInstance.RequestHomePlusHPAuthCode(phoneNumber, birth, name);

                appExecutors.mainThread().execute(() -> {
                    onResult.onDataLoaded(true);
                });

            } catch (Exception e) {
                e.printStackTrace();
                appExecutors.mainThread().execute(() -> {
                    onResult.onDataLoaded(false);
                });
            }
        });

    }

    @Override
    public void startHomeplusLogin(String authCode, String phoneNumber, ScrapService.Callback<Boolean> onResult) throws Exception {
        appExecutors.diskIO().execute(() -> {
            try {

                sdkInstance.ConfirmHomePlusHPAuthCode(authCode);
                appExecutors.mainThread().execute(() -> {
                    onResult.onDataLoaded(true);
                });

            } catch (Exception e) {
                e.printStackTrace();
                appExecutors.mainThread().execute(() -> {
                    onResult.onDataLoaded(false);
                });
            }

        });
    }


    boolean isRetry = false;
    @Override
    public void addUser(int mallId, String id, String password, ScrapService.Callback<String> callback) {

        appExecutors.diskIO().execute(() -> {

            String msg = "";
            try {
                e_MarketKeyCode keyCode = getMarketKeyCode(mallId);

                SDKAssistSimpleLoginTestResult ret = sdkInstance.LoginTest(keyCode, id, password);

                if (!ret.Success) {
                    throw ret.Ex;
                }

                String finalMsg = msg;
                isRetry = false;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));

            } catch (Exception e) {
                e.printStackTrace();
                msg = e.toString();

                if(!isRetry && mallId == Constants.MALL.Emart.getMallId() && msg != null && msg.contains("장애")) {

                    final Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(() -> {
                        isRetry = true;
                        addUser(mallId, id, password, callback);

                    }, 1500);

                    return;
                }

                String finalMsg = msg;
                isRetry = false;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));

            }
        });
    }

    @Override
    public void start(int mallId, String id, String pwd, ScrapService.Callback<List<MartData>> callback) {

        appExecutors.networkIO().execute(() -> {
            String msg = "";
            List<MartData> results = new ArrayList<>();

            try {
                Calendar _toDate = Calendar.getInstance();

                e_MarketKeyCode keyCode = getMarketKeyCode(mallId);

                SDKAssistSimpleScrapResult ret;

                if(keyCode == e_MarketKeyCode.HomePlus) {
                    Calendar curDate = Calendar.getInstance();
                    Calendar fromDate = Calendar.getInstance();
                    fromDate.add(Calendar.MONTH, -6);
                    ret = sdkInstance.ScrapReceiptHomePlusHP(id, pwd, curDate, fromDate);

                } else {
                    ret = sdkInstance.ScrapReceipt(keyCode, id, pwd, _toDate, null);
                }

                if (!ret.Success) {
                    throw ret.Ex;
                }

                results = getMartItems(mallId, ret.ScrappedReceiptList, ret.ScrappedReceiptProductList);


            } catch (UnsupportedOperationException e) {
                msg = "아이디 또는 패스워드를 다시 확인하세요";
            } catch (Exception e) {
                msg = e.toString();
            } finally {
                String finalMsg = msg;
                List<MartData> finalResults = results;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalResults));
            }
        });
    }

    public List<MartData> getMartItems(int mallId, ArrayList<Receipt> receiptList, ArrayList<ReceiptProduct> productArrayList) {


            List<MartData> results = new ArrayList<>();

            try {

                if(receiptList != null) {
                    Timber.i("ScrapManager" + receiptList.size());
                    for(Receipt rr: receiptList) {

                        Timber.i("ScrapManager mallId " + mallId);
                        Timber.i("ScrapManager getMallId(rr.MartEnumKeyCode) " + getMallId(rr.MartEnumKeyCode));

                        if(mallId == getMallId(rr.MartEnumKeyCode)) {

                            Timber.i("ScrapManager productArrayList " + productArrayList.size());

                            for (ReceiptProduct rp : productArrayList) {

                                Timber.i("ScrapManager BuyDate " + rp.BuyDate);
                                Timber.i("ScrapManager InsertDate " + rp.InsertDate);

                                MartData martData = new MartData();
                                martData.barcode = rp.Barcode;
                                martData.buyCount = rp.BuyCount;
                                // 2019-09-02 13:15:00
                                martData.buyDate = rp.BuyDate;
                                martData.insertDate = rp.InsertDate;
                                martData.name = rp.ProductName;
                                martData.price = rp.UnitPrice.doubleValue();
                                martData.receiptKey = rp.ReceiptKey;
                                martData.receiptProductKey = rp.ReceiptProductKey;
                                martData.orderAmount = rp.OrderAmount.doubleValue();
                                martData.raw = rr.Raw;
                                martData.posNo = rr.PosNo;

                                martData.branchName = rr.MartStoreName;
                                martData.branchAddress = rr.MartAddress;

                                results.add(martData);
                            }
                        }
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            return results;

    }

    @Override
    public void logout(int mId, String userId) {
        appExecutors.diskIO().execute(() -> {

            String msg = "";
            try {
//                e_MarketKeyCode keyCode = getMarketKeyCode(mId);
//                SDKAssistResult delete = mgr.DeleteBuyer(keyCode, userId);
//                Timber.i("delete" + delete.Success);
            } catch (Exception e) {
            }
        });
    }

    private int getMallId(e_MarketKeyCode martKey) {
        if(martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.getMallId();
        } else if(martKey == e_MarketKeyCode.EMartApp ) {
            return Constants.MALL.Emart.getMallId();

        } else if(martKey == e_MarketKeyCode.HomePlus ) {
            return Constants.MALL.Homeplus.getMallId();
        }
        return -1;
    }

    private e_MarketKeyCode getMarketKeyCode(int mallId) {
        if(mallId == Constants.MALL.Emart.getMallId()) {
            return e_MarketKeyCode.EMartApp;
        } else if(mallId == Constants.MALL.Homeplus.getMallId()) {
            return e_MarketKeyCode.HomePlus;
        }
        else {
            return e_MarketKeyCode.LotteMCoupon;
        }
    }


//    private MallEntity getMall(e_MarketKeyCode mktCode) {
//
//        if(mktCode == e_MarketKeyCode.EMartApp) {
//            return new MallEntity("emart", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        } else {
//            return new Mall("롯데M쿠폰", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        }
//    }

}
