package com.tenqube.visual_scraper.webviewhtmlloader

import android.webkit.WebView
import com.tenqube.visual_scraper.shared.util.Result
import com.tenqube.visual_scraper.webviewhtmlloader.model.WebViewResponse


interface WebViewLoader {

    fun getWebView(): WebView?

    fun skipDelay(): WebViewLoader

    fun go(url: String, isScrappingPage: Boolean = false, onSuccessUrl: String? = null, userTimeOut: Long? = null): WebViewHtmlLoader

    fun delayTime(time: Long): WebViewHtmlLoader

    fun noCache(): WebViewHtmlLoader

    fun back(isInterceptUrl: Boolean): WebViewLoader

    fun onPageCallback(callbackJs: String = "", callback: OnPageLoadedCallback? = null): WebViewLoader

    suspend fun load(): Result<WebViewResponse>
}

interface OnPageLoadedCallback {

    fun onPageLoaded(url: String)

    fun onUserIdChanged(id: String)

    fun onUserPwdChanged(pwd: String)
}