package com.tenqube.visual_scraper.db.converter;

import androidx.room.TypeConverter;

import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

public class QueryRuleConverter {

    @TypeConverter
    public static String fromOrderRules(QueryRuleBody rule) {
        if(rule == null) return null;

        String ruleJson = Utils.toJson(rule);

        return Injection.provideAES256Cipher(ScraperDatabase.context).encrypt(ruleJson);
    }

    @TypeConverter
    public static QueryRuleBody toParsingOrderRule(String rule) {

        if(rule == null) return null;

        String decryptRule = Injection.provideAES256Cipher(ScraperDatabase.context).decrypt(rule);

        return Utils.parseJsonObject(decryptRule, QueryRuleBody.class);
    }

}
