package com.tenqube.visual_scraper.api

import com.tenqube.visual_scraper.market.dto.coupang.CoupangOrderDto
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import retrofit2.HttpException
import timber.log.Timber
import java.io.IOException

sealed class ResultWrapper<out T> {
    data class Success<out T>(val value: T): ResultWrapper<T>()
    data class GenericError(val code: Int): ResultWrapper<Nothing>()
    object NetworkError: ResultWrapper<Nothing>()
}



suspend fun <T> apiCall(
        dispatcher: CoroutineDispatcher,
        apiCall: suspend () -> T
): ResultWrapper<T> {



    return withContext(dispatcher) {
        try {
            ResultWrapper.Success(apiCall.invoke())
        } catch (throwable: Throwable) {

            Timber.i("apiCall" + throwable)

            when (throwable) {
                is IOException -> ResultWrapper.NetworkError
                is HttpException -> {
                    val code = throwable.code()
                    ResultWrapper.GenericError(code)
                }
                else -> {
                    ResultWrapper.GenericError(400)
                }
            }
        }
    }
}


class ApiServiceImpl(
        private val apiService: ApiService,
        private val ioDispatcher: CoroutineDispatcher = Dispatchers.IO){

    suspend fun get(url: String, header: Map<String, String>): CoupangOrderDto? {
        return when (val response = apiCall(ioDispatcher) { apiService.getCoupang(url, header) }) {
            is ResultWrapper.Success -> {
                response.value
            }
            is ResultWrapper.NetworkError -> {
                null
            }
            is ResultWrapper.GenericError -> {
                null
            }
        }
    }

}