/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.converter;

import androidx.room.TypeConverter;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.utils.Utils;

public class OrderRuleConverter {
    @TypeConverter
    public static String fromOrderRules(ParsingOrderRules rule) {
        if (rule == null) {
            return null;
        }
        String ruleJson = Utils.toJson(rule);
        return Injection.provideAES256Cipher(ScraperDatabase.context).encrypt(ruleJson);
    }

    @TypeConverter
    public static ParsingOrderRules toParsingOrderRule(String rule) {
        if (rule == null) {
            return null;
        }
        String decryptRule = Injection.provideAES256Cipher(ScraperDatabase.context).decrypt(rule);
        return Utils.parseJsonObject(decryptRule, ParsingOrderRules.class);
    }
}

