package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.tenqube.visual_scraper.MallViewHandler;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.utils.Utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.Timer;
import java.util.TimerTask;

import timber.log.Timber;

public class WebViewManager {

    private static final long TIMEOUT_TIMEMILLIS = 30000;

    private static final long SCRIPT_TIMEOUT_TIMEMILLIS = 6000;

    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;

    private WebViewCallback callback;
    private Timer timer, scriptTimer;

    private TimerTask timerTask, scriptTimerTask;
    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;

    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    public static final int LOGOUT = 3;

    private int failedCnt = 0;
    @Nullable private MallViewHandler mallViewService;

    private boolean isVisibleWebView;
    private boolean isLoginFinished;
    private boolean isCheckedCaptcha;
    private boolean isClosedWebView;
    private boolean isCheckedOTP;

    private boolean isLoginSkip;
    private boolean isLoginUrlContained;


    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, @Nullable MallViewHandler mallViewService) {
        this.mallViewService = mallViewService;
        this.context = mallViewService != null ? mallViewService.getContext() : context;
        this.handler = new Handler(Looper.getMainLooper());
        initWebView();
    }


    @SuppressLint({"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {

        this.webView = /*view == null ? */new WebView(context) /*: view*/;
//        if(mallViewService != null) mallViewService.setWebView(webView, View.VISIBLE);

//        createCookieManager();
//        webView.clearCache(true);
//        webView.clearHistory();
//        Utils.clearCookies(context);

        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT_NORMAL);

        webView.addJavascriptInterface(new ScriptInterface(), "HtmlViewer");
        webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);

        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setAppCacheEnabled(true);

        webView.getSettings().setBuiltInZoomControls(true);
        webView.getSettings().setPluginState(WebSettings.PluginState.ON);

        webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);


        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if (error != null) {
                        Timber.i("onReceivedError" + "error : "+error.getErrorCode());
                        switch (error.getErrorCode()) {
                            case ERROR_UNKNOWN:
                            case ERROR_UNSUPPORTED_SCHEME:
                            case ERROR_TOO_MANY_REQUESTS:
                                return;
                            case ERROR_CONNECT:
                                webView.reload();
                                return;
                        }
                }}

                stopTimer();
                onFailReceivedError(error);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Timber.i("onPageFinished" +"url : "+url);
                onPageFinishedCallback(view, url);

            }

            @SuppressWarnings("deprecation")
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Timber.i("shouldOverrideUrlLoading [1] : %s",url);
                return checkUrlForShouldOverride(url);
            }

            @TargetApi(Build.VERSION_CODES.N)
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                final String url = request.getUrl().toString();
                Timber.i("shouldOverrideUrlLoading [2] : %s", url);
                return checkUrlForShouldOverride(url);

            }

        });

        webView.setWebChromeClient(new WebChromeClient(){
            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Timber.i("onJsAlert" +"message : "+ message + "url : "+url);
                stopTimer();

                if (!Constants.MALL.LotteHome.name().equals(mall.mallData.getKeyName()) ||
                        message.contains("아이디는 3-50자리까지 가능합니다") && url.equals("https://secure.lotteimall.com/member/login/forward.LCLoginMem.lotte")) {
                    loginFailed(message);
                }
                Toast.makeText(context, message, Toast.LENGTH_LONG).show();
                result.confirm();
                return true;
            }
        });

    }

    private boolean checkUrlForShouldOverride(String url) {
//        if (mall.shouldPopupView)
        if (Constants.MALL.LotteHome.name().equals(mall.mallData.getKeyName())){

            if (url.contains("https://secure.lotteimall.com/member/login/forward.LCLoginFailProc.lotte")) {
                loginFailed("아이디와 비밀번호를 확인하고 다시 로그인 해주세요.");

            } else if(url.contains("http://www.lotteimall.com/?ccoDlyMsg=chlNo")) {
                loginFailed("다시 로그인해주세요.");
            }
        }
        return false;
    }

    private void onFailReceivedError(WebResourceError error) {
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                if (isClosedWebView) return;

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    callback.onFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    callback.onFail(403, error.toString());
                }
            } catch (Exception e) {
                e.printStackTrace();
                callback.onFail(403, "error");
            }
        });
    }

    private void onPageFinishedCallback(WebView view, String url) {

        isLoginUrlContained = mall.identifyLoginPageOrNot(url);

        if (action == LOGIN && isLoginFinished) return;

        if("https://finish/".equals(url)) return;

        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        } else {
            view.setTag(url);
        }

        // mall 별 pass 할 page
        if (mall.shouldPassFinishedWebPages(url)) return;

        stopTimer();

        if(/*url.contains(webUrl) && */scripts != null){
            Timber.i("스크립트 실행 "+scripts);

            loadScripts(scripts);
            tempScripts = scripts;
            scripts = null;
        } else if(action == LOGIN/* && scripts == null*/){

            if (!isLoginSkip && (url.contains(webUrl) || mall.identifyLoginPageOrNot(url)) /*|| url.contains("https://nid.naver.com/signin/")*/){
                // 로그인 실패
                Timber.i("로그인 실패"+"!! " + failedCnt + " "+ isVisibleWebView);
                // check Error or Captcha
//                if (failedCnt ==0) {
                if (isVisibleWebView) return;

                if (mall.shouldShowWebView(url)) {
                    Timber.i("shouldShowWebView true");
                    showWebView();
                    return;
                }

                if ( mall.doCheckLoginError() ||
                        (mall.doCheckLoginCaptcha() && !isVisibleWebView && !isCheckedCaptcha) ||
                        (mall.doCheckLoginOTP() && !isVisibleWebView && !isCheckedOTP)){
                    getLoginHtml();
//                    failedCnt++;
                } else {
                    if (!isVisibleWebView) retryLogin();
                }


            } else {
                // 로그인 성공
                Timber.i("로그인 성공"+"!! " + " "+ isVisibleWebView);

                failedCnt = 0;
                if (isVisibleWebView) {
                    new Handler(Looper.getMainLooper()).post(() -> {

                        if (mallViewService != null) mallViewService.setWebView(getMallId(), webView, View.GONE);
                        isVisibleWebView = false;
                    });
                }
                finish();
            }
        } else if(action == LOGOUT) {
            Timber.i("LOGOUT success"+"!!isVisibleWebView : ");
            finish();
        } else {
            // 필터처리
            if (action == ORDER_PARSING &&  (url.contains("main") || url.contains("Home") || (url.contains("www.naver.com") ))) {
                Timber.i("page"+"Pass!!!!!!!");
//                        startTimer();
                return;
            }
            failedCnt = 0;
            finish();
        }
    }

    private int getMallId() {
        int mallId = 0;
        if(mall != null) {
            mallId = mall.mallData.getId();
        }

        return mallId;
    }

    private void retryLogin() {


        failedCnt++;
        Timber.i("retryLogin" +"failedCnt : "+failedCnt);

        if (failedCnt == 4){
            new Handler(Looper.getMainLooper()).post(() -> {

                callback.onFail(400, mall.mallData.getDisplayName() + "조회 실패"); // 실패
                closeWebView();
            });
            return;
        }

        if(failedCnt == 2) {
            // mall amazon 이면 script 내용 바꾸기
            if (mall.mallData.getKeyName().equalsIgnoreCase(Constants.MALL.Amazon.name())) {
                int pos = tempScripts.indexOf(";");
                if (tempScripts.length() > pos) tempScripts ="javascript:" + tempScripts.substring(pos+1,tempScripts.length());
                Timber.i("retryLogin" +"tempScripts : "+tempScripts +"pos: "+pos);
            }
        }

        loadScripts(tempScripts);
    }

    private void finish() {

        stopScriptTimer();
        Timber.i("webview" +"finish "+ action);
        if (callback != null) {
            switch (action) {
                case DEFAULT :
                    callback.onResult(webUrl, webView);
                    break;
                case LOGIN :
                    new Handler(Looper.getMainLooper()).post(() -> {

//                        if (checkLoginState()){
                            if (mallViewService != null)
                                mallViewService.notifyInProgressStatus(mall.mallData.getDisplayName()+" 쇼핑 내역을 불러오고 있습니다");
                            failedCnt = 0;
                            isLoginFinished = true;
                            callback.onResult(null, webView);//cookieManager.getCookie(webUrl), webView); // 성공
//                        } else {
//                            callback.onFail(403, "로그인 실패");
//                            closeWebView();
//                        }
                    });
                    break;

                case ORDER_PARSING :
                    // html 가져오기
                    getHtml();
//                    closeWebView();
                    break;
                case LOGOUT:

                    closeWebView();

                    break;
            }
        }
    }

    class ScriptInterface {

        ScriptInterface() {
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void showHTML(String html) {
//            Timber.i("showHTML", "html : "+html);
            if (callback != null) {
                callback.onResult(html, webView);

                if (mallViewService != null)
                    mallViewService.notifyInProgressStatus(mall.mallData.getDisplayName()+" 조회 완료");

                closeWebView();
            }
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void checkHTML(String html) {

            Document document = Jsoup.parse(html);
            if (document == null) return;

            if (mall.doCheckLoginError()) {
                String error = mall.checkLoginError(document);
                Timber.i("checkHTML" + "error : "+error);

                if (!TextUtils.isEmpty(error)) {
                    // 로그인 오류 > CLOSED
                    loginFailed(error);

                } else {
                    doCheckEtc(document);
                }

            } else {
                doCheckEtc(document);
            }
        }
    }

    private void doCheckEtc(Document document) {
        if (mall.doCheckLoginCaptcha()) { // 캡챠 존재
            Timber.i("checkHTML" + "doCheckLoginCaptcha : true");

            if (!findCapchaImage(document)) {// 캡챠 이미지 없
                Timber.i("checkHTML" + "findCapchaImage : false");

                if (mall.doCheckLoginOTP()) {// 오티피 여부
                    Timber.i("checkHTML" + "doCheckLoginOTP : true");

                    if (!findOTPPage(document)) { // otp 이미지 없으면
                        retryLogin();
                    } else {
                        // 대기
                    }
                } else {

                    Timber.i("checkHTML" + "doCheckLoginOTP : false");
                    Timber.i("checkHTML" + "action : " + action);
                    Timber.i("checkHTML" + "isLoginSkip : " + isLoginSkip);
                    Timber.i("checkHTML" + "isLoginUrlContained : " + isLoginUrlContained);

                    if(action == LOGIN && (isLoginSkip || !isLoginUrlContained)) {
                        finish();
                    } else {
                        retryLogin();
                    }
                }
            } else { // 캡챠 뜸
                //대
                Timber.i("checkHTML" + "findCapchaImage : true");
            }
        } else if (mall.doCheckLoginOTP()) {
            if (!findOTPPage(document)) {
                retryLogin();
            } else {
                //대기
            }
        } else {
            retryLogin();
        }

    }

    private boolean findOTPPage(Document document) {
        isCheckedOTP = true;
        if (mall.checkOTPPage(document)){
            // webView 띄우기
            Timber.i("checkHTML OTP");
            showWebView();
            return true;
        }
        return false;
    }

    private boolean findCapchaImage(Document document) {
        isCheckedCaptcha = true;
        if (mall.checkCaptchaImage(document)){
            // webView 띄우기
            Timber.i("checkHTML captcha");
            showWebView();
            return true;
        }
        return false;
    }

    private void showWebView() {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (mallViewService != null){
                isVisibleWebView = true;
                mallViewService.setWebView(getMallId(), webView, View.VISIBLE);
            } else {
                // 로그인 실패
                callback.onFail(403, "login fail");
                closeWebView();
            }
        });
    }

    @JavascriptInterface
    public void getHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.showHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    public void getLoginHtml() {
        Timber.i("getLoginHtml" +"!!");

        handler.postDelayed(()-> {
            webView.loadUrl("javascript:window.HtmlViewer.checkHTML" +
                    "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
        }, 100);
    }

    private void loginFailed(String error){
        new Handler(Looper.getMainLooper()).post(() -> {
            isLoginFinished = true;
            stopTimer();
//            Toast.makeText(context, ""+error, Toast.LENGTH_LONG).show();

            callback.onFail(400, error);

            if (isVisibleWebView) {
                if (mallViewService != null) mallViewService.setWebView(getMallId(), webView, View.GONE);
                isVisibleWebView = false;
            }
            closeWebView();


        });
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public WebViewManager isLoginSkip(boolean isLoginSkip) {
        this.isLoginSkip = isLoginSkip;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (webUrl != null){
            isLoginFinished = false;
            isClosedWebView = false;
            loadWebView(webUrl, false);
//            if (mallViewService != null)mallViewService.setWebView(webView,View.VISIBLE);
        } else {
            callback.onFail(403, "webUrl does not exist");
            closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;

        if (mall.mallData != null && Constants.MALL.LotteHome.name().equals(mall.mallData.getKeyName())) webView.getSettings().setSupportMultipleWindows(true);
    }

    private void loadScripts(String scripts) {

        try {

            Timber.i("loadScripts" +"scripts 실행 "+ scripts);
            loadWebView(scripts, true);

            if (failedCnt > 2) return;

            startScriptTimer();


        } catch (Exception e) {
            e.printStackTrace();
            callback.onFail(403, e.toString());
            closeWebView();
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Timber.i("loadWebView" +"url :"+ urlOrScripts + " //\nisScript : "+ isScripts +"//" +scripts );
        startTimer();

        handler.postDelayed(() ->{
            mall.setWebviewSettings(action, webView);
            webView.loadUrl(urlOrScripts, null);
        }, /*isScripts? 1000 :*/ 500);
    }


    public interface WebViewCallback {
        void onResult(String item, WebView webView);
        void onFail(int statusCode, String statusMessage);
    }


    private void closeWebView() {
        Timber.i("closeWebView" +"!!");
        if (webView != null) {
            handler.post(() -> {
                if (action == LOGIN) isLoginFinished = true;
                failedCnt = 0;
                isClosedWebView = true;


//                webView.stopLoading();
//                webView.clearCache(true);
//                webView.clearHistory();
//
//                if (cookieManager != null) {
//
//                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//                        cookieManager.removeSessionCookies(value -> {
//                        });
//                    } else {
//                        cookieManager.removeSessionCookie();
//                    }
//                    cookieManager.removeAllCookie();
//                }
            });
        }
    }



    public WebView getWebView(){
        return webView;
    }

    private void startTimer() {

        timer = new Timer();
        timerTask = new TimerTask() {
            @Override
            public void run() {

                handler.post(() -> {
                    Timber.i("TimeOut" + "action : "+action + "/url : "+webUrl+" scripts : "+scripts);
                    stopTimer();
                    closeWebView();
                    callback.onFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                });

            }
        };
        timer.schedule(timerTask, TIMEOUT_TIMEMILLIS);

    }

    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    private void startScriptTimer() {

//        if(scriptTimer == null) {
            scriptTimer = new Timer();
            scriptTimerTask = new TimerTask() {
                @Override
                public void run() {

                    handler.post(() -> {

                        if (action == LOGIN && timer != null) {
                            Timber.i("loadScripts" + "OnPageFinished 안울림 , 로그인 오류 체크 ");
                            // 로그인 오류 체크
                            stopTimer();
                            // html값을 얻어서 상태 체크
                            getLoginHtml();
                        }

                        if(action == LOGOUT) {
                            stopTimer();
                            finish();

                        }

                        if (action == ORDER_PARSING && timer != null && mall.doParsingMall()) {
                            stopTimer();
                            finish();
                        }
                    });

                }
            };
            scriptTimer.schedule(scriptTimerTask, SCRIPT_TIMEOUT_TIMEMILLIS);
//        }

    }

    private void stopScriptTimer(){
        if(scriptTimer != null){
            scriptTimer.cancel();
            scriptTimer.purge();
            scriptTimer = null;
            scriptTimerTask = null;
        }
    }
}
