/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.constants;

public class Constants {
    public static final String USER_AGENT_NORMAL = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36";
    public static final String USER_AGENT_ANDROID = "Android";

    public static class STATUSCODE {
        public static final int SUCCESS_CODE = 200;
        public static final int FAIL_CODE = 400;
        public static final int INVALID_USER_CODE = 404;
    }

    public static class MESSAGES {
        public static final String NO_DATA = "no data";
        public static final String INVALID_USER_INFO = "Invalid User Info";
        public static final String PARSING_SUCCESS = "Parsing Success";
        public static final String TIMEOUT_FAIL = "Timeout Fail";
        public static final String PARSING_FAIL = "Parsing FAIL";
        public static final String LOGIN_SUCCESS = "Success LoginPage";
        public static final String PURCHASE_START = "Start scraping Purchase";
        public static final String PURCHASE_END = "done";
        public static final String INVALID_EMAIL_FORMAT = "Invalid Email format";
    }

    public static class DYNAMIC_KEY {
        public static final String DYNAMIC_DATE = "dynamicDate";
        public static final String DYNAMIC_END = "dynamicEnd";
        public static final String DYNAMIC_USER_ID_KEY = "dynamicID";
        public static final String DYNAMIC_USER_PW_KEY = "dynamicPW";
        public static final String DYNAMIC_ORDER_NUM_KEY = "dynamicOrderNum";
    }

    public static class CONTENT_TYPE {
        public static final int URL_ENCODED = 0;
        public static final int JSON = 1;
        public static final String JSON_KEY = "application/json";
    }

    public static class METHOD_TYPE {
        public static final int GET = 0;
        public static final int POST = 1;
    }

    public static class SCRAP_TYPE {
        public static final int PURCHASE = 0;
        public static final int DETAIL_PURCHASE = 1;
        public static final int PRODUCT = 2;
    }

    public static final class API {
        public static final String X_API_KEY = "x-api-key";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String AUTHORIZATION = "Authorization";
    }

    public static final class LAYER {
        public static final String PROD = "prod";
        public static final String DEV = "dev";
    }

    public static final class CRUD {
        public static final int INSERT = 1;
        public static final int UPDATE = 2;
    }

    public static final class PREF_KEY {
        public static final String X_API_KEY = "x-api-key";
        public static final String LAYER = "layer";
        public static final String RULE_VERSION = "version";
        public static final String UUID = "uuid";
        public static final String SDK_IS_ENABLE = "SDK_IS_ENABLE";
        public static final String TOKEN = "token";
        public static final String SECRET_KEY = "SECRET_KEY";
        public static final String CHECK_PARSING_TIME = "CHECK_PARSING_TIME";
        public static final String PARSING_FREQUENCY = "PARSING_FREQUENCY";
        public static final String IS_MART_SYNCED = "IS_MART_SYNCED";
    }

    public static final class PERMISSION {
        public static final int STORAGE = 0;
    }

    public static enum ERROR {
        SYNC_FAIL,
        REQUEST_FREQUENT,
        LOGIN_FAIL,
        LOGIN_OUT_FAIL,
        NETWORK,
        PARSING,
        NOT_FOUND_MALL,
        NOT_FOUND_RULE,
        NOT_FOUND_LOGIN_RULE,
        PARSING_FAIL,
        EMPTY_MALL,
        CAPTCHA,
        NONE;

    }

    public static enum ScrapState {
        SUCCESS,
        FAIL;

    }

    public static enum MALL {
        Auction(1),
        Coupang(2),
        ElevenStreet(3),
        Gmarket(4),
        Gshome(5),
        Hmall(6),
        Interpark(7),
        LotteHome(8),
        NaverPay(9),
        Tmon(10),
        Wemake(11),
        Amazon(12),
        Emart(13),
        LotteMart(14),
        Homeplus(15),
        SSG(16),
        MarketKurly(17);

        int mallId;

        private MALL(int mallId) {
            this.mallId = mallId;
        }

        public int getMallId() {
            return this.mallId;
        }

        public static MALL fromMallId(int mId) {
            MALL[] malls;
            for (MALL m : malls = MALL.values()) {
                if (m.getMallId() != mId) continue;
                return m;
            }
            return null;
        }
    }

    public static enum DateFormatType {
        SLASH,
        DASH,
        DOT,
        NONE;

    }
}

