/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tenqube.visual_scraper.db.converter.Converters;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class OrderDao_Impl
implements OrderDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrderEntity> __insertionAdapterOfOrderEntity;
    private final SharedSQLiteStatement __preparedStmtOfHideOrder;
    private final SharedSQLiteStatement __preparedStmtOfDeleteOrder;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public OrderDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderEntity = new EntityInsertionAdapter<OrderEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `orders` (`_id`,`mall_id`,`user_id`,`title`,`order_date`,`order_hms`,`order_option`,`quantity`,`price`,`currency`,`order_num`,`order_state`,`img_url`,`memo`,`is_delete`,`is_success`,`is_send_server`,`detail_order_link`,`detail_prod_link`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderEntity value) {
                stmt.bindLong(1, (long)value._id);
                stmt.bindLong(2, (long)value.mId);
                stmt.bindLong(3, (long)value.uId);
                if (value.title == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.title);
                }
                Long _tmp = Converters.dateToTimestamp(value.orderDate);
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, _tmp.longValue());
                }
                Long _tmp_1 = Converters.dateToTimestamp(value.orderHms);
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, _tmp_1.longValue());
                }
                if (value.orderOption == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.orderOption);
                }
                stmt.bindLong(8, (long)value.quantity);
                stmt.bindDouble(9, value.price);
                if (value.currency == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.currency);
                }
                if (value.orderNum == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.orderNum);
                }
                if (value.orderState == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.orderState);
                }
                if (value.imgUrl == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.imgUrl);
                }
                if (value.memo == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.memo);
                }
                int _tmp_2 = value.isDelete ? 1 : 0;
                stmt.bindLong(15, (long)_tmp_2);
                int _tmp_3 = value.isSuccess ? 1 : 0;
                stmt.bindLong(16, (long)_tmp_3);
                int _tmp_4 = value.isSendServer ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_4);
                if (value.detailOrderLink == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.detailOrderLink);
                }
                if (value.detailProductLink == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.detailProductLink);
                }
            }
        };
        this.__preparedStmtOfHideOrder = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE orders SET is_delete = 1 WHERE _id = ?";
                return "UPDATE orders SET is_delete = 1 WHERE _id = ?";
            }
        };
        this.__preparedStmtOfDeleteOrder = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM orders WHERE _id = ?";
                return "DELETE FROM orders WHERE _id = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM orders";
                return "DELETE FROM orders";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(OrderEntity product) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfOrderEntity.insertAndReturnId((Object)product);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertList(List<OrderEntity> product) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfOrderEntity.insertAndReturnIdsList(product);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideOrder(int orderId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfHideOrder.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)orderId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfHideOrder.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrder(int orderId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteOrder.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)orderId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteOrder.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrderList(int limit) {
        String _sql = "SELECT * FROM orders WHERE is_delete = 0 ORDER BY order_date DESC, _id DESC LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM orders WHERE is_delete = 0 ORDER BY order_date DESC, _id DESC LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item = new OrderEntity();
                _item._id = _cursor.getInt(_cursorIndexOfId);
                _item.mId = _cursor.getInt(_cursorIndexOfMId);
                _item.uId = _cursor.getInt(_cursorIndexOfUId);
                _item.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item.orderDate = Converters.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item.orderHms = Converters.fromTimestamp(_tmp_1);
                _item.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item.isDelete = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item.isSuccess = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item.isSendServer = _tmp_4 != 0;
                _item.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrdersForViewMore(int limit, int lastOrderId, Date bottomOrderDate, int bottomOrderId) {
        String _sql = "SELECT * FROM orders WHERE is_delete = 0 AND _id <= ? AND (order_date < ? OR (order_date = ? AND _id < ?)) ORDER BY order_date DESC, _id DESC LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM orders WHERE is_delete = 0 AND _id <= ? AND (order_date < ? OR (order_date = ? AND _id < ?)) ORDER BY order_date DESC, _id DESC LIMIT ?", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)lastOrderId);
        _argIndex = 2;
        Long _tmp = Converters.dateToTimestamp(bottomOrderDate);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        _argIndex = 3;
        Long _tmp_1 = Converters.dateToTimestamp(bottomOrderDate);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp_1.longValue());
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)bottomOrderId);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item = new OrderEntity();
                _item._id = _cursor.getInt(_cursorIndexOfId);
                _item.mId = _cursor.getInt(_cursorIndexOfMId);
                _item.uId = _cursor.getInt(_cursorIndexOfUId);
                _item.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp_2 = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item.orderDate = Converters.fromTimestamp(_tmp_2);
                Long _tmp_3 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item.orderHms = Converters.fromTimestamp(_tmp_3);
                _item.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item.isDelete = _tmp_4 != 0;
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item.isSuccess = _tmp_5 != 0;
                int _tmp_6 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item.isSendServer = _tmp_6 != 0;
                _item.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastOrderId() {
        String _sql = "SELECT _id FROM orders ORDER BY _id DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT _id FROM orders ORDER BY _id DESC LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrderList(List<Long> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM orders WHERE _id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND is_delete = 0 ORDER BY order_date DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (Long _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindLong(_argIndex, _item.longValue());
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item_1 = new OrderEntity();
                _item_1._id = _cursor.getInt(_cursorIndexOfId);
                _item_1.mId = _cursor.getInt(_cursorIndexOfMId);
                _item_1.uId = _cursor.getInt(_cursorIndexOfUId);
                _item_1.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item_1.orderDate = Converters.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item_1.orderHms = Converters.fromTimestamp(_tmp_1);
                _item_1.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item_1.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item_1.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item_1.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item_1.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item_1.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item_1.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item_1.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item_1.isDelete = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item_1.isSuccess = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item_1.isSendServer = _tmp_4 != 0;
                _item_1.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item_1.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item_1);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrders(int ... mIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM orders WHERE mall_id IN (");
        int _inputSize = mIds.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND is_delete = 0 ORDER BY order_date DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (int _item : mIds) {
            _statement.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item_1 = new OrderEntity();
                _item_1._id = _cursor.getInt(_cursorIndexOfId);
                _item_1.mId = _cursor.getInt(_cursorIndexOfMId);
                _item_1.uId = _cursor.getInt(_cursorIndexOfUId);
                _item_1.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item_1.orderDate = Converters.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item_1.orderHms = Converters.fromTimestamp(_tmp_1);
                _item_1.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item_1.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item_1.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item_1.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item_1.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item_1.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item_1.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item_1.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item_1.isDelete = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item_1.isSuccess = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item_1.isSendServer = _tmp_4 != 0;
                _item_1.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item_1.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item_1);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrders(int mId) {
        String _sql = "SELECT * FROM orders WHERE mall_id = ? AND is_delete = 0 ORDER BY order_date DESC ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM orders WHERE mall_id = ? AND is_delete = 0 ORDER BY order_date DESC ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)mId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item = new OrderEntity();
                _item._id = _cursor.getInt(_cursorIndexOfId);
                _item.mId = _cursor.getInt(_cursorIndexOfMId);
                _item.uId = _cursor.getInt(_cursorIndexOfUId);
                _item.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item.orderDate = Converters.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item.orderHms = Converters.fromTimestamp(_tmp_1);
                _item.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item.isDelete = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item.isSuccess = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item.isSendServer = _tmp_4 != 0;
                _item.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderEntity> getOrdersForServer() {
        String _sql = "SELECT * FROM orders WHERE is_send_server = 0 AND is_delete = 0 ORDER BY order_date DESC LIMIT 30";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM orders WHERE is_send_server = 0 AND is_delete = 0 ORDER BY order_date DESC LIMIT 30", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memo");
            int _cursorIndexOfIsDelete = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_delete");
            int _cursorIndexOfIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_success");
            int _cursorIndexOfIsSendServer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_send_server");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_prod_link");
            ArrayList<OrderEntity> _result = new ArrayList<OrderEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                OrderEntity _item = new OrderEntity();
                _item._id = _cursor.getInt(_cursorIndexOfId);
                _item.mId = _cursor.getInt(_cursorIndexOfMId);
                _item.uId = _cursor.getInt(_cursorIndexOfUId);
                _item.title = _cursor.getString(_cursorIndexOfTitle);
                Long _tmp = _cursor.isNull(_cursorIndexOfOrderDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderDate));
                _item.orderDate = Converters.fromTimestamp(_tmp);
                Long _tmp_1 = _cursor.isNull(_cursorIndexOfOrderHms) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfOrderHms));
                _item.orderHms = Converters.fromTimestamp(_tmp_1);
                _item.orderOption = _cursor.getString(_cursorIndexOfOrderOption);
                _item.quantity = _cursor.getInt(_cursorIndexOfQuantity);
                _item.price = _cursor.getDouble(_cursorIndexOfPrice);
                _item.currency = _cursor.getString(_cursorIndexOfCurrency);
                _item.orderNum = _cursor.getString(_cursorIndexOfOrderNum);
                _item.orderState = _cursor.getString(_cursorIndexOfOrderState);
                _item.imgUrl = _cursor.getString(_cursorIndexOfImgUrl);
                _item.memo = _cursor.getString(_cursorIndexOfMemo);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDelete);
                _item.isDelete = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsSuccess);
                _item.isSuccess = _tmp_3 != 0;
                int _tmp_4 = _cursor.getInt(_cursorIndexOfIsSendServer);
                _item.isSendServer = _tmp_4 != 0;
                _item.detailOrderLink = _cursor.getString(_cursorIndexOfDetailOrderLink);
                _item.detailProductLink = _cursor.getString(_cursorIndexOfDetailProductLink);
                _result.add(_item);
            }
            ArrayList<OrderEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOrders(int ... orderId) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM orders WHERE _id IN (");
        int _inputSize = orderId.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (int _item : orderId) {
            _stmt.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteOrderForMallIds(int ... mallIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM orders WHERE mall_id IN (");
        int _inputSize = mallIds.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (int _item : mallIds) {
            _stmt.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIsSendServer(List<Integer> ids) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE orders SET is_send_server = 1 WHERE _id IN(");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (Integer _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindLong(_argIndex, (long)_item.intValue());
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

