/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.third_party.mart;

import android.content.Context;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistHomePlus;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistManager;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistScrapResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSvrType;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.ksp.mobilesdkjava.OUtilSystem.EH;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.third_party.mart.MartData;
import com.tenqube.visual_scraper.third_party.mart.MartScrapper;
import com.tenqube.visual_scraper.utils.AppExecutors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class MartScrapperImpl
implements MartScrapper {
    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;
    SDKAssistManager mgr = null;
    SDKAssistHomePlus mSdkHpCon = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MartScrapper getInstance(Context ctx) {
        Class<MartScrapperImpl> clazz = MartScrapperImpl.class;
        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private MartScrapperImpl(Context context) {
        this.context = context;
    }

    @Override
    public void init(ScrapService.Callback<String> callback) {
        if (this.isInit) {
            callback.onDataLoaded("");
        } else {
            this.appExecutors.diskIO().execute(() -> {
                String msg = "";
                this.mgr = new SDKAssistManager();
                File root_file = this.context.getFilesDir();
                String sdk_path = root_file.getAbsolutePath();
                try {
                    this.mgr.Init("visual", "4611948F-7E2D-420B-B2AC-6881356BB3EA", sdk_path, this.context, SDKAssistSvrType.e_SvrType.AZURE);
                    this.isInit = true;
                }
                catch (Exception e) {
                    msg = e.toString();
                }
                finally {
                    String finalMsg = msg;
                    this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
                }
            });
        }
    }

    @Override
    public void requestMobileAuthCode(String phoneNumber, String birth, String name, ScrapService.Callback<Boolean> onResult) throws Exception {
        this.appExecutors.diskIO().execute(() -> {
            try {
                this.mSdkHpCon = new SDKAssistHomePlus(phoneNumber, birth, name);
                this.mSdkHpCon.RequestMobileAuthCode();
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(false));
            }
        });
    }

    @Override
    public void startHomeplusLogin(String authCode, ScrapService.Callback<Boolean> onResult) throws Exception {
        this.appExecutors.diskIO().execute(() -> {
            try {
                EH.ThrowIfFail((this.mSdkHpCon != null ? 1 : 0) != 0, (String)"\uba3c\uc800 \ubaa8\ubc14\uc77c \uc778\uc99d\ucf54\ub4dc\ub97c \uc694\uccad\ud574\uc57c \ud569\ub2c8\ub2e4.", (Object[])new Object[0]);
                this.mSdkHpCon.LoginByMobileAuthCode(authCode);
                SDKAssistResult ret = this.mSdkHpCon.AddBuyerToSDKAssist();
                if (!ret.Success) {
                    throw ret.Ex;
                }
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(false));
            }
        });
    }

    @Override
    public void addUser(int mallId, String id, String password, ScrapService.Callback<String> callback) {
        this.appExecutors.diskIO().execute(() -> {
            String msg = "";
            try {
                e_MarketKeyCode keyCode = this.getMarketKeyCode(mallId);
                this.mgr.DeleteBuyer(keyCode, id);
                SDKAssistResult sDKAssistResult = this.mgr.AddBuyer(keyCode, id, password, true);
            }
            catch (Exception e) {
                msg = e.toString();
            }
            finally {
                String finalMsg = msg;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });
    }

    @Override
    public void start(int mallId, ScrapService.Callback<String> callback) {
        this.appExecutors.networkIO().execute(() -> {
            String msg = "";
            try {
                SDKAssistScrapResult sDKAssistScrapResult = this.mgr.ScrapReceipts();
            }
            catch (Exception e) {
                msg = e.toString();
            }
            finally {
                String finalMsg = msg;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });
    }

    @Override
    public void getMartItems(int mallId, ScrapService.Callback<List<MartData>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            ArrayList<MartData> results = new ArrayList<MartData>();
            try {
                ArrayList receiptList = this.mgr.GetScrapedReceiptList();
                if (receiptList != null) {
                    Timber.i((String)("ScrapManager" + receiptList.size()), (Object[])new Object[0]);
                    for (Receipt rr : receiptList) {
                        Timber.i((String)("ScrapManager mallId " + mallId), (Object[])new Object[0]);
                        Timber.i((String)("ScrapManager getMallId(rr.MartEnumKeyCode) " + this.getMallId(rr.MartEnumKeyCode)), (Object[])new Object[0]);
                        if (mallId != this.getMallId(rr.MartEnumKeyCode)) continue;
                        ArrayList productArrayList = this.mgr.GetReceiptProductListByKey(rr.ReceiptKey);
                        Timber.i((String)("ScrapManager productArrayList " + productArrayList.size()), (Object[])new Object[0]);
                        for (ReceiptProduct rp : productArrayList) {
                            Timber.i((String)("ScrapManager BuyDate " + rp.BuyDate), (Object[])new Object[0]);
                            Timber.i((String)("ScrapManager InsertDate " + rp.InsertDate), (Object[])new Object[0]);
                            MartData martData = new MartData();
                            martData.barcode = rp.Barcode;
                            martData.buyCount = rp.BuyCount;
                            martData.buyDate = rp.BuyDate;
                            martData.insertDate = rp.InsertDate;
                            martData.name = rp.ProductName;
                            martData.price = rp.UnitPrice.doubleValue();
                            martData.receiptKey = rp.ReceiptKey;
                            martData.receiptProductKey = rp.ReceiptProductKey;
                            martData.orderAmount = rp.OrderAmount.toBigInteger().intValue();
                            results.add(martData);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
        });
    }

    private int getMallId(e_MarketKeyCode martKey) {
        if (martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.getMallId();
        }
        if (martKey == e_MarketKeyCode.EMartApp) {
            return Constants.MALL.Emart.getMallId();
        }
        if (martKey == e_MarketKeyCode.HomePlus) {
            return Constants.MALL.Homeplus.getMallId();
        }
        return -1;
    }

    private e_MarketKeyCode getMarketKeyCode(int mallId) {
        if (mallId == Constants.MALL.Emart.getMallId()) {
            return e_MarketKeyCode.EMartApp;
        }
        if (mallId == Constants.MALL.Homeplus.getMallId()) {
            return e_MarketKeyCode.HomePlus;
        }
        return e_MarketKeyCode.LotteMCoupon;
    }
}

