/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.mall.FactoryMall;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.third_party.mart.MartData;
import com.tenqube.visual_scraper.third_party.mart.MartScrapper;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import timber.log.Timber;

public class ScrapManager {
    private static ScrapManager sInstance;
    public static final String HANDLER_MSG_ERROR = "error";
    public static final String HANDLER_MSG = "msg";
    public static final String HANDLER_MSG_MALL_ID = "mallId";
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAXIMUM_POOL_SIZE = 4;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private BlockingQueue<Runnable> mParserWorkQueue;
    private ThreadPoolExecutor mParserThreadPool;
    private final ScrapRepository repository;
    private final Handler handler;
    private ScrapService.OnResultCallback<Integer> callback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapManager getInstance(ScrapRepository repository, Handler handler) {
        if (sInstance != null) return sInstance;
        Class<ScrapManager> clazz = ScrapManager.class;
        synchronized (ScrapManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapManager(repository, handler);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setCallback(ScrapService.OnResultCallback<Integer> callback) {
        this.callback = callback;
    }

    private ScrapManager(ScrapRepository repository, Handler handler) {
        this.repository = repository;
        this.handler = handler;
        this.mParserWorkQueue = new LinkedBlockingQueue<Runnable>();
        this.mParserThreadPool = new ThreadPoolExecutor(2, 4, 10L, KEEP_ALIVE_TIME_UNIT, this.mParserWorkQueue);
    }

    private void sendMsg(@Nullable Handler handler, Constants.ScrapState state, Constants.ERROR error, String msg, int mallId) {
        if (this.callback != null) {
            if (state == Constants.ScrapState.SUCCESS) {
                this.callback.onDataLoaded(mallId);
            } else {
                this.callback.onFail(mallId, error, msg);
            }
        }
        Thread.interrupted();
    }

    void startScrap(MallWithUser mallWithUser, MartScrapper martScrapper, boolean shouldInsert) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                martScrapper.init(msg -> {
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, (String)msg, mallWithUser.mall.getId());
                        return;
                    }
                    if (mallWithUser.mall.getId() != Constants.MALL.Homeplus.getMallId()) {
                        martScrapper.addUser(mallWithUser.mall.getId(), mallWithUser.user.getUserId(), mallWithUser.user.getUserPwd().getValue(), userMsg -> {
                            if (!TextUtils.isEmpty((CharSequence)userMsg)) {
                                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, (String)userMsg, mallWithUser.mall.getId());
                                return;
                            }
                            mallWithUser.user.setLogin(true);
                            this.repository.insertUsers(mallWithUser.user, uId -> {
                                mallWithUser.user.setId((int)uId);
                                this.startParsing(mallWithUser, martScrapper);
                            });
                        });
                    } else {
                        mallWithUser.user.setLogin(true);
                        this.repository.insertUsers(mallWithUser.user, uId -> {
                            mallWithUser.user.setId((int)uId);
                            this.startParsing(mallWithUser, martScrapper);
                        });
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    private void startParsing(MallWithUser mallWithUser, MartScrapper martScrapper) {
        martScrapper.start(mallWithUser.mall.getId(), scrapMsg -> {
            if (!TextUtils.isEmpty((CharSequence)scrapMsg)) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, (String)scrapMsg, mallWithUser.mall.getId());
                return;
            }
            martScrapper.getMartItems(mallWithUser.mall.getId(), martItems -> {
                ArrayList<OrderEntity> results = new ArrayList<OrderEntity>();
                for (MartData mart : martItems) {
                    results.add(mart.toEntity(mallWithUser.mall.getId(), mallWithUser.user.getId()));
                }
                this.repository.insertOrders(results, insertedList -> {
                    long lastScrapAt = Utils.getLastScrapAt();
                    this.repository.updateUserLastScrapAt(lastScrapAt, mallWithUser.mall.getId(), mallWithUser.user.getUserId());
                    this.repository.callInsertOrderList();
                    this.sendMsg(this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mallWithUser.mall.getId());
                });
            });
        });
    }

    void startScrap(MallWithUser mallWithUser, WebViewManager webViewManager, boolean shouldInsert) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Timber.i((String)("loginMallWithUser : " + mallWithUser), (Object[])new Object[0]);
                this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
                    Timber.i((String)("loginloginRule : " + loginRule), (Object[])new Object[0]);
                    Mall m = FactoryMall.create(new MallData(mallWithUser.mall.getId(), mallWithUser.mall.getName(), mallWithUser.mall.getDisplayName()), this.repository, webViewManager);
                    Timber.i((String)("loginMall : " + m), (Object[])new Object[0]);
                    if (m == null) {
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.EMPTY_MALL, "empty factory mall", mallWithUser.mall.getId());
                        return;
                    }
                    webViewManager.setMall(m);
                    if (loginRule != null && loginRule.loginWebRule != null) {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc874\uc7ac, startWebViewLogin", (Object[])new Object[0]);
                        m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, shouldInsert, new ScrapService.OnResult<List<OrderEntity>>(){

                            @Override
                            public void onSuccess(int mId, List<OrderEntity> items, String msg) {
                                ScrapManager.this.repository.callInsertOrderList();
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mId);
                            }

                            @Override
                            public void onFail(int mId, Constants.ERROR error, String msg) {
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.FAIL, error, msg, mId);
                            }
                        });
                    } else {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c ", (Object[])new Object[0]);
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, "\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c", mallWithUser.mall.getId());
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    static {
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    }
}

