/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;

public class ElevenStreet
extends Mall {
    private final String PRODUCT_URL = "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s&xfrom=&xzone=";

    public ElevenStreet(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderDate)) {
                String date = orderDate.substring(0, orderDate.indexOf("(") - 1);
                return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderNum) && orderNum.length() > 1) {
                String filteredOrderNum = orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")"));
                return filteredOrderNum;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        int result = 1;
        try {
            if (!TextUtils.isEmpty((CharSequence)quantity)) {
                result = Integer.parseInt(quantity.substring(quantity.indexOf("(") + 1, quantity.indexOf(")")).replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replaceAll("\uc6d0", "").replaceAll(",", ""));
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        int index = imgUrl.indexOf("/pd/");
        return index != -1 ? "http://image.11st.co.kr" + imgUrl.substring(index) : imgUrl;
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        if (url.contains("/login/PwdCampaign.tmall")) {
            return false;
        }
        if (url.contains("login.tmall")) {
            return true;
        }
        return url.contains("login");
    }
}

