package com.tenqube.visual_scraper.mall;

import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;


public class FactoryMall {

    public static Mall create(@NonNull MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {

        switch (mallData.getKeyName()) {

            case Constants.DEFAULT_MALL.Auction:
                return new Auction(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Coupang:
                return new Coupang(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.ElevenStreet:
                return new ElevenStreet(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gmarket:
                return new Gmarket(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gshome:
                return new Gshome(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Hmall:
                return new Hmall(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Interpark:
                return new Interpark(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.LotteHome:
                return new LotteHome(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.NaverPay:
                return new Naver(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Tmon:
                return new Tmon(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Wemake:
                return new Wemake(mallData, repository, webViewManager);

            case Constants.DEFAULT_MALL.Amazon:
                return new Amazon(mallData, repository, webViewManager);
        }


        return null;

    }


}
