/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.webkit.WebView;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapManager;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.query.Password;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.List;
import java.util.Locale;
import timber.log.Timber;

public class ScrapServiceImpl
implements ScrapService {
    public Context context;
    private ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager mWebViewManager;
    private ScrapService.DataInteraction dataInteraction;
    public static Locale locale;
    private ScrapManager scrapManager;
    private SparseBooleanArray progressStateArray = new SparseBooleanArray();
    private Handler handler;
    private ScrapService.OnResultCallback<Integer> mCallback;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @NonNull ScrapService.DataInteraction dataInteraction) throws ParameterException {
        if (context == null) {
            throw new ParameterException("context is null");
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is empty");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier)) {
            throw new ParameterException("qualifier is empty");
        }
        if (dataInteraction == null) {
            throw new ParameterException("dataInteraction is empty");
        }
        this.context = context;
        this.dataInteraction = dataInteraction;
        this.initLocale();
        this.preferences = Injection.provideSharedPreference(context);
        this.preferences.edit().putString("layer", qualifier).apply();
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.handler = this.createHandler();
        this.scrapManager = ScrapManager.getInstance(this.repository, this.handler);
        if (qualifier.equals("dev")) {
            Timber.plant((Timber.Tree)new Timber.DebugTree());
        }
        this.singUp();
        this.syncRule(null);
    }

    private void singUp() {
        if (!this.preferences.getString("uuid", "").equals(this.dataInteraction.getUid())) {
            this.dataInteraction.getAdId(adId -> {
                String appName = this.dataInteraction.getServiceAppName();
                if (TextUtils.isEmpty((CharSequence)appName)) {
                    return;
                }
                String uid = this.dataInteraction.getUid();
                if (TextUtils.isEmpty((CharSequence)uid)) {
                    return;
                }
                this.repository.signUpUser(appName, uid, (String)adId, items -> {
                    Timber.i((String)"appName :%s", (Object[])new Object[]{appName});
                    Timber.i((String)"uid: %s", (Object[])new Object[]{uid});
                    Timber.i((String)"adId: %s", (Object[])new Object[]{adId});
                });
            });
        }
    }

    private void initLocale() {
        locale = Build.VERSION.SDK_INT >= 24 ? this.context.getResources().getConfiguration().getLocales().get(0) : this.context.getResources().getConfiguration().locale;
    }

    @Override
    public void initialize() {
        this.repository.initialize();
    }

    @Override
    public WebView getWebView() {
        return this.mWebViewManager.getWebView();
    }

    @Override
    public void startLoginAndParsing(final String userId, final String userPwd, final int mId, final MallViewService mallViewService, ScrapService.OnResultCallback<Integer> onResult) throws ParameterException {
        Timber.i((String)("startLoginAndParsing = " + userId + "/" + mId + "/" + userPwd), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userPwd) || mId == 0) {
            throw new ParameterException("empty parameter");
        }
        this.progressStateArray.put(mId, true);
        this.repository.checkIsActiveMall(mId, mall -> {
            Timber.i((String)"checkIsActiveMall : %s %s", (Object[])new Object[]{mId, mall});
            if (mall == null) {
                onResult.onFail(mId, Constants.ERROR.EMPTY_MALL, "empty mall");
                return;
            }
            Timber.i((String)"checkIsActiveMall : !!", (Object[])new Object[0]);
            this.mCallback = onResult;
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    Timber.i((String)"item : %s", (Object[])new Object[]{item});
                    MallWithUser mallWithUser = new MallWithUser(item.mall, new UserEntity(mId, userId, new Password(userPwd)));
                    ScrapServiceImpl.this.startScrap(mallWithUser, ScrapServiceImpl.this.createWebViewManager(mallViewService), true);
                }

                @Override
                public void onFail() {
                    Timber.i((String)"mId : %s", (Object[])new Object[]{mId});
                    MallWithUser mallWithUser = new MallWithUser(mall, new UserEntity(mId, userId, new Password(userPwd)));
                    ScrapServiceImpl.this.startScrap(mallWithUser, ScrapServiceImpl.this.createWebViewManager(mallViewService), true);
                }
            });
        });
    }

    private WebViewManager createWebViewManager(@Nullable MallViewService mallViewService) {
        this.mWebViewManager = new WebViewManager(this.context, mallViewService);
        return this.mWebViewManager;
    }

    private void startScrap(MallWithUser mallWithUser, WebViewManager webViewManager, boolean shouldInsert) {
        this.scrapManager.startScrap(mallWithUser, webViewManager, shouldInsert);
    }

    private Handler createHandler() {
        return new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Constants.ScrapState value = Constants.ScrapState.values()[msg.what];
                Bundle bundle = msg.getData();
                String errMsg = bundle.getString("msg");
                int mallId = bundle.getInt("mallId");
                int errorCode = bundle.getInt("error");
                Constants.ERROR error = Constants.ERROR.values()[errorCode];
                ScrapServiceImpl.this.progressStateArray.put(mallId, false);
                switch (value) {
                    case SUCCESS: {
                        if (ScrapServiceImpl.this.mCallback == null) break;
                        ScrapServiceImpl.this.mCallback.onDataLoaded(mallId);
                        break;
                    }
                    default: {
                        if (ScrapServiceImpl.this.mCallback == null) break;
                        ScrapServiceImpl.this.mCallback.onFail(mallId, error, errMsg);
                    }
                }
            }
        };
    }

    @Override
    public void startParsingMalls() {
        if (DateUtils.checkDiffTime(this.preferences.getLong("CHECK_PARSING_TIME", 0L), this.preferences.getInt("PARSING_FREQUENCY", 10))) {
            this.syncRule(null);
            Timber.i((String)"parsing checkDiffTime true", (Object[])new Object[0]);
            this.preferences.edit().putLong("CHECK_PARSING_TIME", System.currentTimeMillis()).apply();
            this.repository.getMallWithActiveUsers(items -> {
                Timber.i((String)("getMallsAndParsingitem : " + items), (Object[])new Object[0]);
                for (MallWithUser mallWithUser : items) {
                    Timber.i((String)("getMallsAndParsingmallWithUser : " + mallWithUser), (Object[])new Object[0]);
                    this.startScrap(mallWithUser, this.createWebViewManager(null), false);
                }
            });
        }
    }

    private void syncRule(@Nullable ScrapService.onResultInterface<Void> callback) {
        this.repository.syncRule(callback);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    @Override
    public void getOrderList(int limit, ViewMoreInfo viewMoreInfo, ScrapService.OnResultCallback<List<OrderInfo>> callback) {
        this.repository.getOrderList(limit, viewMoreInfo, callback::onDataLoaded);
    }

    @Override
    public void getMallWithUsers(final ScrapService.Callback<List<MallWithUser>> callback) {
        this.syncRule(new ScrapService.onResultInterface<Void>(){

            @Override
            public void onDataLoaded(Void item) {
                ScrapServiceImpl.this.loadMalls(callback);
            }

            @Override
            public void onFail() {
                ScrapServiceImpl.this.loadMalls(callback);
            }
        });
    }

    private void loadMalls(ScrapService.Callback<List<MallWithUser>> callback) {
        this.repository.getMallWithUser(items -> {
            for (MallWithUser mallWithUser : items) {
                mallWithUser.setProgress(this.progressStateArray.get(mallWithUser.mall.getId()));
            }
            callback.onDataLoaded((List<MallWithUser>)items);
        });
    }

    @Override
    public void signOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        this.repository.deleteOrderByMallIds(mId);
        this.repository.deleteUsersByMallId(mId);
    }

    @Override
    public void hideOrder(int orderId) {
        this.repository.hideOrder(orderId);
    }

    @Override
    public void deleteOrder(int orderId) {
        this.repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrdersByOrderIds(int ... orderIds) {
        this.repository.deleteOrders(orderIds);
    }

    @Override
    public void deleteAllOrders() {
        this.repository.deleteAllOrders();
    }

    @Override
    public void deleteOrderByMallIds(int ... mIds) {
        this.repository.deleteOrderByMallIds(mIds);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        this.repository.insertUsers(userEntity);
    }

    @Override
    public void setParsingFrequency(int frequency) {
        this.preferences.edit().putInt("PARSING_FREQUENCY", frequency).apply();
    }

    @Override
    public void getLastOrderId(ScrapService.Callback<Integer> callback) {
        this.repository.getLastOrderId(callback);
    }
}

