package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.arch.persistence.room.TypeConverters;
import android.support.annotation.Nullable;

import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;

import java.io.Serializable;

@Entity(tableName = "login_web_rules",
        indices = {@Index(value = {"mall_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id")})
@TypeConverters({QueryRuleConverter.class, OrderRuleConverter.class})
public class LoginWebRule implements Serializable {


    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @Nullable
    @ColumnInfo(name = "web_url")
    private final QueryRuleBody url;

    @Nullable
    @ColumnInfo(name = "loginScripts")
    private final QueryRuleBody loginScripts;
//
//    @ColumnInfo(name = "is_captcha_on")
//    public final int isCaptchaOn;

    @ColumnInfo(name = "captcha_container")
    private final ParsingOrderRules captchaContainer;

    @ColumnInfo(name = "fail_message")
    private final ParsingOrderRules failMessage;



    // 생성시 스크립트 gson 변환
    public LoginWebRule(int mallId,
                        @Nullable QueryRuleBody url,
                        @Nullable QueryRuleBody loginScripts,
                        ParsingOrderRules captchaContainer,
                        ParsingOrderRules failMessage/*, int isCaptchaOn*/) {
        this.mallId = mallId;
        this.url = url;
        this.loginScripts = loginScripts;
        this.captchaContainer = captchaContainer;
        this.failMessage = failMessage;
//        this.isCaptchaOn = isCaptchaOn;
    }

    public int getId() {
        return id;
    }

    public int getMallId() {
        return mallId;
    }

    @Nullable
    public QueryRuleBody getUrl() {
        return url;
    }

    @Nullable
    public QueryRuleBody getLoginScripts() {
        return loginScripts;
    }

    public void setId(int id) {
        this.id = id;
    }


    public ParsingOrderRules getCaptchaContainer() {
        return captchaContainer;
    }

    public ParsingOrderRules getFailMessage() {
        return failMessage;
    }

    @Override
    public String toString() {
        return "LoginWebRule{" +
                "id=" + id +
                ", mallId='" + mallId + '\'' +
                ", url='" + url + '\'' +
                ", loginScripts='" + loginScripts + '\'' +
                ", captchaContainer='" + captchaContainer + '\'' +
                ", failMessage='" + failMessage + '\'' +

                '}';
    }
}
