/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.Timer;
import java.util.TimerTask;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import timber.log.Timber;

public class WebViewManager {
    private static final long TIMEOUT_TIMEMILLIS = 30000L;
    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;
    private WebViewCallback callback;
    private Timer timer;
    private Timer tempTimer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();
    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;
    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;
    private MallViewService mallViewService;
    private boolean isVisibleWebView;
    private boolean isLoginFinished;
    private boolean isCheckedCaptcha;
    private boolean isClosedWebView;

    @SuppressLint(value={"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, MallViewService mallViewService) {
        this.context = context;
        this.handler = new Handler();
        this.mallViewService = mallViewService;
        this.initWebView();
    }

    public void setViewService(MallViewService mallViewService) {
        this.mallViewService = mallViewService;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = new WebView(this.context);
        this.webView.clearCache(true);
        this.webView.clearHistory();
        Utils.clearCookies(this.context);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        this.webView.addJavascriptInterface((Object)new ScriptInterface(), "HtmlViewer");
        this.webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.getSettings().setMixedContentMode(2);
        }
        this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.webView.getSettings().setSupportZoom(true);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.webView.setLayerType(1, null);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Timber.i((String)("onReceivedErrorerror : " + error), (Object[])new Object[0]);
                WebViewManager.this.stopTimer();
                if (Build.VERSION.SDK_INT >= 23 && error != null) {
                    Timber.i((String)("onReceivedErrorerror : " + error.getErrorCode()), (Object[])new Object[0]);
                    switch (error.getErrorCode()) {
                        case -10: {
                            return;
                        }
                        case -15: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                    }
                }
                WebViewManager.this.onFailReceivedError(error);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Timber.i((String)("onPageFinishedurl : " + url), (Object[])new Object[0]);
                WebViewManager.this.onPageFinishedCallback(view, url);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Timber.i((String)"shouldOverrideUrlLoading [1] : %s", (Object[])new Object[]{url});
                return WebViewManager.this.checkUrlForShouldOverride(url);
            }

            @TargetApi(value=24)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = request.getUrl().toString();
                Timber.i((String)"shouldOverrideUrlLoading [2] : %s", (Object[])new Object[]{url});
                return WebViewManager.this.checkUrlForShouldOverride(url);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Timber.i((String)("onJsAlertmessage : " + message + "url : " + url), (Object[])new Object[0]);
                if (!"LotteHome".equals(((WebViewManager)WebViewManager.this).mall.mallData.getKeyName())) {
                    WebViewManager.this.loginFailed(message);
                }
                Toast.makeText((Context)WebViewManager.this.context, (CharSequence)message, (int)0).show();
                result.confirm();
                return true;
            }
        });
    }

    private boolean checkUrlForShouldOverride(String url) {
        if ("LotteHome".equals(this.mall.mallData.getKeyName()) && url.contains("https://secure.lotteimall.com/member/login/forward.LCLoginFailProc.lotte")) {
            this.loginFailed("\uc544\uc774\ub514\uc640 \ube44\ubc00\ubc88\ud638\ub97c \ud655\uc778\ud558\uace0 \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.");
        }
        return false;
    }

    private void onFailReceivedError(WebResourceError error) {
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                if (this.isClosedWebView) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 23) {
                    this.callback.onFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    this.callback.onFail(403, error.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.callback.onFail(403, "error");
            }
        });
    }

    private void onPageFinishedCallback(WebView view, String url) {
        if (this.action == 1 && this.isLoginFinished) {
            return;
        }
        if ("https://finish/".equals(url)) {
            return;
        }
        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        }
        view.setTag((Object)url);
        if (this.mall.shouldPassFinishedWebPages(url)) {
            return;
        }
        this.stopTimer();
        if (this.scripts != null) {
            this.loadScripts(this.scripts);
            this.tempScripts = this.scripts;
            this.scripts = null;
            this.isFinishedCallback = true;
        } else if (this.action == 1) {
            if (url.contains(this.webUrl) || this.mall.identifyLoginPageOrNot(url)) {
                Timber.i((String)("scripts fail!! " + this.failedCnt + " " + this.isVisibleWebView), (Object[])new Object[0]);
                if (this.isVisibleWebView) {
                    return;
                }
                if (this.mall.shouldShowWebView(url)) {
                    Timber.i((String)"shouldShowWebView true", (Object[])new Object[0]);
                    this.showWebView();
                    return;
                }
                if (this.mall.doCheckLoginError() || this.mall.doCheckLoginCaptcha() && !this.isVisibleWebView && !this.isCheckedCaptcha) {
                    this.getLoginHtml();
                } else if (!this.isVisibleWebView) {
                    this.retryLogin();
                }
            } else {
                Timber.i((String)("scripts success!!isVisibleWebView : " + this.isVisibleWebView), (Object[])new Object[0]);
                this.failedCnt = 0;
                if (this.isVisibleWebView) {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        if (this.mallViewService != null) {
                            this.mallViewService.setWebView(this.webView, 8);
                        }
                        this.isVisibleWebView = false;
                    });
                }
                this.finish();
            }
        } else {
            if (this.action == 2 && (url.contains("main") || url.contains("Home") || url.contains("www.naver.com"))) {
                Timber.i((String)"pagePass!!!!!!!", (Object[])new Object[0]);
                return;
            }
            this.failedCnt = 0;
            this.finish();
        }
    }

    private void retryLogin() {
        ++this.failedCnt;
        Timber.i((String)("retryLoginfailedCnt : " + this.failedCnt), (Object[])new Object[0]);
        if (this.failedCnt == 4) {
            new Handler(Looper.getMainLooper()).post(() -> {
                this.callback.onFail(400, this.mall.mallData.getDisplayName() + "\uc870\ud68c \uc2e4\ud328");
                this.closeWebView();
            });
            return;
        }
        if (this.failedCnt == 2 && this.mall.mallData.getKeyName().equalsIgnoreCase("Amazon")) {
            int pos = this.tempScripts.indexOf(";");
            if (this.tempScripts.length() > pos) {
                this.tempScripts = "javascript:" + this.tempScripts.substring(pos + 1, this.tempScripts.length());
            }
            Timber.i((String)("retryLogintempScripts : " + this.tempScripts + "pos: " + pos), (Object[])new Object[0]);
        }
        this.loadScripts(this.tempScripts);
    }

    private void finish() {
        Timber.i((String)("webviewfinish " + this.action), (Object[])new Object[0]);
        if (this.callback != null) {
            switch (this.action) {
                case 0: {
                    this.callback.onResult(this.webUrl, this.webView);
                    break;
                }
                case 1: {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        if (this.mallViewService != null) {
                            this.mallViewService.notifyInProgressStatus(this.mall.mallData.getDisplayName() + " \uc1fc\ud551 \ub0b4\uc5ed\uc744 \ubd88\ub7ec\uc624\uace0 \uc788\uc2b5\ub2c8\ub2e4");
                        }
                        this.failedCnt = 0;
                        this.isLoginFinished = true;
                        this.callback.onResult(null, this.webView);
                    });
                    break;
                }
                case 2: {
                    this.getHtml();
                }
            }
        }
    }

    private boolean findCapchaImage(Document document) {
        this.isCheckedCaptcha = true;
        if (this.mall.checkCaptchaImage(document)) {
            Timber.i((String)"checkHTMLcaptcha", (Object[])new Object[0]);
            this.showWebView();
            return true;
        }
        return false;
    }

    private void showWebView() {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.mallViewService != null) {
                this.isVisibleWebView = true;
                this.mallViewService.setWebView(this.webView, 0);
            } else {
                this.callback.onFail(403, "login fail");
                this.closeWebView();
            }
        });
    }

    @JavascriptInterface
    private void getHtml() {
        this.webView.loadUrl("javascript:window.HtmlViewer.showHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    private void getLoginHtml() {
        Timber.i((String)"getLoginHtml!!", (Object[])new Object[0]);
        this.handler.post(() -> this.webView.loadUrl("javascript:window.HtmlViewer.checkHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');"));
    }

    private void loginFailed(String error) {
        new Handler(Looper.getMainLooper()).post(() -> {
            this.isLoginFinished = true;
            this.stopTimer();
            this.callback.onFail(400, error);
            this.closeWebView();
        });
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (this.webUrl != null) {
            this.isLoginFinished = false;
            this.isClosedWebView = false;
            this.loadWebView(this.webUrl, false);
        } else {
            callback.onFail(403, "webUrl does not exist");
            this.closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;
        if (mall.mallData != null && "LotteHome".equals(mall.mallData.getKeyName())) {
            this.webView.getSettings().setSupportMultipleWindows(true);
        }
    }

    private void loadScripts(String scripts) {
        try {
            Timber.i((String)("loadScriptsscripts \uc2e4\ud589 " + scripts), (Object[])new Object[0]);
            this.loadWebView(scripts, true);
            this.tempTimer = this.timer;
            Timber.i((String)("TESTtemp : " + this.tempTimer + "//" + this.timer + "/" + this.timerTask), (Object[])new Object[0]);
            if (this.failedCnt > 2) {
                return;
            }
            int delayMillis = 10000;
            this.handler.postDelayed(() -> {
                Timber.i((String)("TESTTtemp : " + this.tempTimer + "//" + this.timer + "/" + this.timerTask), (Object[])new Object[0]);
                if (this.action == 1 && this.timer != null) {
                    Timber.i((String)"loadScriptsOnPageFinished \uc548\uc6b8\ub9bc , \ub85c\uadf8\uc778 \uc624\ub958 \uccb4\ud06c ", (Object[])new Object[0]);
                    this.stopTimer();
                    this.getLoginHtml();
                }
                if (this.action == 2 && this.timer != null && this.mall.doParsingMall()) {
                    this.stopTimer();
                    if (this.isFinishedCallback) {
                        this.finish();
                    }
                }
            }, 6000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.onFail(403, e.toString());
            this.closeWebView();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Timber.i((String)("loadWebViewurl :" + urlOrScripts + " //\nisScript : " + isScripts + "//" + this.scripts), (Object[])new Object[0]);
        this.startTimer();
        this.handler.postDelayed(() -> {
            this.mall.setWebviewSettings(this.action, this.webView);
            this.webView.loadUrl(urlOrScripts, null);
        }, 500L);
    }

    private void closeWebView() {
        Timber.i((String)"closeWebView!!", (Object[])new Object[0]);
        if (this.webView != null) {
            this.handler.post(() -> {
                if (this.action == 1) {
                    this.isLoginFinished = true;
                }
                this.failedCnt = 0;
                this.isFinishedCallback = false;
                this.isClosedWebView = true;
            });
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    public WebView getWebView() {
        return this.webView;
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewManager.this.mTimerHandler.post(() -> {
                    Timber.i((String)("TimeOutaction : " + WebViewManager.this.action + "/url : " + WebViewManager.this.webUrl + " scripts : " + WebViewManager.this.scripts), (Object[])new Object[0]);
                    WebViewManager.this.stopTimer();
                    if (WebViewManager.this.isFinishedCallback) {
                        WebViewManager.this.finish();
                        return;
                    }
                    WebViewManager.this.closeWebView();
                    WebViewManager.this.callback.onFail(403, "Timeout Fail");
                });
            }
        };
        this.timer.schedule(this.timerTask, 30000L);
    }

    public static interface WebViewCallback {
        public void onResult(String var1, WebView var2);

        public void onFail(int var1, String var2);
    }

    class ScriptInterface {
        ScriptInterface() {
        }

        @JavascriptInterface
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void showHTML(String html) {
            if (WebViewManager.this.callback != null) {
                WebViewManager.this.callback.onResult(html, WebViewManager.this.webView);
                WebViewManager.this.mallViewService.notifyInProgressStatus(((WebViewManager)WebViewManager.this).mall.mallData.getDisplayName() + " \uc870\ud68c \uc644\ub8cc");
                WebViewManager.this.closeWebView();
            }
        }

        @JavascriptInterface
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void checkHTML(String html) {
            Document document = Jsoup.parse((String)html);
            if (document == null) {
                return;
            }
            if (WebViewManager.this.mall.doCheckLoginError()) {
                String error = WebViewManager.this.mall.checkLoginError(document);
                Timber.i((String)("checkHTMLerror : " + error), (Object[])new Object[0]);
                if (!TextUtils.isEmpty((CharSequence)error)) {
                    WebViewManager.this.loginFailed(error);
                } else if (WebViewManager.this.mall.doCheckLoginCaptcha()) {
                    if (!WebViewManager.this.findCapchaImage(document)) {
                        WebViewManager.this.retryLogin();
                    }
                } else {
                    WebViewManager.this.retryLogin();
                }
            } else if (WebViewManager.this.mall.doCheckLoginCaptcha() && !WebViewManager.this.findCapchaImage(document)) {
                WebViewManager.this.retryLogin();
            }
        }
    }
}

