package com.tenqube.visual_scraper.db.converter;

import android.arch.persistence.room.TypeConverter;

import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.utils.Utils;

public class OrderRuleConverter {

    @TypeConverter
    public static String fromOrderRules(ParsingOrderRules rule) {
        return rule == null ? null : Utils.toJson(rule);
    }

    @TypeConverter
    public static ParsingOrderRules toParsingOrderRule(String rule) {
        return rule == null ? null : Utils.parseJsonObject(rule, ParsingOrderRules.class);
    }

}
