package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import java.io.Serializable;

@Entity(tableName = "order_api_rule",
        indices = {@Index(value = {"mall_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id")})
public class OrderApiRuleJson implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mId;

    @ColumnInfo(name = "url")
    private final String url;

    @ColumnInfo(name = "request_body")
    private final String requestBody;

    @ColumnInfo(name = "request_method")
    private final int requestMethod;

    @ColumnInfo(name = "container")
    private final String container;

    @NonNull
    @ColumnInfo(name = "title")
    private final String title;

    @ColumnInfo(name = "order_date")
    private final String orderDate;

    @ColumnInfo(name = "order_hms")
    private final String orderHms;

    @ColumnInfo(name = "order_option")
    private final String orderOption;

    @NonNull
    @ColumnInfo(name = "quantity")
    private final String quantity;

    @NonNull
    @ColumnInfo(name = "price")
    private final String price;

    @NonNull
    @ColumnInfo(name = "order_num")
    private final String orderNum;

    @ColumnInfo(name = "order_state")
    private final String orderState;

    @ColumnInfo(name = "img_url")
    private final String imgUrl;

    public OrderApiRuleJson(int mId, String url, String requestBody, int requestMethod, String container, @NonNull String title, @NonNull String orderDate, @NonNull String orderHms, @NonNull String orderOption, @NonNull String quantity, @NonNull String price, @NonNull String orderNum, @NonNull String orderState, @NonNull String imgUrl) {
        this.mId = mId;
        this.url = url;
        this.requestBody = requestBody;
        this.requestMethod = requestMethod;
        this.container = container;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
    }

    public int getmId() {
        return mId;
    }

    public int getId() {
        return id;
    }

    public String getUrl() {
        return url;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    public String getContainer() {
        return container;
    }

    @NonNull
    public String getTitle() {
        return title;
    }

    public String getOrderDate() {
        return orderDate;
    }

    public String getOrderHms() {
        return orderHms;
    }

    public String getOrderOption() {
        return orderOption;
    }

    @NonNull
    public String getQuantity() {
        return quantity;
    }

    @NonNull
    public String getPrice() {
        return price;
    }

    @NonNull
    public String getOrderNum() {
        return orderNum;
    }

    public String getOrderState() {
        return orderState;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    @Override
    public String toString() {
        return "OrderApiRuleJson{" +
                "id=" + id +
                ", mId=" + mId +
                ", url='" + url + '\'' +
                ", requestBody='" + requestBody + '\'' +
                ", requestMethod=" + requestMethod +
                ", container='" + container + '\'' +
                ", title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity='" + quantity + '\'' +
                ", price='" + price + '\'' +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                '}';
    }
}
