/*
 * Copyright 2017, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Query;

import com.tenqube.visual_scraper.model.query.MallWithUser;

import java.util.List;


@Dao
public interface MallWithUserDao {


    @Query("SELECT * " +
            "FROM malls AS mallInfo " +
            "INNER JOIN users AS userInfo ON userInfo.mall_id = mallInfo.m_id " +
            "WHERE mallInfo.m_id = :mId " +
            "AND userInfo.user_id = :uId ")
    MallWithUser getInfo(int mId, String uId);

    @Query("SELECT * " +
            "FROM malls AS mallInfo " +
            "JOIN users AS userInfo ON userInfo.mall_id = mallInfo.m_id " +
            "WHERE is_active = 1 AND is_login = 1")
    List<MallWithUser> getInfosForActiveUser();

    @Query("SELECT * " +
            "FROM malls AS mallInfo " +
            "LEFT JOIN users AS userInfo ON userInfo.mall_id = mallInfo.m_id " +
            "WHERE is_active = 1 AND (is_login is NULL OR is_login = 1)" +
            "GROUP BY mallInfo.m_id")
    List<MallWithUser> getInfosForUser();

    @Query("SELECT * " +
            "FROM malls AS mallInfo " +
            "LEFT JOIN users AS userInfo ON userInfo.mall_id = mallInfo.m_id " +
            "WHERE mall_id = :mallId AND is_active = 1 AND is_login = 1")
    MallWithUser getInfoForActiveUser(int mallId);

}
