/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.crawler.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tenqube.visual_scraper.crawler.ScrapInterface;
import java.util.Timer;
import java.util.TimerTask;

public class WebManager {
    private Handler timerHandler = new Handler();
    private Timer timer;
    private TimerTask timerTask;
    private Context context;
    private WebView webView;
    private OnWebInteractionListener mListener;

    @SuppressLint(value={"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebManager(Context context, OnWebInteractionListener listener) {
        this.context = context;
        this.mListener = listener;
        this.initWebView();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = new WebView(this.context);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        this.webView.addJavascriptInterface((Object)new ScrapInterface(html -> this.mListener.showHtml(html)), "HtmlViewer");
        this.webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.getSettings().setMixedContentMode(2);
        }
        this.webView.setLayerType(1, null);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                WebManager.this.stopTimer();
                if (Build.VERSION.SDK_INT >= 23) {
                    WebManager.this.mListener.onReceivedError(error.getDescription().toString());
                } else {
                    WebManager.this.mListener.onReceivedError(error.toString());
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WebManager.this.stopTimer();
                if ("about:blank".equals(url) && view.getTag() != null) {
                    WebManager.this.loadUrl(view.getTag().toString());
                    return;
                }
                view.setTag((Object)url);
                WebManager.this.mListener.onPageFinished(view, url);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                result.confirm();
                return true;
            }
        });
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void loadUrl(String urlOrScripts) {
        Log.i((String)"loadWebView", (String)("url :" + urlOrScripts));
        this.startTimer();
        this.webView.loadUrl(urlOrScripts, null);
    }

    public WebView getWebView() {
        return this.webView;
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebManager.this.timerHandler.post(() -> WebManager.this.mListener.onTimeOut());
            }
        };
        this.timer.schedule(this.timerTask, this.mListener.getTimeOut());
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    public static interface OnWebInteractionListener {
        public int getTimeOut();

        public void onTimeOut();

        public void showHtml(String var1);

        public void checkHtml(String var1);

        public void onReceivedError(String var1);

        public void onPageFinished(WebView var1, String var2);
    }
}

